/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import androidx.annotation.RequiresApi;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.Util;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.KeysetInfo;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Base64;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;

public final class JsonKeysetReader
implements KeysetReader {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final InputStream inputStream;
    private final JsonObject json;
    private boolean urlSafeBase64 = false;

    private JsonKeysetReader(InputStream inputStream) {
        this.inputStream = inputStream;
        this.json = null;
    }

    public static KeysetReader withInputStream(InputStream input) throws IOException {
        return new JsonKeysetReader(input);
    }

    @Deprecated
    public static JsonKeysetReader withJsonObject(Object input) {
        return JsonKeysetReader.withString(input.toString());
    }

    public static JsonKeysetReader withString(String input) {
        return new JsonKeysetReader(new ByteArrayInputStream(input.getBytes(UTF_8)));
    }

    public static JsonKeysetReader withBytes(byte[] bytes) {
        return new JsonKeysetReader(new ByteArrayInputStream(bytes));
    }

    public static JsonKeysetReader withFile(File file) throws IOException {
        File file2 = file;
        FileInputStream fileInputStream = new FileInputStream(file2);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file2, (String)"com.google.crypto.tink.JsonKeysetReader");
        return new JsonKeysetReader(fileInputStream);
    }

    public static JsonKeysetReader withPath(String path) throws IOException {
        return JsonKeysetReader.withFile(new File(path));
    }

    @RequiresApi(value=26)
    public static JsonKeysetReader withPath(Path path) throws IOException {
        return JsonKeysetReader.withFile(path.toFile());
    }

    public JsonKeysetReader withUrlSafeBase64() {
        this.urlSafeBase64 = true;
        return this;
    }

    @Override
    public Keyset read() throws IOException {
        try {
            if (this.json != null) {
                Keyset keyset = this.keysetFromJson(this.json);
                return keyset;
            }
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(new String(Util.readAll(this.inputStream), UTF_8)));
            jsonReader.setLenient(false);
            Keyset keyset = this.keysetFromJson(Streams.parse((JsonReader)jsonReader).getAsJsonObject());
            return keyset;
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new IOException(e);
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }

    @Override
    public EncryptedKeyset readEncrypted() throws IOException {
        try {
            if (this.json != null) {
                EncryptedKeyset encryptedKeyset = this.encryptedKeysetFromJson(this.json);
                return encryptedKeyset;
            }
            EncryptedKeyset encryptedKeyset = this.encryptedKeysetFromJson(JsonParser.parseString((String)new String(Util.readAll(this.inputStream), UTF_8)).getAsJsonObject());
            return encryptedKeyset;
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new IOException(e);
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }

    private Keyset keysetFromJson(JsonObject json) {
        JsonKeysetReader.validateKeyset(json);
        Keyset.Builder builder = Keyset.newBuilder();
        if (json.has("primaryKeyId")) {
            builder.setPrimaryKeyId(json.get("primaryKeyId").getAsInt());
        }
        JsonArray keys = json.getAsJsonArray("key");
        for (int i = 0; i < keys.size(); ++i) {
            builder.addKey(this.keyFromJson(keys.get(i).getAsJsonObject()));
        }
        return builder.build();
    }

    private EncryptedKeyset encryptedKeysetFromJson(JsonObject json) {
        JsonKeysetReader.validateEncryptedKeyset(json);
        byte[] encryptedKeyset = this.urlSafeBase64 ? Base64.urlSafeDecode(json.get("encryptedKeyset").getAsString()) : Base64.decode(json.get("encryptedKeyset").getAsString());
        if (json.has("keysetInfo")) {
            return EncryptedKeyset.newBuilder().setEncryptedKeyset(ByteString.copyFrom((byte[])encryptedKeyset)).setKeysetInfo(JsonKeysetReader.keysetInfoFromJson(json.getAsJsonObject("keysetInfo"))).build();
        }
        return EncryptedKeyset.newBuilder().setEncryptedKeyset(ByteString.copyFrom((byte[])encryptedKeyset)).build();
    }

    private Keyset.Key keyFromJson(JsonObject json) {
        JsonKeysetReader.validateKey(json);
        return Keyset.Key.newBuilder().setStatus(JsonKeysetReader.getStatus(json.get("status").getAsString())).setKeyId(json.get("keyId").getAsInt()).setOutputPrefixType(JsonKeysetReader.getOutputPrefixType(json.get("outputPrefixType").getAsString())).setKeyData(this.keyDataFromJson(json.getAsJsonObject("keyData"))).build();
    }

    private static KeysetInfo keysetInfoFromJson(JsonObject json) {
        KeysetInfo.Builder builder = KeysetInfo.newBuilder();
        if (json.has("primaryKeyId")) {
            builder.setPrimaryKeyId(json.get("primaryKeyId").getAsInt());
        }
        if (json.has("keyInfo")) {
            JsonArray keyInfos = json.getAsJsonArray("keyInfo");
            for (int i = 0; i < keyInfos.size(); ++i) {
                builder.addKeyInfo(JsonKeysetReader.keyInfoFromJson(keyInfos.get(i).getAsJsonObject()));
            }
        }
        return builder.build();
    }

    private static KeysetInfo.KeyInfo keyInfoFromJson(JsonObject json) {
        return KeysetInfo.KeyInfo.newBuilder().setStatus(JsonKeysetReader.getStatus(json.get("status").getAsString())).setKeyId(json.get("keyId").getAsInt()).setOutputPrefixType(JsonKeysetReader.getOutputPrefixType(json.get("outputPrefixType").getAsString())).setTypeUrl(json.get("typeUrl").getAsString()).build();
    }

    private KeyData keyDataFromJson(JsonObject json) {
        JsonKeysetReader.validateKeyData(json);
        byte[] value = this.urlSafeBase64 ? Base64.urlSafeDecode(json.get("value").getAsString()) : Base64.decode(json.get("value").getAsString());
        return KeyData.newBuilder().setTypeUrl(json.get("typeUrl").getAsString()).setValue(ByteString.copyFrom((byte[])value)).setKeyMaterialType(JsonKeysetReader.getKeyMaterialType(json.get("keyMaterialType").getAsString())).build();
    }

    private static KeyStatusType getStatus(String status) {
        switch (status) {
            case "ENABLED": {
                return KeyStatusType.ENABLED;
            }
            case "DISABLED": {
                return KeyStatusType.DISABLED;
            }
            case "DESTROYED": {
                return KeyStatusType.DESTROYED;
            }
        }
        throw new JsonParseException("unknown status: " + status);
    }

    private static OutputPrefixType getOutputPrefixType(String type) {
        switch (type) {
            case "TINK": {
                return OutputPrefixType.TINK;
            }
            case "RAW": {
                return OutputPrefixType.RAW;
            }
            case "LEGACY": {
                return OutputPrefixType.LEGACY;
            }
            case "CRUNCHY": {
                return OutputPrefixType.CRUNCHY;
            }
        }
        throw new JsonParseException("unknown output prefix type: " + type);
    }

    private static KeyData.KeyMaterialType getKeyMaterialType(String type) {
        switch (type) {
            case "SYMMETRIC": {
                return KeyData.KeyMaterialType.SYMMETRIC;
            }
            case "ASYMMETRIC_PRIVATE": {
                return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
            }
            case "ASYMMETRIC_PUBLIC": {
                return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
            }
            case "REMOTE": {
                return KeyData.KeyMaterialType.REMOTE;
            }
        }
        throw new JsonParseException("unknown key material type: " + type);
    }

    private static void validateKeyset(JsonObject json) {
        if (!json.has("key") || json.getAsJsonArray("key").size() == 0) {
            throw new JsonParseException("invalid keyset");
        }
    }

    private static void validateEncryptedKeyset(JsonObject json) {
        if (!json.has("encryptedKeyset")) {
            throw new JsonParseException("invalid encrypted keyset");
        }
    }

    private static void validateKey(JsonObject json) {
        if (!(json.has("keyData") && json.has("status") && json.has("keyId") && json.has("outputPrefixType"))) {
            throw new JsonParseException("invalid key");
        }
    }

    private static void validateKeyData(JsonObject json) {
        if (!(json.has("typeUrl") && json.has("value") && json.has("keyMaterialType"))) {
            throw new JsonParseException("invalid keyData");
        }
    }
}

