/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.MergingException;
import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergeType;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.OrphanXmlElement;
import com.android.manifmerger.OtherOperationType;
import com.android.manifmerger.Selector;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlNode;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlElement
extends OrphanXmlElement {
    private final XmlDocument mDocument;
    private ElementOperationsAndMergeRuleMarkers mSelectorsAndMergeRuleMarkers;
    private ImmutableList<XmlAttribute> mAttributes;
    private ImmutableList<XmlElement> mMergeableChildren = ImmutableList.of();

    public XmlElement(Element xml, XmlDocument document) {
        super(xml, document.getModel());
        this.mDocument = (XmlDocument)Preconditions.checkNotNull((Object)document);
        NamedNodeMap namedNodeMap = this.getXml().getAttributes();
        this.mSelectorsAndMergeRuleMarkers = this.extractOperationAndSelectors(namedNodeMap);
        this.mAttributes = this.buildXmlAttributes(namedNodeMap);
        this.mMergeableChildren = this.initMergeableChildren();
    }

    private Optional<XmlElement> getFirstChildElementOfType(ManifestModel.NodeTypes nodeType) {
        for (XmlElement childElement : this.getMergeableElements()) {
            if (!childElement.getType().equals((Object)nodeType)) continue;
            return Optional.of(childElement);
        }
        return Optional.empty();
    }

    public void applyToFirstChildElementOfType(ManifestModel.NodeTypes nodeType, Consumer<XmlElement> nodeConsumer) {
        Optional<XmlElement> childElementByType = this.getFirstChildElementOfType(nodeType);
        childElementByType.ifPresent(nodeConsumer);
    }

    public boolean elementUsesNamespacePrefix(String prefix) {
        return XmlElement.elementUsesNamespacePrefix(this.getXml(), prefix);
    }

    private static boolean elementUsesNamespacePrefix(Element element, String prefix) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            if (!prefix.equals(attribute.getPrefix())) continue;
            return true;
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !XmlElement.elementUsesNamespacePrefix((Element)childNode, prefix)) continue;
            return true;
        }
        return false;
    }

    private ElementOperationsAndMergeRuleMarkers extractOperationAndSelectors(NamedNodeMap namedNodeMap) {
        Selector selector = null;
        ImmutableList overrideUsesSdkLibrarySelectors = ImmutableList.of();
        ImmutableMap.Builder attributeOperationTypeBuilder = ImmutableMap.builder();
        NodeOperationType lastNodeOperationType = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            AttributeOperationType attributeOperationType;
            Node attribute = namedNodeMap.item(i);
            if (!"http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) continue;
            String instruction = attribute.getLocalName();
            if (instruction.equals("node")) {
                lastNodeOperationType = NodeOperationType.valueOf(SdkUtils.camelCaseToConstantName((String)attribute.getNodeValue()));
                continue;
            }
            if (instruction.equals("requiredByPrivacySandboxSdk")) continue;
            if (instruction.equals("selector")) {
                selector = new Selector(attribute.getNodeValue());
                continue;
            }
            if (instruction.equals("overrideLibrary")) {
                String nodeValue = attribute.getNodeValue();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String selectorValue : Splitter.on((char)',').split((CharSequence)nodeValue)) {
                    builder.add((Object)new Selector(selectorValue.trim()));
                }
                overrideUsesSdkLibrarySelectors = builder.build();
                continue;
            }
            try {
                attributeOperationType = AttributeOperationType.valueOf(SdkUtils.xmlNameToConstantName((String)instruction));
            }
            catch (IllegalArgumentException e) {
                try {
                    OtherOperationType.valueOf(instruction.toLowerCase(Locale.ROOT));
                    continue;
                }
                catch (IllegalArgumentException e1) {
                    String errorMessage = String.format("Invalid instruction '%1$s', valid instructions are : %2$s", instruction, Joiner.on((char)',').join((Object[])AttributeOperationType.values()));
                    throw new RuntimeException((Throwable)MergingException.wrapException((Throwable)e).withMessage(errorMessage, new Object[0]).withFile(this.mDocument.getSourceFile()).withPosition(XmlDocument.getNodePosition(this.getXml())).build());
                }
            }
            for (Object attributeName : Splitter.on((char)',').trimResults().split((CharSequence)attribute.getNodeValue())) {
                if (((String)attributeName).indexOf(58) == -1) {
                    String toolsPrefix = XmlUtils.lookupNamespacePrefix((Node)this.getXml(), (String)"http://schemas.android.com/tools", (String)"android", (boolean)false);
                    attributeName = toolsPrefix + ":" + (String)attributeName;
                }
                XmlNode.NodeName nodeName = XmlNode.fromXmlName((String)attributeName);
                attributeOperationTypeBuilder.put((Object)nodeName, (Object)attributeOperationType);
            }
        }
        return new ElementOperationsAndMergeRuleMarkers(lastNodeOperationType, (Map<XmlNode.NodeName, AttributeOperationType>)attributeOperationTypeBuilder.build(), selector, (List<Selector>)overrideUsesSdkLibrarySelectors);
    }

    private ImmutableList<XmlAttribute> buildXmlAttributes(NamedNodeMap namedNodeMap) {
        ImmutableList.Builder attributesListBuilder = ImmutableList.builder();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attribute = (Attr)namedNodeMap.item(i);
            attributesListBuilder.add((Object)XmlAttribute.createXmlAttribute(this, attribute));
        }
        return attributesListBuilder.build();
    }

    public XmlDocument getDocument() {
        return this.mDocument;
    }

    public List<XmlAttribute> getAttributes() {
        return this.mAttributes;
    }

    public Node removeChild(Node oldChild) {
        Node nodeBeingDeleted = this.getXml().removeChild(oldChild);
        if (oldChild instanceof Element) {
            this.mMergeableChildren = this.initMergeableChildren();
        }
        return nodeBeingDeleted;
    }

    public Node removeChild(XmlElement oldChild) {
        return this.removeChild(oldChild.getXml());
    }

    public int getAttributeCount() {
        return this.getXml().getAttributes().getLength();
    }

    public ImmutableList<String> getAttributeNames(Predicate<Node> nodePredicate) {
        NamedNodeMap attributes = this.getXml().getAttributes();
        ImmutableList.Builder extraAttributeNames = new ImmutableList.Builder();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (!nodePredicate.test(item)) continue;
            extraAttributeNames.add((Object)item.getNodeName());
        }
        return extraAttributeNames.build();
    }

    public Node insertBefore(Node newChild, Node refChild) {
        Node nodeBeingInserted = this.getXml().insertBefore(newChild, refChild);
        if (nodeBeingInserted instanceof Element) {
            this.mMergeableChildren = this.initMergeableChildren();
        }
        return nodeBeingInserted;
    }

    public Node insertBefore(XmlElement newChild, Node refChild) {
        return this.insertBefore(newChild.getXml(), refChild);
    }

    public Node appendChild(XmlElement newChild) {
        return this.appendChild(newChild.getXml());
    }

    public Node appendChild(Node newChild) {
        Node nodeBeingAppended = this.getXml().appendChild(newChild);
        if (nodeBeingAppended instanceof Element) {
            this.mMergeableChildren = this.initMergeableChildren();
        }
        return nodeBeingAppended;
    }

    public XmlElement addChildElement(String childTagName) {
        XmlDocument document = this.getDocument();
        Element childElement = document.getXml().createElement(childTagName);
        Node appendedChild = this.appendChild(childElement);
        if (!(appendedChild instanceof Element)) {
            throw new RuntimeException(String.format("Unable to add %s element to %s element.", childTagName, this.getTagName()));
        }
        return this.findMergeableChild((Element)appendedChild).orElseThrow();
    }

    public void addChildElementWithSingleAttribute(String childTagName, String nsUri, String attrName, String attrValue) {
        XmlElement childXmlElement = this.addChildElement(childTagName);
        String prefix = XmlUtils.lookupNamespacePrefix((Node)childXmlElement.getXml(), (String)nsUri, (boolean)true);
        childXmlElement.setAttributeNS(nsUri, prefix + ":" + attrName, attrValue);
    }

    public Optional<XmlElement> findMergeableChild(Element childElement) {
        return this.mMergeableChildren.stream().filter((Predicate<XmlElement> & Serializable)xmlElement -> xmlElement.getXml().isSameNode(childElement)).findAny();
    }

    public XmlElement createOrGetElementOfType(XmlDocument document, ManifestModel.NodeTypes nodeType, Consumer<XmlElement> postCreationAction) {
        Optional<XmlElement> optionalXmlElement = this.getFirstChildElementOfType(nodeType);
        if (optionalXmlElement.isPresent()) {
            return optionalXmlElement.get();
        }
        String elementName = document.getModel().toXmlName(nodeType);
        Element node = this.getXml().getOwnerDocument().createElement(elementName);
        this.appendChild(node);
        this.initMergeableChildren();
        XmlElement createdXmlElement = this.getFirstChildElementOfType(nodeType).get();
        postCreationAction.accept(createdXmlElement);
        return createdXmlElement;
    }

    public void setAttribute(String name, String value) {
        this.getXml().setAttribute(name, value);
        Attr attribute = this.getXml().getAttributeNode(name);
        this.checkAndUpdateXmlAttributesAndMergeRuleMarkers(attribute.getNamespaceURI());
    }

    public void setAttribute(XmlAttribute attribute, String value) {
        attribute.getXml().setValue(value);
        if ("http://schemas.android.com/tools".equals(attribute.getXml().getNamespaceURI())) {
            this.mSelectorsAndMergeRuleMarkers = this.extractOperationAndSelectors(this.getXml().getAttributes());
        }
    }

    public void addAttribute(XmlAttribute attribute, String value) {
        attribute.getName().addToNode(this.getXml(), value);
        this.checkAndUpdateXmlAttributesAndMergeRuleMarkers(attribute.getXml().getNamespaceURI());
    }

    public void addAttribute(String nsUri, String attrName, String attrValue) {
        String prefix = XmlUtils.lookupNamespacePrefix((Node)this.getXml(), (String)nsUri, (boolean)true);
        this.setAttributeNS(nsUri, prefix + ":" + attrName, attrValue);
    }

    private void checkAndUpdateXmlAttributesAndMergeRuleMarkers(String affectedAttributeNamespace) {
        NamedNodeMap namedNodeMap = this.getXml().getAttributes();
        if ("http://schemas.android.com/tools".equals(affectedAttributeNamespace)) {
            this.mSelectorsAndMergeRuleMarkers = this.extractOperationAndSelectors(namedNodeMap);
        }
        this.mAttributes = this.buildXmlAttributes(namedNodeMap);
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        this.getXml().removeAttributeNS(namespaceURI, localName);
        this.checkAndUpdateXmlAttributesAndMergeRuleMarkers(namespaceURI);
    }

    public void removeAttribute(String name) {
        String attributeNamespaceUri = Optional.ofNullable(this.getXml().getAttributeNode(name)).map(Node::getNamespaceURI).orElse(null);
        this.getXml().removeAttribute(name);
        this.checkAndUpdateXmlAttributesAndMergeRuleMarkers(attributeNamespaceUri);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.getXml().setAttributeNS(namespaceURI, qualifiedName, value);
        this.checkAndUpdateXmlAttributesAndMergeRuleMarkers(namespaceURI);
    }

    public Optional<XmlAttribute> getAttribute(XmlNode.NodeName attributeName) {
        for (XmlAttribute xmlAttribute : this.mAttributes) {
            if (!xmlAttribute.getName().equals(attributeName)) continue;
            return Optional.of(xmlAttribute);
        }
        return Optional.empty();
    }

    public NodeOperationType getOperationType() {
        return this.mSelectorsAndMergeRuleMarkers.getNodeOperationType() != null ? this.mSelectorsAndMergeRuleMarkers.getNodeOperationType() : NodeOperationType.MERGE;
    }

    public AttributeOperationType getAttributeOperationType(XmlNode.NodeName attributeName) {
        return this.mSelectorsAndMergeRuleMarkers.getAttributesOperationTypes().getOrDefault(attributeName, AttributeOperationType.STRICT);
    }

    public Collection<Map.Entry<XmlNode.NodeName, AttributeOperationType>> getAttributeOperations() {
        return this.mSelectorsAndMergeRuleMarkers.getAttributesOperationTypes().entrySet();
    }

    public List<Selector> getOverrideUsesSdkLibrarySelectors() {
        return this.mSelectorsAndMergeRuleMarkers.getOverrideUsesSdkLibrarySelectors();
    }

    @Override
    public SourcePosition getPosition() {
        return XmlDocument.getNodePosition(this);
    }

    @Override
    public SourceFile getSourceFile() {
        return this.mDocument.getSourceFile();
    }

    public void mergeWithLowerPriorityNode(XmlElement lowerPriorityNode, MergingReport.Builder mergingReport) {
        if (this.mSelectorsAndMergeRuleMarkers.getSelector() != null && !this.mSelectorsAndMergeRuleMarkers.getSelector().isResolvable(this.getDocument().getSelectors())) {
            mergingReport.addMessage(this.getSourceFilePosition(), MergingReport.Record.Severity.ERROR, String.format("'tools:selector=\"%1$s\"' is not a valid library identifier, valid identifiers are : %2$s", this.mSelectorsAndMergeRuleMarkers.getSelector().toString(), Joiner.on((char)',').join(this.mDocument.getSelectors().getKeys())));
            return;
        }
        mergingReport.getLogger().verbose("Merging " + this.getId() + " with lower " + lowerPriorityNode.printPosition(), new Object[0]);
        MergeType mergeType = this.getType().getMergeType();
        if (this.isA(ManifestModel.NodeTypes.MANIFEST) && lowerPriorityNode.getDocument().getFileType() != XmlDocument.Type.LIBRARY) {
            mergeType = MergeType.MERGE;
        }
        mergingReport.getActionRecorder().recordNodeAction(lowerPriorityNode, Actions.ActionType.MERGED);
        if (mergeType != MergeType.MERGE_CHILDREN_ONLY) {
            ArrayList<AttributeModel> attributeModels = new ArrayList<AttributeModel>((Collection<AttributeModel>)lowerPriorityNode.getType().getAttributeModels());
            for (XmlAttribute lowerPriorityAttribute : lowerPriorityNode.getAttributes()) {
                lowerPriorityAttribute.mergeInHigherPriorityElement(this, mergingReport);
                if (lowerPriorityAttribute.getModel() == null) continue;
                attributeModels.remove(lowerPriorityAttribute.getModel());
            }
            for (AttributeModel attributeModel : attributeModels) {
                if (attributeModel.getDefaultValue() == null) continue;
                Optional<XmlAttribute> myAttribute = this.getAttribute(attributeModel.getName());
                myAttribute.ifPresent((Consumer<XmlAttribute> & Serializable)xmlAttribute -> xmlAttribute.mergeWithLowerPriorityDefaultValue(mergingReport, lowerPriorityNode));
            }
        }
        if (this.mSelectorsAndMergeRuleMarkers.getNodeOperationType() != NodeOperationType.MERGE_ONLY_ATTRIBUTES) {
            this.mergeChildren(lowerPriorityNode, mergingReport);
        } else {
            for (XmlElement lowerPriorityChild : lowerPriorityNode.getMergeableElements()) {
                mergingReport.getActionRecorder().recordNodeAction(this, Actions.ActionType.REJECTED, lowerPriorityChild);
            }
        }
    }

    public ImmutableList<XmlElement> getMergeableElements() {
        return this.mMergeableChildren;
    }

    public Optional<XmlElement> getNodeByTypeAndKey(ManifestModel.NodeTypes type, String keyValue) {
        for (XmlElement xmlElement : this.mMergeableChildren) {
            if (!xmlElement.isA(type) || keyValue != null && !keyValue.equals(xmlElement.getKey())) continue;
            return Optional.of(xmlElement);
        }
        return Optional.empty();
    }

    public ImmutableList<XmlElement> getAllNodesByType(ManifestModel.NodeTypes type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (XmlElement mergeableChild : this.mMergeableChildren) {
            if (!mergeableChild.isA(type)) continue;
            listBuilder.add((Object)mergeableChild);
        }
        return listBuilder.build();
    }

    public void mergeChildren(XmlElement lowerPriorityNode, MergingReport.Builder mergingReport) {
        Map matchingChildNodes = lowerPriorityNode.getMergeableElements().stream().collect(Collectors.toMap(java.util.function.Function.identity(), (java.util.function.Function<XmlElement, Optional> & Serializable)node -> this.getNodeByTypeAndKey(node.getType(), node.getKey())));
        for (XmlElement lowerPriorityChild : lowerPriorityNode.getMergeableElements()) {
            if (this.shouldIgnore(lowerPriorityChild, mergingReport)) continue;
            this.mergeChild(lowerPriorityChild, mergingReport, (Optional)matchingChildNodes.get(lowerPriorityChild));
        }
    }

    public boolean supportsSelector() {
        return this.getOperationType().isSelectable();
    }

    public void enforceNamespaceDeclaration(String nsUri, String defaultPrefix) {
        XmlUtils.lookupNamespacePrefix((Node)this.getXml(), (String)nsUri, (String)defaultPrefix, (boolean)true);
    }

    private void mergeChild(XmlElement lowerPriorityChild, MergingReport.Builder mergingReport, Optional<XmlElement> thisChildOptional) {
        ILogger logger = mergingReport.getLogger();
        if (lowerPriorityChild.getType() == ManifestModel.NodeTypes.CUSTOM) {
            this.handleCustomElement(lowerPriorityChild, mergingReport);
            return;
        }
        if (thisChildOptional.isEmpty()) {
            this.addElement(lowerPriorityChild, mergingReport);
            return;
        }
        logger.verbose(lowerPriorityChild.getId() + " defined in both files...", new Object[0]);
        XmlElement thisChild = thisChildOptional.get();
        switch (thisChild.getType().getMergeType()) {
            case CONFLICT: {
                mergingReport.addMessage(this, MergingReport.Record.Severity.ERROR, String.format("Node %1$s cannot be present in more than one input file and it's present at %2$s and %3$s", new Object[]{thisChild.getType(), thisChild.printPosition(), lowerPriorityChild.printPosition()}));
                break;
            }
            case ALWAYS: {
                NodeOperationType operationType = XmlElement.calculateNodeOperationType(thisChild, lowerPriorityChild);
                if (operationType == NodeOperationType.REMOVE || operationType == NodeOperationType.REPLACE) {
                    mergingReport.getActionRecorder().recordNodeAction(thisChild, Actions.ActionType.REJECTED, lowerPriorityChild);
                    break;
                }
                if (thisChild.getType().areMultipleDeclarationAllowed()) {
                    this.mergeChildrenWithMultipleDeclarations(lowerPriorityChild, mergingReport);
                    break;
                }
                if (thisChild.isEquals(lowerPriorityChild)) break;
                this.addElement(lowerPriorityChild, mergingReport);
                break;
            }
            default: {
                this.handleTwoElementsExistence(thisChild, lowerPriorityChild, mergingReport);
            }
        }
    }

    private void handleCustomElement(XmlElement customElement, MergingReport.Builder mergingReport) {
        this.addElement(customElement, mergingReport);
        String nodeName = customElement.getXml().getNodeName();
        if (!nodeName.contains(":")) {
            return;
        }
        String prefix = nodeName.substring(0, nodeName.indexOf(58));
        String namespace = customElement.getDocument().getRootNode().getXml().getAttribute("xmlns:" + prefix);
        if (namespace != null) {
            this.getDocument().getRootNode().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        }
    }

    private void mergeChildrenWithMultipleDeclarations(XmlElement lowerPriorityChild, MergingReport.Builder mergingReport) {
        Preconditions.checkArgument((boolean)lowerPriorityChild.getType().areMultipleDeclarationAllowed());
        if (lowerPriorityChild.getType().areMultipleDeclarationAllowed()) {
            for (XmlElement sameTypeChild : this.getAllNodesByType(lowerPriorityChild.getType())) {
                if (!sameTypeChild.getId().equals(lowerPriorityChild.getId()) || !sameTypeChild.isEquals(lowerPriorityChild)) continue;
                return;
            }
        }
        this.addElement(lowerPriorityChild, mergingReport);
    }

    private boolean shouldIgnore(XmlElement lowerPriorityChild, MergingReport.Builder mergingReport) {
        boolean shouldDelete;
        if (lowerPriorityChild.getType().getMergeType() == MergeType.IGNORE) {
            return true;
        }
        if (!lowerPriorityChild.getType().canMergeWithLowerPriority(lowerPriorityChild)) {
            return true;
        }
        Optional<XmlElement> thisChildElementOptional = this.getNodeByTypeAndKey(lowerPriorityChild.getType(), null);
        if (!thisChildElementOptional.isPresent()) {
            return false;
        }
        XmlElement thisChild = thisChildElementOptional.get();
        boolean bl = shouldDelete = thisChild.mSelectorsAndMergeRuleMarkers.getNodeOperationType() == NodeOperationType.REMOVE_ALL && (thisChild.mSelectorsAndMergeRuleMarkers.getSelector() == null || thisChild.mSelectorsAndMergeRuleMarkers.getSelector().appliesTo(lowerPriorityChild));
        if (shouldDelete) {
            mergingReport.getActionRecorder().recordNodeAction(thisChild, Actions.ActionType.REJECTED, lowerPriorityChild);
        }
        return shouldDelete;
    }

    private void handleTwoElementsExistence(XmlElement higherPriority, XmlElement lowerPriority, MergingReport.Builder mergingReport) {
        NodeOperationType operationType = XmlElement.calculateNodeOperationType(higherPriority, lowerPriority);
        switch (operationType) {
            case MERGE: 
            case MERGE_ONLY_ATTRIBUTES: {
                mergingReport.getActionRecorder().recordNodeAction(higherPriority, Actions.ActionType.MERGED, lowerPriority);
                higherPriority.mergeWithLowerPriorityNode(lowerPriority, mergingReport);
                break;
            }
            case REMOVE: 
            case REPLACE: {
                mergingReport.getActionRecorder().recordNodeAction(higherPriority, Actions.ActionType.REJECTED, lowerPriority);
                break;
            }
            case STRICT: {
                Optional<String> compareMessage = higherPriority.compareTo(lowerPriority);
                compareMessage.ifPresent((Consumer<String> & Serializable)s -> mergingReport.addMessage(this, MergingReport.Record.Severity.ERROR, String.format("Node %1$s at %2$s is tagged with tools:node=\"strict\", yet %3$s at %4$s is different : %5$s", higherPriority.getId(), higherPriority.printPosition(), lowerPriority.getId(), lowerPriority.printPosition(), s)));
                break;
            }
            default: {
                mergingReport.getLogger().error(null, "Unhandled node operation type %s", new Object[]{higherPriority.getOperationType()});
            }
        }
    }

    private static NodeOperationType calculateNodeOperationType(XmlElement higherPriority, XmlElement lowerPriority) {
        NodeOperationType operationType = higherPriority.getOperationType();
        if (lowerPriority.mSelectorsAndMergeRuleMarkers.getNodeOperationType() != null) {
            if (higherPriority.getOperationType() == NodeOperationType.MERGE && (lowerPriority.mSelectorsAndMergeRuleMarkers.getNodeOperationType() == NodeOperationType.REMOVE || lowerPriority.mSelectorsAndMergeRuleMarkers.getNodeOperationType() == NodeOperationType.REMOVE_ALL)) {
                operationType = NodeOperationType.REPLACE;
            }
            if (higherPriority.getDocument().originalNodeOperation.get(higherPriority.getXml()) == null) {
                higherPriority.getDocument().originalNodeOperation.put(higherPriority.getXml(), higherPriority.getOperationType());
            }
            higherPriority.setAttributeNS("http://schemas.android.com/tools", "tools:node", lowerPriority.mSelectorsAndMergeRuleMarkers.getNodeOperationType().toString().toLowerCase(Locale.US));
        }
        if (higherPriority.supportsSelector() && higherPriority.mSelectorsAndMergeRuleMarkers.getSelector() != null && !higherPriority.mSelectorsAndMergeRuleMarkers.getSelector().appliesTo(lowerPriority)) {
            operationType = NodeOperationType.MERGE;
        }
        return operationType;
    }

    private void addElement(XmlElement elementToBeAdded, MergingReport.Builder mergingReport) {
        List<Node> comments = XmlElement.getLeadingComments(elementToBeAdded.getXml());
        mergingReport.getActionRecorder().recordAddedNodeAction(elementToBeAdded, false);
        Node node = this.getXml().getOwnerDocument().importNode(elementToBeAdded.getXml(), true);
        this.appendChild(node);
        for (Node comment : comments) {
            Node newComment = this.getXml().getOwnerDocument().adoptNode(comment);
            this.insertBefore(newComment, node);
        }
        mergingReport.getLogger().verbose("Adopted " + node, new Object[0]);
    }

    public boolean isEquals(XmlElement otherNode) {
        return !this.compareTo(otherNode).isPresent();
    }

    public Selector getSelector() {
        return this.mSelectorsAndMergeRuleMarkers.getSelector();
    }

    public Optional<String> compareTo(Object other) {
        Optional<String> message;
        if (!(other instanceof XmlElement)) {
            return Optional.of("Wrong type");
        }
        XmlElement otherNode = (XmlElement)other;
        if (this.getXml().getNamespaceURI() != null) {
            if (!this.getXml().getLocalName().equals(otherNode.getXml().getLocalName())) {
                return Optional.of(String.format("Element names do not match: %1$s versus %2$s", this.getXml().getLocalName(), otherNode.getXml().getLocalName()));
            }
            String thisNS = this.getXml().getNamespaceURI();
            String otherNS = otherNode.getXml().getNamespaceURI();
            if (thisNS == null && otherNS != null || thisNS != null && !thisNS.equals(otherNS)) {
                return Optional.of(String.format("Element namespaces names do not match: %1$s versus %2$s", thisNS, otherNS));
            }
        } else if (!this.getXml().getNodeName().equals(otherNode.getXml().getNodeName())) {
            return Optional.of(String.format("Element names do not match: %1$s versus %2$s", this.getXml().getNodeName(), otherNode.getXml().getNodeName()));
        }
        if ((message = XmlElement.checkAttributes(this, otherNode)).isPresent()) {
            return message;
        }
        message = XmlElement.checkAttributes(otherNode, this);
        if (message.isPresent()) {
            return message;
        }
        List<Node> expectedChildren = XmlElement.filterUninterestingNodes(this.getXml().getChildNodes());
        List<Node> actualChildren = XmlElement.filterUninterestingNodes(otherNode.getXml().getChildNodes());
        int actualChildrenSize = actualChildren.size();
        int expectedChildrenSize = expectedChildren.size();
        if (expectedChildrenSize != actualChildrenSize) {
            if (expectedChildrenSize > actualChildren.size()) {
                List missingChildrenNames = Lists.transform(expectedChildren, (Function)NODE_TO_NAME);
                Lists.transform(actualChildren, (Function)NODE_TO_NAME).forEach(missingChildrenNames::remove);
                return Optional.of(String.format("%1$s: Number of children do not match up: expected %2$d versus %3$d at %4$s, missing %5$s", this.getId(), expectedChildrenSize, actualChildren.size(), otherNode.printPosition(), Joiner.on((String)",").join((Iterable)missingChildrenNames)));
            }
            List extraChildrenNames = Lists.transform(actualChildren, (Function)NODE_TO_NAME);
            Lists.transform(expectedChildren, (Function)NODE_TO_NAME).forEach(extraChildrenNames::remove);
            return Optional.of(String.format("%1$s: Number of children do not match up: expected %2$d versus %3$d at %4$s, extra elements found : %5$s", this.getId(), expectedChildrenSize, actualChildrenSize, otherNode.printPosition(), Joiner.on((String)",").join((Iterable)extraChildrenNames)));
        }
        for (Node expectedChild : expectedChildren) {
            XmlElement expectedChildNode;
            if (expectedChild.getNodeType() != 1 || !(message = this.findAndCompareNode(otherNode, actualChildren, expectedChildNode = new XmlElement((Element)expectedChild, this.mDocument))).isPresent()) continue;
            return message;
        }
        return Optional.empty();
    }

    private Optional<String> findAndCompareNode(XmlElement otherElement, List<Node> otherElementChildren, XmlElement childNode) {
        Optional<String> message = Optional.empty();
        for (Node potentialNode : otherElementChildren) {
            if (potentialNode.getNodeType() != 1) continue;
            XmlElement otherChildNode = new XmlElement((Element)potentialNode, this.mDocument);
            if (childNode.getType() != otherChildNode.getType()) continue;
            if (childNode.getType().areMultipleDeclarationAllowed() || childNode.getType().getNodeKeyResolver().getKeyAttributesNames().isEmpty()) {
                message = childNode.compareTo(otherChildNode);
                if (message.isPresent()) continue;
                return Optional.empty();
            }
            if (!(childNode.getKey() == null ? otherChildNode.getKey() == null : childNode.getKey().equals(otherChildNode.getKey()))) continue;
            return childNode.compareTo(otherChildNode);
        }
        return message.isPresent() ? message : Optional.of(String.format("Child %1$s not found in document %2$s", childNode.getId(), otherElement.printPosition()));
    }

    private static List<Node> filterUninterestingNodes(NodeList nodeList) {
        ArrayList<Node> interestingNodes = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                Text t = (Text)node;
                if (t.getData().trim().isEmpty()) continue;
                interestingNodes.add(node);
                continue;
            }
            if (node.getNodeType() == 8) continue;
            interestingNodes.add(node);
        }
        return interestingNodes;
    }

    private static Optional<String> checkAttributes(XmlElement expected, XmlElement actual) {
        for (XmlAttribute expectedAttr : expected.getAttributes()) {
            XmlNode.NodeName attributeName = expectedAttr.getName();
            if (attributeName.isInNamespace("http://schemas.android.com/tools")) continue;
            Optional<XmlAttribute> actualAttr = actual.getAttribute(attributeName);
            if (actualAttr.isPresent()) {
                if (expectedAttr.getValue().equals(actualAttr.get().getValue())) continue;
                return Optional.of(String.format("Attribute %1$s do not match: %2$s versus %3$s at %4$s", expectedAttr.getId(), expectedAttr.getValue(), actualAttr.get().getValue(), actual.printPosition()));
            }
            return Optional.of(String.format("Attribute %1$s not found at %2$s", expectedAttr.getId(), actual.printPosition()));
        }
        return Optional.empty();
    }

    private ImmutableList<XmlElement> initMergeableChildren() {
        ImmutableList.Builder mergeableNodes = new ImmutableList.Builder();
        NodeList nodeList = this.getXml().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Optional maybeExistingNode = this.mMergeableChildren.stream().filter((Predicate<XmlElement> & Serializable)existingNode -> existingNode.getXml().isSameNode(node)).findAny();
            if (maybeExistingNode.isEmpty()) {
                XmlElement xmlElement = new XmlElement((Element)node, this.mDocument);
                mergeableNodes.add((Object)xmlElement);
                continue;
            }
            mergeableNodes.add((Object)((XmlElement)maybeExistingNode.get()));
        }
        return mergeableNodes.build();
    }

    static List<Node> getLeadingComments(Node nodeToBeAdopted) {
        ImmutableList.Builder nodesToAdopt = new ImmutableList.Builder();
        for (Node previousSibling = nodeToBeAdopted.getPreviousSibling(); previousSibling != null && (previousSibling.getNodeType() == 8 || previousSibling.getNodeType() == 3); previousSibling = previousSibling.getPreviousSibling()) {
            if (previousSibling.getNodeType() != 8) continue;
            nodesToAdopt.add((Object)previousSibling);
        }
        return nodesToAdopt.build().reverse();
    }

    static class ElementOperationsAndMergeRuleMarkers {
        private final NodeOperationType mNodeOperationType;
        private final Map<XmlNode.NodeName, AttributeOperationType> mAttributesOperationTypes;
        private final Selector mSelector;
        private final List<Selector> mOverrideUsesSdkLibrarySelectors;

        public NodeOperationType getNodeOperationType() {
            return this.mNodeOperationType;
        }

        public Map<XmlNode.NodeName, AttributeOperationType> getAttributesOperationTypes() {
            return this.mAttributesOperationTypes;
        }

        public Selector getSelector() {
            return this.mSelector;
        }

        public List<Selector> getOverrideUsesSdkLibrarySelectors() {
            return this.mOverrideUsesSdkLibrarySelectors;
        }

        public ElementOperationsAndMergeRuleMarkers(NodeOperationType mNodeOperationType, Map<XmlNode.NodeName, AttributeOperationType> mAttributesOperationTypes, Selector mSelector, List<Selector> mOverrideUsesSdkLibrarySelectors) {
            this.mNodeOperationType = mNodeOperationType;
            this.mAttributesOperationTypes = mAttributesOperationTypes;
            this.mSelector = mSelector;
            this.mOverrideUsesSdkLibrarySelectors = mOverrideUsesSdkLibrarySelectors;
        }
    }
}

