/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.BytesSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class FullFileSource
extends BytesSource {
    public FullFileSource(Path file, String entryName, int compressionLevel) throws IOException {
        this(file, entryName, compressionLevel, Symlink.FOLLOW);
    }

    public FullFileSource(Path file, String entryName, int compressionLevel, Symlink symlinkPolicy) throws IOException {
        super(entryName);
        byte[] bytes;
        if (Files.isExecutable(file)) {
            this.externalAttributes |= 0x490000;
        }
        if (!Files.isSymbolicLink(file) || symlinkPolicy == Symlink.FOLLOW) {
            bytes = NioFileInterceptors.intercept_readAllBytes((Path)file, (String)"com.android.zipflinger.FullFileSource");
        } else {
            this.externalAttributes |= 0xA0000000;
            compressionLevel = 0;
            Path target = Files.readSymbolicLink(file);
            bytes = target.toString().getBytes(StandardCharsets.US_ASCII);
        }
        this.build(bytes, bytes.length, compressionLevel);
    }

    public static enum Symlink {
        FOLLOW,
        DO_NOT_FOLLOW;

    }
}

