/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.build;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

@Deprecated
public class BuildConfigGenerator {
    public static final String BUILD_CONFIG_NAME = "BuildConfig.java";
    private static final String PH_PACKAGE = "#PACKAGE#";
    private static final String PH_DEBUG = "#DEBUG#";
    private final String mGenFolder;
    private final String mAppPackage;
    private final boolean mDebug;

    public BuildConfigGenerator(String genFolder, String appPackage, boolean debug) {
        System.err.println("BuildConfigGenerator is deprecated and will be removed from sdklib at the end of 2018");
        this.mGenFolder = genFolder;
        this.mAppPackage = appPackage;
        this.mDebug = debug;
    }

    public File getFolderPath() {
        File genFolder = new File(this.mGenFolder);
        return new File(genFolder, this.mAppPackage.replace('.', File.separatorChar));
    }

    public File getBuildConfigFile() {
        File folder = this.getFolderPath();
        return new File(folder, BUILD_CONFIG_NAME);
    }

    public void generate() throws IOException {
        String template = this.readEmbeddedTextFile("BuildConfig.template");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PH_PACKAGE, this.mAppPackage);
        map.put(PH_DEBUG, Boolean.toString(this.mDebug));
        String content = this.replaceParameters(template, map);
        File pkgFolder = this.getFolderPath();
        if (!FileInterceptorsDeclaration.intercept_isDirectory((File)pkgFolder, (String)"com.android.sdklib.internal.build.BuildConfigGenerator")) {
            pkgFolder.mkdirs();
        }
        File buildConfigJava = new File(pkgFolder, BUILD_CONFIG_NAME);
        this.writeFile(buildConfigJava, content);
    }

    private String readEmbeddedTextFile(String filepath) throws IOException {
        InputStream is = BuildConfigGenerator.class.getResourceAsStream(filepath);
        if (is != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder total = new StringBuilder(reader.readLine());
            while ((line = reader.readLine()) != null) {
                total.append('\n');
                total.append(line);
            }
            return total.toString();
        }
        throw new IOException("BuildConfig template is missing!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String content) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes("UTF-8"));
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = source.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
    }

    private String replaceParameters(String str, Map<String, String> parameters) {
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            str = str.replaceAll(entry.getKey(), value);
        }
        return str;
    }
}

