/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.AutoValue_Aapt2Command_ConvertOptions;
import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.androidtools.DefaultCommandExecutor;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;

public interface Aapt2Command {
    public void convertApkProtoToBinary(Path var1, Path var2, ConvertOptions var3);

    public void optimizeToSparseResourceTables(Path var1, Path var2);

    default public ImmutableList<String> dumpBadging(Path apkPath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Aapt2Command createFromExecutablePath(final Path aapt2Path) {
        return new Aapt2Command(){
            private final Duration timeoutMillis = Duration.ofMinutes(5L);

            @Override
            public void convertApkProtoToBinary(Path protoApk, Path binaryApk, ConvertOptions convertOptions) {
                ImmutableList.Builder convertCommand = ImmutableList.builder().add((Object)aapt2Path.toString()).add((Object)"convert");
                if (convertOptions.getForceSparseEncoding()) {
                    convertCommand.add((Object)"--force-sparse-encoding");
                }
                if (convertOptions.getCollapseResourceNames()) {
                    convertCommand.add((Object)"--collapse-resource-names");
                }
                if (convertOptions.getDeduplicateResourceEntries()) {
                    convertCommand.add((Object)"--deduplicate-entry-values");
                }
                convertOptions.getResourceConfigPath().ifPresent((Consumer<Path> & Serializable)path -> convertCommand.add((Object)"--resources-config-path").add((Object)path.toAbsolutePath().toString()));
                convertCommand.add((Object)"--output-format").add((Object)"binary").add((Object)"-o").add((Object)binaryApk.toString()).add((Object)protoApk.toString());
                new DefaultCommandExecutor().execute((ImmutableList<String>)convertCommand.build(), CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            @Override
            public void optimizeToSparseResourceTables(Path originalApk, Path outputApk) {
                ImmutableList convertCommand = ImmutableList.of((Object)aapt2Path.toString(), (Object)"optimize", (Object)"--enable-sparse-encoding", (Object)"-o", (Object)outputApk.toString(), (Object)originalApk.toString());
                new DefaultCommandExecutor().execute((ImmutableList<String>)convertCommand, CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            @Override
            public ImmutableList<String> dumpBadging(Path apkPath) {
                return new DefaultCommandExecutor().executeAndCapture((ImmutableList<String>)ImmutableList.of((Object)aapt2Path.toString(), (Object)"dump", (Object)"badging", (Object)apkPath.toString()), CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }
        };
    }

    @AutoValue
    public static abstract class ConvertOptions {
        public abstract boolean getForceSparseEncoding();

        public abstract boolean getCollapseResourceNames();

        public abstract Optional<Path> getResourceConfigPath();

        public abstract boolean getDeduplicateResourceEntries();

        public static Builder builder() {
            return new AutoValue_Aapt2Command_ConvertOptions.Builder().setForceSparseEncoding(false).setCollapseResourceNames(false).setDeduplicateResourceEntries(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setForceSparseEncoding(boolean var1);

            public abstract Builder setCollapseResourceNames(boolean var1);

            public abstract Builder setResourceConfigPath(Optional<Path> var1);

            public abstract Builder setDeduplicateResourceEntries(boolean var1);

            public abstract ConvertOptions build();
        }
    }
}

