/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.commands.BuildSdkApksCommand;
import com.android.tools.build.bundletool.io.ApkSerializerManager;
import com.android.tools.build.bundletool.io.ApkSetWriter;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.shards.ModuleSplitterForShards;
import com.android.tools.build.bundletool.shards.StandaloneApksGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class BuildSdkApksManager {
    private final ApkSerializerManager apkSerializerManager;
    private final BuildSdkApksCommand command;
    private final TempDirectory tempDirectory;
    private final SdkBundle sdkBundle;
    private final ApkOptimizations apkOptimizations;
    private final ModuleSplitterForShards moduleSplitterForShards;

    @Inject
    BuildSdkApksManager(ApkSerializerManager apkSerializerManager, BuildSdkApksCommand command, TempDirectory tempDirectory, SdkBundle sdkBundle, ApkOptimizations apkOptimizations, ModuleSplitterForShards moduleSplitterForShards) {
        this.apkSerializerManager = apkSerializerManager;
        this.command = command;
        this.tempDirectory = tempDirectory;
        this.sdkBundle = sdkBundle;
        this.apkOptimizations = apkOptimizations;
        this.moduleSplitterForShards = moduleSplitterForShards;
    }

    void execute() throws IOException {
        ImmutableList<ModuleSplit> sdkApks = this.generateSdkApks();
        GeneratedApks generatedApks = GeneratedApks.builder().setStandaloneApks(sdkApks).build();
        if (this.command.getOverwriteOutput() && NioFileInterceptors.intercept_exists((Path)this.command.getOutputFile(), (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.commands.BuildSdkApksManager")) {
            MoreFiles.deleteRecursively((Path)this.command.getOutputFile(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        this.apkSerializerManager.serializeSdkApkSet(this.createApkSetWriter(), generatedApks);
    }

    private ApkSetWriter createApkSetWriter() {
        switch (this.command.getOutputFormat()) {
            case APK_SET: {
                return ApkSetWriter.zip(this.tempDirectory.getPath(), this.command.getOutputFile());
            }
            case DIRECTORY: {
                return ApkSetWriter.directory(this.command.getOutputFile());
            }
        }
        throw InvalidCommandException.builder().withInternalMessage("Unsupported output format '%s'.", new Object[]{this.command.getOutputFormat()}).build();
    }

    private ImmutableList<ModuleSplit> generateSdkApks() {
        Preconditions.checkState((boolean)this.sdkBundle.getVersionCode().isPresent(), (Object)"Missing version code for SDK Bundle.");
        return (ImmutableList)this.moduleSplitterForShards.generateSplits(this.sdkBundle.getModule(), this.apkOptimizations.getStandaloneDimensions()).stream().map((Function<ModuleSplit, ModuleSplit> & Serializable)moduleSplit -> moduleSplit.writeSdkVersionName(this.sdkBundle.getVersionName())).map((Function<ModuleSplit, ModuleSplit> & Serializable)moduleSplit -> moduleSplit.writeSdkVersionCode(this.sdkBundle.getVersionCode().get())).map((Function<ModuleSplit, ModuleSplit> & Serializable)moduleSplit -> moduleSplit.writeManifestPackage(this.sdkBundle.getManifestPackageName())).map((Function<ModuleSplit, ModuleSplit> & Serializable)moduleSplit -> moduleSplit.writeSdkLibraryElement(this.sdkBundle.getPackageName(), this.sdkBundle.getSdkAndroidVersionMajor())).map(ModuleSplit::overrideMinSdkVersionForSdkSandbox).map((Function<ModuleSplit, ModuleSplit> & Serializable)moduleSplit -> moduleSplit.writePatchVersion(this.sdkBundle.getPatchVersion())).map((Function<ModuleSplit, ModuleSplit> & Serializable)moduleSplit -> moduleSplit.writeSdkProviderClassName(this.sdkBundle.getProviderClassName())).map(this::writeCompatSdkProviderClassNameIfPresent).map(StandaloneApksGenerator::setVariantTargetingAndSplitType).map(this::addSdkRuntimeTargeting).collect(ImmutableList.toImmutableList());
    }

    private ModuleSplit writeCompatSdkProviderClassNameIfPresent(ModuleSplit moduleSplit) {
        if (this.sdkBundle.getCompatProviderClassName().isPresent()) {
            return moduleSplit.writeCompatSdkProviderClassName(this.sdkBundle.getCompatProviderClassName().get());
        }
        return moduleSplit;
    }

    private ModuleSplit addSdkRuntimeTargeting(ModuleSplit moduleSplit) {
        return moduleSplit.toBuilder().setVariantTargeting(moduleSplit.getVariantTargeting().toBuilder().setSdkRuntimeTargeting(Targeting.SdkRuntimeTargeting.newBuilder().setRequiresSdkRuntime(true)).build()).build();
    }
}

