/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.tools.build.bundletool.mergers.FusingAndroidManifestMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.Set;

public interface AndroidManifestMerger {
    public AndroidManifest merge(SetMultimap<BundleModuleName, AndroidManifest> var1);

    public static AndroidManifestMerger manifestOverride(AndroidManifest override) {
        return (AndroidManifestMerger & Serializable)manifests -> override;
    }

    public static AndroidManifestMerger fusingMergerOnlyReplaceActivities() {
        return new FusingAndroidManifestMerger((ImmutableSet<String>)ImmutableSet.of((Object)"activity"), FusingAndroidManifestMerger.Mode.REPLACE);
    }

    public static AndroidManifestMerger fusingMergerApplicationElements() {
        return new FusingAndroidManifestMerger((ImmutableSet<String>)ImmutableSet.of((Object)"activity", (Object)"activity-alias", (Object)"meta-data", (Object)"provider", (Object)"receiver", (Object)"service", (Object[])new String[0]), FusingAndroidManifestMerger.Mode.MERGE_CHILDREN);
    }

    public static AndroidManifestMerger useBaseModuleManifestMerger() {
        return (AndroidManifestMerger & Serializable)manifests -> {
            Set baseManifests = manifests.get((Object)BundleModuleName.BASE_MODULE_NAME);
            if (baseManifests.size() != 1) {
                throw CommandExecutionException.builder().withInternalMessage("Expected exactly one base module manifest, but found %d.", baseManifests.size()).build();
            }
            return (AndroidManifest)Iterables.getOnlyElement((Iterable)baseManifests);
        };
    }
}

