/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.tools.build.bundletool.mergers.AndroidManifestMerger;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class BundleModuleMerger {
    public static AppBundle mergeNonRemovableInstallTimeModules(AppBundle appBundle, boolean overrideBundleToolVersion) throws IOException {
        ImmutableSet bundleModulesToFuse = (ImmutableSet)Stream.concat(Stream.of(appBundle.getBaseModule()), appBundle.getFeatureModules().values().stream().filter((Predicate<BundleModule> & Serializable)module -> BundleModuleMerger.shouldMerge(module, appBundle.getBundleConfig(), overrideBundleToolVersion))).collect(ImmutableSet.toImmutableSet());
        if (bundleModulesToFuse.size() == 1) {
            return appBundle;
        }
        BundleModule.Builder mergedBaseModule = BundleModule.builder().setName(BundleModuleName.BASE_MODULE_NAME).setBundleType(appBundle.getBundleConfig().getType()).setBundletoolVersion(appBundle.getVersion());
        if (appBundle.getBundleConfig().hasApexConfig()) {
            mergedBaseModule.setBundleApexConfig(appBundle.getBundleConfig().getApexConfig());
        }
        BundleModuleMerger.mergeApexTable((ImmutableSet<BundleModule>)bundleModulesToFuse).ifPresent(mergedBaseModule::setApexConfig);
        BundleModuleMerger.mergeAssetsTable((ImmutableSet<BundleModule>)bundleModulesToFuse).ifPresent(mergedBaseModule::setAssetsConfig);
        BundleModuleMerger.mergeNativeLibraryTable((ImmutableSet<BundleModule>)bundleModulesToFuse).ifPresent(mergedBaseModule::setNativeConfig);
        BundleModuleMerger.mergeResourceTable((ImmutableSet<BundleModule>)bundleModulesToFuse).ifPresent(mergedBaseModule::setResourceTable);
        BundleModuleMerger.mergeAndroidManifest(appBundle.getVersion(), (ImmutableSet<BundleModule>)bundleModulesToFuse, mergedBaseModule);
        ImmutableList<ModuleEntry> renamedDexEntries = ModuleSplitsToShardMerger.renameDexFromAllModulesToSingleShard(BundleModuleMerger.getDexEntries((Set<BundleModule>)bundleModulesToFuse));
        mergedBaseModule.addEntries((Collection<ModuleEntry>)BundleModuleMerger.getAllEntriesExceptDexAndSpecial((Set<BundleModule>)bundleModulesToFuse)).addEntries((Collection<ModuleEntry>)renamedDexEntries);
        return appBundle.toBuilder().setRawModules((Collection)Stream.concat(Stream.of(mergedBaseModule.build()), appBundle.getModules().values().stream().filter((Predicate<BundleModule> & Serializable)module -> !bundleModulesToFuse.contains(module))).collect(ImmutableSet.toImmutableSet())).build();
    }

    private static boolean shouldMerge(BundleModule module, Config.BundleConfig bundleConfig, boolean overrideBundleToolVersion) {
        if (module.getModuleType() != BundleModule.ModuleType.FEATURE_MODULE) {
            return false;
        }
        return module.getAndroidManifest().getManifestDeliveryElement().map((Function<ManifestDeliveryElement, Boolean> & Serializable)manifestDeliveryElement -> {
            Version bundleToolVersion = BundleToolVersion.getVersionFromBundleConfig(bundleConfig);
            if (overrideBundleToolVersion && !VersionGuardedFeature.MERGE_INSTALL_TIME_MODULES_INTO_BASE.enabledForVersion(bundleToolVersion)) {
                return manifestDeliveryElement.hasInstallTimeElement() && !manifestDeliveryElement.hasModuleConditions();
            }
            return !manifestDeliveryElement.isInstallTimeRemovable(bundleToolVersion);
        }).orElse(false);
    }

    private static ImmutableSet<ModuleEntry> getAllEntriesExceptDexAndSpecial(Set<BundleModule> bundleModulesToFuse) {
        HashMap mergedEntriesByPath = new HashMap();
        bundleModulesToFuse.stream().flatMap((Function<BundleModule, Stream> & Serializable)module -> module.getEntries().stream()).filter((Predicate<ModuleEntry> & Serializable)moduleEntry -> !moduleEntry.getPath().startsWith(BundleModule.DEX_DIRECTORY) && !moduleEntry.isSpecialEntry()).forEach((Consumer<ModuleEntry> & Serializable)moduleEntry -> {
            ModuleEntry existingModuleEntry = mergedEntriesByPath.putIfAbsent(moduleEntry.getPath(), moduleEntry);
            if (existingModuleEntry != null && !existingModuleEntry.equals(moduleEntry)) {
                throw InvalidBundleException.builder().withUserMessage("Existing module entry '%s' with different contents.", moduleEntry.getPath()).build();
            }
        });
        return ImmutableSet.copyOf(mergedEntriesByPath.values());
    }

    private static ImmutableListMultimap<BundleModuleName, ModuleEntry> getDexEntries(Set<BundleModule> bundleModulesToFuse) {
        return (ImmutableListMultimap)bundleModulesToFuse.stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(BundleModule::getName, (Function<BundleModule, Stream> & Serializable)module -> module.getEntries().stream().filter((Predicate<ModuleEntry> & Serializable)moduleEntry -> moduleEntry.getPath().startsWith(BundleModule.DEX_DIRECTORY))));
    }

    private static void mergeAndroidManifest(Version bundletoolVersion, ImmutableSet<BundleModule> bundleModulesToFuse, BundleModule.Builder mergedBaseModule) {
        HashMultimap manifests = (HashMultimap)bundleModulesToFuse.stream().collect(Multimaps.toMultimap(BundleModule::getName, BundleModule::getAndroidManifest, HashMultimap::create));
        AndroidManifestMerger manifestMerger = VersionGuardedFeature.FUSE_APPLICATION_ELEMENTS_FROM_FEATURE_MANIFESTS.enabledForVersion(bundletoolVersion) ? AndroidManifestMerger.fusingMergerApplicationElements() : AndroidManifestMerger.fusingMergerOnlyReplaceActivities();
        AndroidManifest mergedManifest = manifestMerger.merge((SetMultimap<BundleModuleName, AndroidManifest>)manifests);
        mergedManifest = mergedManifest.toEditor().setFusedModuleNames((ImmutableList<String>)((ImmutableList)bundleModulesToFuse.stream().map((Function<BundleModule, String> & Serializable)module -> module.getName().getName()).collect(ImmutableList.toImmutableList()))).save();
        mergedBaseModule.setAndroidManifest(mergedManifest);
    }

    private static Optional<Resources.ResourceTable> mergeResourceTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch((Predicate<BundleModule> & Serializable)module -> module.getResourceTable().isPresent())) {
            return Optional.empty();
        }
        Resources.ResourceTable.Builder resourceTableMerged = Resources.ResourceTable.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getResourceTable().ifPresent(arg_0 -> ((Resources.ResourceTable.Builder)resourceTableMerged).mergeFrom(arg_0));
        }
        return Optional.of(resourceTableMerged.build());
    }

    private static Optional<Files.NativeLibraries> mergeNativeLibraryTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch((Predicate<BundleModule> & Serializable)module -> module.getNativeConfig().isPresent())) {
            return Optional.empty();
        }
        Files.NativeLibraries.Builder nativeLibrariesMerged = Files.NativeLibraries.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getNativeConfig().ifPresent(nativeLibrariesMerged::mergeFrom);
        }
        return Optional.of(nativeLibrariesMerged.build());
    }

    private static Optional<Files.Assets> mergeAssetsTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch((Predicate<BundleModule> & Serializable)module -> module.getAssetsConfig().isPresent())) {
            return Optional.empty();
        }
        Files.Assets.Builder assetsMerged = Files.Assets.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getAssetsConfig().ifPresent(assetsMerged::mergeFrom);
        }
        return Optional.of(assetsMerged.build());
    }

    private static Optional<Files.ApexImages> mergeApexTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch((Predicate<BundleModule> & Serializable)module -> module.getApexConfig().isPresent())) {
            return Optional.empty();
        }
        Files.ApexImages.Builder apexImagesMerged = Files.ApexImages.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getApexConfig().ifPresent(apexImagesMerged::mergeFrom);
        }
        return Optional.of(apexImagesMerged.build());
    }

    private BundleModuleMerger() {
    }
}

