/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.tools.build.bundletool.mergers.AndroidManifestMerger;
import com.android.tools.build.bundletool.mergers.AutoValue_FusingAndroidManifestMerger_ApplicationElementId;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNodeBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FusingAndroidManifestMerger
implements AndroidManifestMerger {
    private final ImmutableSet<String> elementsToMerge;
    private final Mode mode;

    public FusingAndroidManifestMerger(ImmutableSet<String> elementsToMerge, Mode mode) {
        this.elementsToMerge = elementsToMerge;
        this.mode = mode;
    }

    @Override
    public AndroidManifest merge(SetMultimap<BundleModuleName, AndroidManifest> manifests) {
        if (!manifests.containsKey((Object)BundleModuleName.BASE_MODULE_NAME)) {
            throw CommandExecutionException.builder().withInternalMessage("Expected to have base module.").build();
        }
        return this.merge((Map<BundleModuleName, AndroidManifest>)FusingAndroidManifestMerger.ensureOneManifestPerModule(manifests));
    }

    private AndroidManifest merge(Map<BundleModuleName, AndroidManifest> manifests) {
        AndroidManifest baseManifest = manifests.get(BundleModuleName.BASE_MODULE_NAME);
        List featureManifests = (List)manifests.entrySet().stream().filter((Predicate<Map.Entry> & Serializable)entry -> !BundleModuleName.BASE_MODULE_NAME.equals(entry.getKey())).sorted(Comparator.comparing((Function<Map.Entry, String> & Serializable)entry -> ((BundleModuleName)entry.getKey()).getName())).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
        if (featureManifests.isEmpty()) {
            return baseManifest;
        }
        return this.mergeManifests(baseManifest, featureManifests);
    }

    private AndroidManifest mergeManifests(AndroidManifest baseManifest, List<AndroidManifest> featureManifests) {
        ImmutableListMultimap<ApplicationElementId, XmlProtoElement> applicationElements = FusingAndroidManifestMerger.gatherApplicationElementsManifests((List<AndroidManifest>)ImmutableList.builder().addAll(featureManifests).add((Object)baseManifest).build(), this.elementsToMerge);
        long numberOfMergeableElementsInBase = ((XmlProtoElement)baseManifest.getManifestRoot().getElement()).getChildrenElements("application").flatMap((Function<XmlProtoElement, Stream> & Serializable)application -> application.getChildrenElements()).filter((Predicate<XmlProtoElement> & Serializable)element -> this.elementsToMerge.contains((Object)element.getName())).count();
        if (numberOfMergeableElementsInBase == (long)applicationElements.size()) {
            return baseManifest;
        }
        ImmutableMap mergedElements = (ImmutableMap)applicationElements.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), (Function<ApplicationElementId, XmlProtoElement> & Serializable)key -> this.mergeElements((ApplicationElementId)key, (List<XmlProtoElement>)applicationElements.get(key))));
        ManifestEditor manifestEditor = baseManifest.toEditor();
        XmlProtoElementBuilder applicationElement = manifestEditor.getRawProto().getOrCreateChildElement("application");
        Set replacedElements = Sets.newIdentityHashSet();
        applicationElement.modifyChildElements((Function<XmlProtoNodeBuilder, XmlProtoNodeBuilder> & Serializable)child -> ((Optional)Streams.stream(FusingAndroidManifestMerger.getCorrespondingElementFromMergedElements(child, (ImmutableMap<ApplicationElementId, XmlProtoElement>)mergedElements)).peek(replacedElements::add).map((Function<XmlProtoElement, XmlProtoNodeBuilder> & Serializable)element -> XmlProtoNodeBuilder.createElementNode(element.toBuilder())).collect(MoreCollectors.toOptional())).orElse(child));
        mergedElements.values().stream().filter(Predicates.not(replacedElements::contains)).forEach((Consumer<XmlProtoElement> & Serializable)element -> applicationElement.addChildElement(element.toBuilder()));
        return manifestEditor.save();
    }

    private XmlProtoElement mergeElements(ApplicationElementId elementId, List<XmlProtoElement> elements) {
        if (this.mode.equals((Object)Mode.REPLACE) || elements.size() == 1) {
            return elements.get(0);
        }
        List elementsNoSource = (List)elements.stream().map((Function<XmlProtoElement, XmlProtoElement> & Serializable)element -> element.toBuilder().removeSourceDataRecursive().build()).collect(ImmutableList.toImmutableList());
        Set intentFilters = (Set)elementsNoSource.stream().flatMap((Function<XmlProtoElement, Stream> & Serializable)element -> element.getChildrenElements("intent-filter")).collect(ImmutableSet.toImmutableSet());
        ImmutableMap metadataByName = (ImmutableMap)elementsNoSource.stream().flatMap((Function<XmlProtoElement, Stream> & Serializable)element -> element.getChildrenElements("meta-data")).filter((Predicate<XmlProtoElement> & Serializable)meta -> meta.getAndroidAttribute(0x1010003).isPresent()).collect(ImmutableMap.toImmutableMap((Function<XmlProtoElement, String> & Serializable)meta -> ((XmlProtoAttribute)meta.getAndroidAttribute(0x1010003).get()).getValueAsString(), Function.identity(), (BinaryOperator & Serializable)(a11, b11) -> {
            if (!a11.equals(b11)) {
                throw CommandExecutionException.builder().withInternalMessage("Multiple meta-data entries with the same name are found inside %s:%s: %s, %s", elementId.getType(), elementId.getName(), a11, b11).build();
            }
            return a11;
        }));
        XmlProtoElementBuilder builder = ((XmlProtoElement)elementsNoSource.get(0)).toBuilder();
        builder.removeChildrenElementsIf((Predicate<XmlProtoNodeBuilder> & Serializable)child -> {
            if (!child.isElement()) {
                return false;
            }
            XmlProtoElementBuilder childElement = (XmlProtoElementBuilder)child.getElement();
            String tag = childElement.getName();
            Optional name = childElement.getAndroidAttribute(0x1010003).map((Function<XmlProtoAttributeBuilder, String> & Serializable)rec$ -> ((XmlProtoAttributeBuilder)rec$).getValueAsString());
            if (tag.equals("intent-filter")) return true;
            if (!tag.equals("meta-data")) return false;
            if (name.map(arg_0 -> ((ImmutableMap)metadataByName).containsKey(arg_0)).orElse(false) == false) return false;
            return true;
        });
        intentFilters.forEach((Consumer<XmlProtoElement> & Serializable)e11 -> builder.addChildElement(e11.toBuilder()));
        metadataByName.values().forEach((Consumer<XmlProtoElement> & Serializable)e11 -> builder.addChildElement(e11.toBuilder()));
        return builder.build();
    }

    private static ImmutableListMultimap<ApplicationElementId, XmlProtoElement> gatherApplicationElementsManifests(List<AndroidManifest> featureManifests, ImmutableSet<String> elementsToMerge) {
        ImmutableListMultimap.Builder featureElementsBuilder = ImmutableListMultimap.builder();
        featureManifests.forEach((Consumer<AndroidManifest> & Serializable)manifest -> FusingAndroidManifestMerger.gatherApplicationElements(manifest, elementsToMerge, (ImmutableListMultimap.Builder<ApplicationElementId, XmlProtoElement>)featureElementsBuilder));
        return featureElementsBuilder.build();
    }

    private static void gatherApplicationElements(AndroidManifest manifest, ImmutableSet<String> elementsToMerge, ImmutableListMultimap.Builder<ApplicationElementId, XmlProtoElement> featureElementsBuilder) {
        Optional manifestElement = ((XmlProtoElement)manifest.getManifestRoot().getElement()).getOptionalChildElement("application");
        Streams.stream(manifestElement).flatMap((Function<XmlProtoElement, Stream> & Serializable)application -> application.getChildrenElements()).filter((Predicate<XmlProtoElement> & Serializable)child -> elementsToMerge.contains((Object)child.getName())).filter((Predicate<XmlProtoElement> & Serializable)child -> child.getAndroidAttribute(0x1010003).isPresent()).forEach((Consumer<XmlProtoElement> & Serializable)child -> featureElementsBuilder.put((Object)ApplicationElementId.create(child.getName(), FusingAndroidManifestMerger.getNameAttribute(child)), child));
    }

    private static Optional<XmlProtoElement> getCorrespondingElementFromMergedElements(XmlProtoNodeBuilder node, ImmutableMap<ApplicationElementId, XmlProtoElement> mergedElements) {
        if (!node.isElement()) {
            return Optional.empty();
        }
        Optional name = ((XmlProtoElementBuilder)node.getElement()).getAndroidAttribute(0x1010003);
        return name.map((Function<XmlProtoAttributeBuilder, XmlProtoElement> & Serializable)xmlProtoAttributeBuilder -> (XmlProtoElement)mergedElements.get((Object)ApplicationElementId.create(((XmlProtoElementBuilder)node.getElement()).getName(), xmlProtoAttributeBuilder.getValueAsString())));
    }

    private static String getNameAttribute(XmlProtoElement element) {
        return ((XmlProtoAttribute)element.getAndroidAttribute(0x1010003).get()).getValueAsString();
    }

    private static ImmutableMap<BundleModuleName, AndroidManifest> ensureOneManifestPerModule(SetMultimap<BundleModuleName, AndroidManifest> manifests) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BundleModuleName moduleName : manifests.keys()) {
            Set moduleManifests = manifests.get((Object)moduleName);
            if (moduleManifests.size() != 1) {
                throw CommandExecutionException.builder().withInternalMessage("Expected exactly one %s module manifest, but found %d.", moduleName.getName(), moduleManifests.size()).build();
            }
            builder.put((Object)moduleName, (Object)((AndroidManifest)Iterables.getOnlyElement((Iterable)moduleManifests)));
        }
        return builder.build();
    }

    @AutoValue
    static abstract class ApplicationElementId {
        ApplicationElementId() {
        }

        abstract String getType();

        abstract String getName();

        static ApplicationElementId create(String type, String name) {
            return new AutoValue_FusingAndroidManifestMerger_ApplicationElementId(type, name);
        }
    }

    public static enum Mode {
        REPLACE,
        MERGE_CHILDREN;

    }
}

