/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils.files;

import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public final class FilePreconditions {
    public static void checkFileDoesNotExist(Path path) {
        Preconditions.checkArgument((!NioFileInterceptors.intercept_exists((Path)path, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.files.FilePreconditions") ? 1 : 0) != 0, (String)"File '%s' already exists.", (Object)path);
    }

    public static void checkFileExistsAndReadable(Path path) {
        Preconditions.checkArgument((boolean)NioFileInterceptors.intercept_exists((Path)path, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.files.FilePreconditions"), (String)"File '%s' was not found.", (Object)path);
        Preconditions.checkArgument((boolean)Files.isReadable(path), (String)"File '%s' is not readable.", (Object)path);
        Preconditions.checkArgument((!NioFileInterceptors.intercept_isDirectory((Path)path, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.files.FilePreconditions") ? 1 : 0) != 0, (String)"File '%s' is a directory.", (Object)path);
    }

    public static void checkFileExistsAndExecutable(Path path) {
        Preconditions.checkArgument((boolean)NioFileInterceptors.intercept_exists((Path)path, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.files.FilePreconditions"), (String)"File '%s' was not found.", (Object)path);
        Preconditions.checkArgument((boolean)Files.isExecutable(path), (String)"File '%s' is not executable.", (Object)path);
    }

    public static void checkFileHasExtension(String fileDescription, ZipPath path, String extension) {
        FilePreconditions.checkFileHasExtension(fileDescription, path.getFileName().toString(), extension);
    }

    public static void checkFileHasExtension(String fileDescription, Path path, String extension) {
        FilePreconditions.checkFileHasExtension(fileDescription, path.getFileName().toString(), extension);
    }

    private static void checkFileHasExtension(String fileDescription, String filename, String extension) {
        Preconditions.checkArgument((boolean)filename.endsWith(extension), (String)"%s '%s' is expected to have '%s' extension.", (Object)fileDescription, (Object)filename, (Object)extension);
    }

    public static void checkDirectoryExists(Path path) {
        Preconditions.checkArgument((boolean)NioFileInterceptors.intercept_exists((Path)path, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.files.FilePreconditions"), (String)"Directory '%s' was not found.", (Object)path);
        Preconditions.checkArgument((boolean)NioFileInterceptors.intercept_isDirectory((Path)path, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.files.FilePreconditions"), (String)"'%s' is not a directory.", (Object)path);
    }

    public static void checkDirectoryExistsAndEmpty(Path path) {
        FilePreconditions.checkDirectoryExists(path);
        Preconditions.checkArgument((FileInterceptorsDeclaration.intercept_list((File)path.toFile(), (String)"com.android.tools.build.bundletool.model.utils.files.FilePreconditions").length == 0 ? 1 : 0) != 0, (String)"Directory '%s' is not empty.", (Object)path);
    }

    private FilePreconditions() {
    }
}

