/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.shards.ModuleSplitterForShards;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import java.io.Serializable;
import java.util.function.Function;
import javax.inject.Inject;

public class StandaloneApexApksGenerator {
    private final ModuleSplitterForShards moduleSplitter;
    private final ModuleSplitsToShardMerger shardsMerger;

    @Inject
    public StandaloneApexApksGenerator(ModuleSplitterForShards moduleSplitter, ModuleSplitsToShardMerger shardsMerger) {
        this.moduleSplitter = moduleSplitter;
        this.shardsMerger = shardsMerger;
    }

    public ImmutableList<ModuleSplit> generateStandaloneApks(ImmutableList<BundleModule> modules) {
        ImmutableList<ModuleSplit> apexSplits = this.moduleSplitter.generateSplits((BundleModule)Iterables.getOnlyElement(modules), (ImmutableSet<OptimizationDimension>)ImmutableSet.of());
        ModuleSplit masterSplit = (ModuleSplit)apexSplits.stream().filter(ModuleSplit::isMasterSplit).collect(MoreCollectors.onlyElement());
        Preconditions.checkState((boolean)masterSplit.getApkTargeting().equals(Targeting.ApkTargeting.getDefaultInstance()), (Object)"Master splits are expected to have default targeting.");
        return (ImmutableList)apexSplits.stream().filter(Predicates.not(ModuleSplit::isMasterSplit)).map((Function<ModuleSplit, ModuleSplit> & Serializable)module -> this.mergeSingleApexShard(masterSplit, (ModuleSplit)module)).collect(ImmutableList.toImmutableList());
    }

    private ModuleSplit mergeSingleApexShard(ModuleSplit masterSplit, ModuleSplit multiAbiSplit) {
        ModuleSplit mergedShard = this.shardsMerger.mergeSingleShard((ImmutableCollection<ModuleSplit>)ImmutableList.of((Object)masterSplit, (Object)multiAbiSplit), Maps.newHashMap());
        return mergedShard.toBuilder().setApexConfig(masterSplit.getApexConfig().get()).setApexEmbeddedApkConfigs(masterSplit.getApexEmbeddedApkConfigs()).setVariantTargeting(TargetingUtils.standaloneApkVariantTargeting(mergedShard)).build();
    }
}

