/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.mergers.AndroidManifestMerger;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.SourceStampConstants;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.shards.ModuleSplitterForShards;
import com.android.tools.build.bundletool.shards.Sharder;
import com.android.tools.build.bundletool.splitters.BinaryArtProfilesInjector;
import com.android.tools.build.bundletool.splitters.CodeTransparencyInjector;
import com.android.tools.build.bundletool.splitters.RuntimeEnabledSdkTableInjector;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;

public class StandaloneApksGenerator {
    private final Optional<SourceStamp> stampSource;
    private final ModuleSplitterForShards moduleSplitter;
    private final Sharder sharder;
    private final ModuleSplitsToShardMerger shardsMerger;
    private final AppBundle appBundle;
    private final CodeTransparencyInjector codeTransparencyInjector;
    private final BinaryArtProfilesInjector binaryArtProfilesInjector;
    private final RuntimeEnabledSdkTableInjector runtimeEnabledSdkTableInjector;

    @Inject
    public StandaloneApksGenerator(Optional<SourceStamp> stampSource, ModuleSplitterForShards moduleSplitter, Sharder sharder, ModuleSplitsToShardMerger shardsMerger, AppBundle appBundle) {
        this.stampSource = stampSource;
        this.moduleSplitter = moduleSplitter;
        this.sharder = sharder;
        this.shardsMerger = shardsMerger;
        this.appBundle = appBundle;
        this.codeTransparencyInjector = new CodeTransparencyInjector(appBundle);
        this.binaryArtProfilesInjector = new BinaryArtProfilesInjector(appBundle);
        this.runtimeEnabledSdkTableInjector = new RuntimeEnabledSdkTableInjector(appBundle);
    }

    public ImmutableList<ModuleSplit> generateStandaloneApks(ImmutableList<BundleModule> modules, ApkOptimizations apkOptimizations) {
        ImmutableList splits = (ImmutableList)modules.stream().flatMap((Function<BundleModule, Stream> & Serializable)module -> this.moduleSplitter.generateSplits((BundleModule)module, apkOptimizations.getStandaloneDimensions()).stream()).collect(ImmutableList.toImmutableList());
        switch (this.appBundle.getBundleConfig().getOptimizations().getStandaloneConfig().getFeatureModulesMode()) {
            case SEPARATE_FEATURE_MODULES: {
                return this.generateStandaloneApkWithStandaloneFeatureModules((ImmutableList<ModuleSplit>)splits);
            }
        }
        return this.generateStandaloneApkWithFusedModule((ImmutableList<ModuleSplit>)splits);
    }

    private ImmutableList<ModuleSplit> generateStandaloneApkWithFusedModule(ImmutableList<ModuleSplit> splits) {
        HashMap dexCache = Maps.newHashMap();
        return (ImmutableList)this.sharder.groupSplitsToShards(splits).stream().map((Function<ImmutableList, ModuleSplit> & Serializable)unfusedShard -> this.shardsMerger.mergeSingleShard((ImmutableCollection<ModuleSplit>)unfusedShard, dexCache)).map(StandaloneApksGenerator::setVariantTargetingAndSplitType).map(this::injectAdditionalEntriesIntoStandaloneApk).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> generateStandaloneApkWithStandaloneFeatureModules(ImmutableList<ModuleSplit> splits) {
        ImmutableListMultimap splitsByModuleName = (ImmutableListMultimap)splits.stream().collect(ImmutableListMultimap.toImmutableListMultimap(ModuleSplit::getModuleName, Function.identity()));
        ImmutableSet uniqueApkTargetingFromAllModules = (ImmutableSet)splits.stream().map(ModuleSplit::getApkTargeting).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)splitsByModuleName.keySet().stream().flatMap((Function<BundleModuleName, Stream> & Serializable)featureModuleName -> this.generateStandaloneApkForFeatureModule(this.appBundle.getModule((BundleModuleName)featureModuleName), (ImmutableList<ModuleSplit>)splitsByModuleName.get(featureModuleName), (ImmutableSet<Targeting.ApkTargeting>)uniqueApkTargetingFromAllModules).stream()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> generateStandaloneApkForFeatureModule(BundleModule featureModule, ImmutableList<ModuleSplit> featureModuleSplit, ImmutableSet<Targeting.ApkTargeting> uniqueApkTargeting) {
        ImmutableMap featureSplitByTargeting = (ImmutableMap)featureModuleSplit.stream().collect(ImmutableMap.toImmutableMap(ModuleSplit::getApkTargeting, Function.identity()));
        ImmutableList enrichedFeatureSplits = (ImmutableList)uniqueApkTargeting.stream().map((Function<Targeting.ApkTargeting, ModuleSplit> & Serializable)apkTargeting -> (ModuleSplit)featureSplitByTargeting.getOrDefault(apkTargeting, (Object)this.createEmptyConfigSplit(featureModule, (Targeting.ApkTargeting)apkTargeting))).collect(ImmutableList.toImmutableList());
        return (ImmutableList)this.sharder.groupSplitsToShards((ImmutableList<ModuleSplit>)enrichedFeatureSplits).stream().map((Function<ImmutableList, ModuleSplit> & Serializable)unfusedShard -> this.shardsMerger.mergeSingleShard((ImmutableCollection<ModuleSplit>)unfusedShard, Maps.newHashMap(), ModuleSplit.SplitType.STANDALONE_FEATURE_MODULE, AndroidManifestMerger.manifestOverride(featureModule.getAndroidManifest()))).map((Function<ModuleSplit, ModuleSplit> & Serializable)shard -> StandaloneApksGenerator.setVariantTargetingAndSplitTypeForStandaloneFeatureModule(featureModule.getName(), shard)).map((Function<ModuleSplit, ModuleSplit> & Serializable)shard -> featureModule.isBaseModule() ? this.injectAdditionalEntriesIntoStandaloneApk((ModuleSplit)shard) : shard).collect(ImmutableList.toImmutableList());
    }

    private ModuleSplit createEmptyConfigSplit(BundleModule featureModule, Targeting.ApkTargeting apkTargeting) {
        return ModuleSplit.builder().setAndroidManifest(AndroidManifest.create(AndroidManifest.createMinimalManifestTag(), this.appBundle.getVersion())).setModuleName(featureModule.getName()).setApkTargeting(apkTargeting).setVariantTargeting(Targeting.VariantTargeting.getDefaultInstance()).setMasterSplit(false).build();
    }

    private ModuleSplit injectAdditionalEntriesIntoStandaloneApk(ModuleSplit moduleSplit) {
        ModuleSplit result = this.writeSourceStampInManifest(moduleSplit);
        result = this.codeTransparencyInjector.inject(result);
        result = this.binaryArtProfilesInjector.inject(result);
        result = this.runtimeEnabledSdkTableInjector.inject(result);
        return result;
    }

    public static ModuleSplit setVariantTargetingAndSplitType(ModuleSplit shard) {
        return shard.toBuilder().setVariantTargeting(TargetingUtils.standaloneApkVariantTargeting(shard)).setSplitType(ModuleSplit.SplitType.STANDALONE).build();
    }

    public static ModuleSplit setVariantTargetingAndSplitTypeForStandaloneFeatureModule(BundleModuleName moduleName, ModuleSplit shard) {
        return shard.toBuilder().setModuleName(moduleName).setVariantTargeting(TargetingUtils.standaloneApkVariantTargeting(shard)).setSplitType(ModuleSplit.SplitType.STANDALONE_FEATURE_MODULE).build();
    }

    private ModuleSplit writeSourceStampInManifest(ModuleSplit shard) {
        return this.stampSource.map((Function<SourceStamp, ModuleSplit> & Serializable)stampSource -> shard.writeSourceStampInManifest(stampSource.getSource(), SourceStampConstants.StampType.STAMP_TYPE_STANDALONE_APK)).orElse(shard);
    }
}

