/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.size;

import com.android.bundle.SizesOuterClass;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.android.tools.build.bundletool.model.utils.GZipUtils;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.size.ApkComponent;
import com.android.tools.build.bundletool.size.ApkCompressedSizeCalculator;
import com.android.tools.build.bundletool.size.SizeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ApkBreakdownGenerator {
    private final ApkCompressedSizeCalculator compressedSizeCalculator;

    public ApkBreakdownGenerator() {
        this(new ApkCompressedSizeCalculator(ApkCompressedSizeCalculator.JavaUtilZipDeflater::new));
    }

    private ApkBreakdownGenerator(ApkCompressedSizeCalculator compressedSizeCalculator) {
        this.compressedSizeCalculator = compressedSizeCalculator;
    }

    public SizesOuterClass.Breakdown calculateBreakdown(Path apkPath) throws IOException {
        try (ZipFile apk = new ZipFile(apkPath.toFile());){
            ImmutableMap<String, Long> downloadSizeByEntry = this.calculateDownloadSizePerEntry(apk);
            ImmutableMap downloadSizeByComponent = downloadSizeByEntry.entrySet().stream().collect(CollectorUtils.groupingByDeterministic((Function<Map.Entry, ApkComponent> & Serializable)entry -> ApkComponent.fromEntryName((String)entry.getKey()), Collectors.summingLong(Map.Entry::getValue)));
            ImmutableMap diskSizeByComponent = apk.stream().collect(CollectorUtils.groupingByDeterministic((Function<ZipEntry, ApkComponent> & Serializable)zipEntry -> ApkComponent.fromEntryName(zipEntry.getName()), Collectors.summingLong(ZipEntry::getCompressedSize)));
            SizesOuterClass.Sizes actualTotalSize = ApkBreakdownGenerator.calculateActualTotals(apkPath);
            SizesOuterClass.Sizes zipOverheads = SizeUtils.subtractSizes(actualTotalSize, SizeUtils.sizes(diskSizeByComponent.values().stream().mapToLong(Long::longValue).sum(), downloadSizeByComponent.values().stream().mapToLong(Long::longValue).sum()));
            SizesOuterClass.Breakdown breakdown = SizesOuterClass.Breakdown.newBuilder().setDex(ApkBreakdownGenerator.getSizes(ApkComponent.DEX, diskSizeByComponent, downloadSizeByComponent)).setAssets(ApkBreakdownGenerator.getSizes(ApkComponent.ASSETS, diskSizeByComponent, downloadSizeByComponent)).setNativeLibs(ApkBreakdownGenerator.getSizes(ApkComponent.NATIVE_LIBS, diskSizeByComponent, downloadSizeByComponent)).setResources(ApkBreakdownGenerator.getSizes(ApkComponent.RESOURCES, diskSizeByComponent, downloadSizeByComponent)).setOther(SizeUtils.addSizes(ApkBreakdownGenerator.getSizes(ApkComponent.OTHER, diskSizeByComponent, downloadSizeByComponent), zipOverheads)).setTotal(actualTotalSize).build();
            return breakdown;
        }
    }

    private static SizesOuterClass.Sizes calculateActualTotals(Path apkPath) throws IOException {
        return SizeUtils.sizes(Files.size(apkPath), GZipUtils.calculateGzipCompressedSize(apkPath));
    }

    private static SizesOuterClass.Sizes getSizes(ApkComponent component, Map<ApkComponent, Long> diskSizes, Map<ApkComponent, Long> downloadSizes) {
        return SizeUtils.sizes(diskSizes.getOrDefault((Object)component, 0L), downloadSizes.getOrDefault((Object)component, 0L));
    }

    private ImmutableMap<String, Long> calculateDownloadSizePerEntry(ZipFile zipFile) throws IOException {
        ImmutableList streams = (ImmutableList)zipFile.stream().map((Function<ZipEntry, ByteSource> & Serializable)zipStreamEntry -> ZipUtils.asByteSource(zipFile, zipStreamEntry)).collect(ImmutableList.toImmutableList());
        ImmutableList<Long> downloadSizes = this.compressedSizeCalculator.calculateGZipSizeForEntries((List<ByteSource>)streams);
        return (ImmutableMap)Streams.zip(zipFile.stream(), (Stream)downloadSizes.stream(), AbstractMap.SimpleEntry::new).collect(ImmutableMap.toImmutableMap((Function<AbstractMap.SimpleEntry, String> & Serializable)entry -> ((ZipEntry)entry.getKey()).getName(), AbstractMap.SimpleEntry::getValue));
    }
}

