/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.splitters.SplitterForOneTargetingDimension;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class LanguageResourcesSplitter
extends SplitterForOneTargetingDimension {
    private final Predicate<ResourceTableEntry> pinResourceToMaster;

    public LanguageResourcesSplitter() {
        this((Predicate<ResourceTableEntry>)Predicates.alwaysFalse());
    }

    public LanguageResourcesSplitter(Predicate<ResourceTableEntry> pinResourceToMaster) {
        this.pinResourceToMaster = pinResourceToMaster;
    }

    @Override
    public ImmutableCollection<ModuleSplit> splitInternal(ModuleSplit split) {
        if (!split.getResourceTable().isPresent()) {
            return ImmutableList.of((Object)split);
        }
        Resources.ResourceTable resourceTable = split.getResourceTable().get();
        ImmutableMap<String, Resources.ResourceTable> byLanguage = this.groupByLanguage(resourceTable, LanguageResourcesSplitter.hasNonResourceEntries(split));
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (String language : byLanguage.keySet()) {
            ModuleSplit moduleSplit = split.toBuilder().setEntries((List<ModuleEntry>)LanguageResourcesSplitter.getEntriesForSplit(split.getEntries(), language, (Resources.ResourceTable)byLanguage.get((Object)language))).setResourceTable((Resources.ResourceTable)byLanguage.get((Object)language)).setApkTargeting(language.isEmpty() ? split.getApkTargeting() : split.getApkTargeting().toBuilder().setLanguageTargeting(Targeting.LanguageTargeting.newBuilder().addValue(language)).build()).setMasterSplit(split.isMasterSplit() && language.isEmpty()).build();
            result.add((Object)moduleSplit);
        }
        return result.build();
    }

    private static boolean hasNonResourceEntries(ModuleSplit split) {
        return split.getEntries().stream().anyMatch((Predicate<ModuleEntry> & Serializable)entry -> !entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY));
    }

    private static ImmutableList<ModuleEntry> getEntriesForSplit(ImmutableList<ModuleEntry> inputEntries, String language, Resources.ResourceTable resourceTable) {
        ImmutableList<ModuleEntry> entriesFromResourceTable = ModuleSplit.filterResourceEntries(inputEntries, resourceTable);
        if (language.isEmpty()) {
            return ImmutableList.builder().addAll(entriesFromResourceTable).addAll((Iterable)inputEntries.stream().filter((Predicate<ModuleEntry> & Serializable)entry -> !entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)).collect(ImmutableList.toImmutableList())).build();
        }
        return entriesFromResourceTable;
    }

    private ImmutableMap<String, Resources.ResourceTable> groupByLanguage(Resources.ResourceTable table, boolean hasNonResourceEntries) {
        ImmutableSet<String> languages = ResourcesUtils.getAllLanguages(table);
        ImmutableMap.Builder resourceTableByLanguage = new ImmutableMap.Builder();
        for (String language : languages) {
            Resources.ResourceTable languageResourceTable = this.filterByLanguage(table, language);
            if (languageResourceTable.equals((Object)Resources.ResourceTable.getDefaultInstance())) continue;
            resourceTableByLanguage.put((Object)language, (Object)languageResourceTable);
        }
        if (!languages.contains((Object)"")) {
            Resources.ResourceTable pinnedResources = ResourcesUtils.filterResourceTable(table, this.pinResourceToMaster.negate(), ResourceTableEntry::getEntry);
            if (hasNonResourceEntries || ResourcesUtils.entries(pinnedResources).count() > 0L) {
                resourceTableByLanguage.put((Object)"", (Object)pinnedResources);
            }
        }
        return resourceTableByLanguage.build();
    }

    private Resources.ResourceTable filterByLanguage(Resources.ResourceTable input, String language) {
        return ResourcesUtils.filterResourceTable(input, (Predicate<ResourceTableEntry>)(language.isEmpty() ? Predicates.alwaysFalse() : this.pinResourceToMaster), (Function<ResourceTableEntry, Resources.Entry> & Serializable)entry -> this.filterEntryForLanguage((ResourceTableEntry)entry, language));
    }

    private Resources.Entry filterEntryForLanguage(ResourceTableEntry initialEntry, String targetLanguage) {
        if (targetLanguage.isEmpty() && this.pinResourceToMaster.test(initialEntry)) {
            return initialEntry.getEntry();
        }
        Iterable filteredConfigValues = Iterables.filter((Iterable)initialEntry.getEntry().getConfigValueList(), (com.google.common.base.Predicate & Serializable)configValue -> ResourcesUtils.convertLocaleToLanguage(configValue.getConfig().getLocale()).equals(targetLanguage));
        return initialEntry.getEntry().toBuilder().clearConfigValue().addAllConfigValue(filteredConfigValues).build();
    }
}

