/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectory;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.validation.AutoValue_CountrySetParityValidator_SupportedCountrySets;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class CountrySetParityValidator
extends SubValidator {
    @Override
    public void validateBundle(AppBundle bundle) {
        Config.BundleConfig bundleConfig = bundle.getBundleConfig();
        Config.Optimizations optimizations = bundleConfig.getOptimizations();
        List<Config.SplitDimension> splitDimensions = optimizations.getSplitsConfig().getSplitDimensionList();
        Optional countrySetDefaultSuffix = (Optional)splitDimensions.stream().filter((Predicate<Config.SplitDimension> & Serializable)dimension -> dimension.getValue().equals((Object)Config.SplitDimension.Value.COUNTRY_SET)).map((Function<Config.SplitDimension, String> & Serializable)dimension -> dimension.getSuffixStripping().getDefaultSuffix()).collect(MoreCollectors.toOptional());
        if (countrySetDefaultSuffix.isPresent()) {
            this.validateDefaultCountrySetSupportedByAllModules(bundle, (String)countrySetDefaultSuffix.get());
        }
    }

    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        BundleModule referenceModule = null;
        Object referenceCountrySets = null;
        for (BundleModule module : modules) {
            SupportedCountrySets moduleCountrySets = this.getSupportedCountrySets(module);
            if (moduleCountrySets.getCountrySets().isEmpty()) continue;
            CountrySetParityValidator.validateModuleHasFallbackCountrySet(module, moduleCountrySets);
            if (referenceCountrySets == null) {
                referenceModule = module;
                referenceCountrySets = moduleCountrySets;
                continue;
            }
            if (referenceCountrySets.equals(moduleCountrySets)) continue;
            throw InvalidBundleException.builder().withUserMessage("All modules with country set targeting must support the same country sets, but module '%s' supports %s and module '%s' supports %s.", referenceModule.getName(), referenceCountrySets, module.getName(), moduleCountrySets).build();
        }
    }

    private void validateDefaultCountrySetSupportedByAllModules(AppBundle bundle, String defaultCountrySet) {
        bundle.getModules().values().forEach((Consumer<BundleModule> & Serializable)module -> {
            SupportedCountrySets supportedCountrySets = this.getSupportedCountrySets((BundleModule)module);
            if (supportedCountrySets.getCountrySets().isEmpty()) {
                return;
            }
            if (!defaultCountrySet.isEmpty() && !supportedCountrySets.getCountrySets().contains((Object)defaultCountrySet)) {
                throw InvalidBundleException.builder().withUserMessage("When a standalone or universal APK is built, the country set folders corresponding to country set '%s' will be used, but module '%s' has no such folders. Either add missing folders or change the configuration for the COUNTRY_SET optimization to specify a default suffix corresponding to country set to use in the standalone and universal APKs.", defaultCountrySet, module.getName()).build();
            }
            CountrySetParityValidator.validateModuleHasFallbackCountrySet(module, supportedCountrySets);
        });
    }

    private SupportedCountrySets getSupportedCountrySets(BundleModule module) {
        ImmutableSet<TargetedDirectory> targetedDirectories = TargetingUtils.extractAssetsTargetedDirectories(module);
        ImmutableSet<String> countrySets = TargetingUtils.extractCountrySets(targetedDirectories);
        boolean hasFallback = targetedDirectories.stream().anyMatch((Predicate<TargetedDirectory> & Serializable)directory -> {
            Optional<Targeting.AssetsDirectoryTargeting> targeting = directory.getTargeting(TargetingDimension.COUNTRY_SET);
            if (targeting.isPresent()) {
                TargetedDirectory siblingFallbackDirectory = directory.removeTargeting(TargetingDimension.COUNTRY_SET);
                return module.findEntriesUnderPath(siblingFallbackDirectory.toZipPath()).findAny().isPresent();
            }
            return false;
        });
        return SupportedCountrySets.create(countrySets, hasFallback);
    }

    private static void validateModuleHasFallbackCountrySet(BundleModule module, SupportedCountrySets supportedCountrySets) {
        if (!supportedCountrySets.getHasFallback()) {
            throw InvalidBundleException.builder().withUserMessage("Module '%s' targets content based on country set but doesn't have fallback folders (folders without #countries suffixes). Fallback folders will be used to generate split for rest of the countries which are not targeted by existing country sets. Please add missing folders and try again.", module.getName()).build();
        }
    }

    @AutoValue
    public static abstract class SupportedCountrySets {
        public static SupportedCountrySets create(ImmutableSet<String> countrySets, boolean hasFallback) {
            return new AutoValue_CountrySetParityValidator_SupportedCountrySets(countrySets, hasFallback);
        }

        public abstract ImmutableSet<String> getCountrySets();

        public abstract boolean getHasFallback();

        public final String toString() {
            return this.getCountrySets() + (this.getHasFallback() ? " (with fallback directories)" : " (without fallback directories)");
        }
    }
}

