/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectory;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectorySegment;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.validation.AutoValue_NestedTargetingValidator_DirectoryNestedTargeting;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class NestedTargetingValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        modules.forEach(NestedTargetingValidator::validateNestedTargetingInModule);
        if (modules.stream().map(NestedTargetingValidator::getDirectoryAllNestedTargetingByPathBaseName).filter((Predicate<ImmutableSetMultimap> & Serializable)moduleDirectoryAllNestedTargetingByPathBaseName -> !moduleDirectoryAllNestedTargetingByPathBaseName.isEmpty()).map(ImmutableMultimap::asMap).map(ImmutableMap::values).distinct().count() > 1L) {
            throw InvalidBundleException.builder().withUserMessage("Found different nested targeting across different modules. Please make sure all modules use same nested targeting.").build();
        }
    }

    private static void validateNestedTargetingInModule(BundleModule module) {
        ImmutableSetMultimap<String, DirectoryNestedTargeting> directoryAllNestedTargetingByPathBaseName = NestedTargetingValidator.getDirectoryAllNestedTargetingByPathBaseName(module);
        if (directoryAllNestedTargetingByPathBaseName.isEmpty()) {
            return;
        }
        NestedTargetingValidator.validateAllDirectoryNestedTargetingAreDistinct(module, directoryAllNestedTargetingByPathBaseName);
        NestedTargetingValidator.validateAllDirectoriesHaveSameNestedTargeting(module, directoryAllNestedTargetingByPathBaseName);
        ImmutableSet supportedNestedTargeting = ImmutableSet.copyOf((Collection)((Collection)directoryAllNestedTargetingByPathBaseName.asMap().values().stream().findAny().get()));
        NestedTargetingValidator.validateNestingDimensionOrder(module, (ImmutableSet<DirectoryNestedTargeting>)supportedNestedTargeting);
        NestedTargetingValidator.validateNestedTargetingCoversAllCartesianProductPoints(module, (ImmutableSet<DirectoryNestedTargeting>)supportedNestedTargeting);
    }

    private static void validateNestedTargetingCoversAllCartesianProductPoints(BundleModule module, ImmutableSet<DirectoryNestedTargeting> directoryAllNestedTargeting) {
        ImmutableMultimap<TargetingDimension, Targeting.AssetsDirectoryTargeting> assetsDirectoryTargetingByDimension = TargetingUtils.getAssetsDirectoryTargetingByDimension((ImmutableList<Targeting.AssetsDirectoryTargeting>)((ImmutableList)directoryAllNestedTargeting.stream().map(DirectoryNestedTargeting::getTargeting).collect(ImmutableList.toImmutableList())));
        ImmutableList nestedTargetingUniverse = ImmutableList.of((Object)Targeting.AssetsDirectoryTargeting.getDefaultInstance());
        for (Collection values2 : assetsDirectoryTargetingByDimension.asMap().values()) {
            nestedTargetingUniverse = (ImmutableList)nestedTargetingUniverse.stream().flatMap((Function<Targeting.AssetsDirectoryTargeting, Stream> & Serializable)targeting -> values2.stream().map((Function<Targeting.AssetsDirectoryTargeting, Targeting.AssetsDirectoryTargeting> & Serializable)targeting1 -> targeting.toBuilder().mergeFrom((Targeting.AssetsDirectoryTargeting)targeting1).build())).collect(ImmutableList.toImmutableList());
        }
        if (!((ImmutableList)directoryAllNestedTargeting.stream().map(DirectoryNestedTargeting::getTargeting).collect(ImmutableList.toImmutableList())).containsAll((Collection)nestedTargetingUniverse)) {
            throw InvalidBundleException.builder().withUserMessage("Module '%s' uses nested targeting but does not define targeting for all of the points in the cartesian product of dimension values used.", module.getName()).build();
        }
    }

    private static void validateAllDirectoriesHaveSameNestedTargeting(BundleModule module, ImmutableSetMultimap<String, DirectoryNestedTargeting> directoryAllNestedTargetingByPathBaseName) {
        if (directoryAllNestedTargetingByPathBaseName.asMap().values().stream().distinct().count() > 1L) {
            throw InvalidBundleException.builder().withUserMessage("Found directories targeted on different set of targeting dimensions in module '%s'. Please make sure all directories are targeted on same set of targeting dimensions in same order.", module.getName()).build();
        }
    }

    private static void validateNestingDimensionOrder(BundleModule module, ImmutableSet<DirectoryNestedTargeting> directoryAllNestedTargeting) {
        ImmutableList targetingDimensionOrderRef = (ImmutableList)directoryAllNestedTargeting.stream().map(DirectoryNestedTargeting::getTargetingDimensionOrder).max(Comparator.comparing(List::size)).get();
        ImmutableSet targetingDimensionOrderRefSet = ImmutableSet.copyOf((Collection)targetingDimensionOrderRef);
        directoryAllNestedTargeting.stream().map(DirectoryNestedTargeting::getTargetingDimensionOrder).forEach((Consumer<ImmutableList> & Serializable)dimensionOrder -> {
            if (!targetingDimensionOrderRefSet.containsAll((Collection)dimensionOrder)) {
                throw InvalidBundleException.builder().withUserMessage("Found directory targeted on different set of targeting dimensions in module '%s'. Targeting Used: '%s'. Please make sure all directories are targeted on same set of targeting dimensions in same order.", module.getName(), NestedTargetingValidator.directoryAllTargetingToString(directoryAllNestedTargeting)).build();
            }
            if (!Comparators.isInOrder((Iterable)((Iterable)dimensionOrder.stream().map(arg_0 -> ((ImmutableList)targetingDimensionOrderRef).indexOf(arg_0)).collect(ImmutableList.toImmutableList())), Comparator.naturalOrder())) {
                throw InvalidBundleException.builder().withUserMessage("Found directory targeted on different order of targeting dimensions in module '%s'. Targeting Used: '%s'. Please make sure all directories are targeted on same set of targeting dimensions in same order.", module.getName(), NestedTargetingValidator.directoryAllTargetingToString(directoryAllNestedTargeting)).build();
            }
        });
    }

    private static void validateAllDirectoryNestedTargetingAreDistinct(BundleModule module, ImmutableSetMultimap<String, DirectoryNestedTargeting> directoryAllNestedTargetingByPathBaseName) {
        directoryAllNestedTargetingByPathBaseName.asMap().forEach((BiConsumer<String, Collection> & Serializable)(key, value) -> {
            if (value.stream().map(DirectoryNestedTargeting::getTargeting).distinct().count() != (long)value.size()) {
                throw InvalidBundleException.builder().withUserMessage("Found multiple directories using same targeting values in module '%s'. Directory '%s' is targeted on following dimension values some of which vary only in nesting order: '%s'.", module.getName(), key, NestedTargetingValidator.directoryAllTargetingToString((ImmutableSet<DirectoryNestedTargeting>)ImmutableSet.copyOf((Collection)value))).build();
            }
        });
    }

    private static ImmutableSetMultimap<String, DirectoryNestedTargeting> getDirectoryAllNestedTargetingByPathBaseName(BundleModule module) {
        ImmutableList<ZipPath> assetDirectories = TargetingUtils.getAssetDirectories(module);
        LinkedHashMultimap directoryAllTargetingByPathBaseName = LinkedHashMultimap.create();
        FileUtils.toPathWalkingOrder(assetDirectories).forEach((Consumer<ZipPath> & Serializable)assetDirectory -> {
            TargetedDirectory targetedDirectory = TargetedDirectory.parse(assetDirectory);
            directoryAllTargetingByPathBaseName.put((Object)targetedDirectory.getPathBaseName(), (Object)DirectoryNestedTargeting.create(targetedDirectory.getLastSegment().getTargeting(), targetedDirectory.getLastSegment().getTargetingDimensionOrder()));
        });
        LinkedHashMultimap directoryAllNestedTargetingByPathBaseName = LinkedHashMultimap.create();
        directoryAllTargetingByPathBaseName.asMap().entrySet().stream().filter((Predicate<Map.Entry> & Serializable)directoryTargeting -> NestedTargetingValidator.targetedOnMultipleDimension((ImmutableList<DirectoryNestedTargeting>)ImmutableList.copyOf((Collection)((Collection)directoryTargeting.getValue())))).forEach((Consumer<Map.Entry> & Serializable)directoryAllTargeting -> ((Collection)directoryAllTargeting.getValue()).stream().forEach((Consumer<DirectoryNestedTargeting> & Serializable)directoryTargeting -> directoryAllNestedTargetingByPathBaseName.put((Object)((String)directoryAllTargeting.getKey()), directoryTargeting)));
        return ImmutableSetMultimap.copyOf((Multimap)directoryAllNestedTargetingByPathBaseName);
    }

    private static boolean targetedOnMultipleDimension(ImmutableList<DirectoryNestedTargeting> directoryNestedTargetingList) {
        return directoryNestedTargetingList.stream().flatMap((Function<DirectoryNestedTargeting, Stream> & Serializable)directoryNestedTargeting -> TargetingUtils.getTargetingDimensions(directoryNestedTargeting.getTargeting()).stream()).distinct().count() > 1L;
    }

    private static String directoryAllTargetingToString(ImmutableSet<DirectoryNestedTargeting> directoryAllTargeting) {
        return ((ImmutableList)directoryAllTargeting.stream().map((Function<DirectoryNestedTargeting, String> & Serializable)targeting -> TargetedDirectorySegment.constructTargetingSegmentPath(targeting.getTargeting(), targeting.getTargetingDimensionOrder())).collect(ImmutableList.toImmutableList())).toString();
    }

    @AutoValue
    static abstract class DirectoryNestedTargeting {
        DirectoryNestedTargeting() {
        }

        public static DirectoryNestedTargeting create(Targeting.AssetsDirectoryTargeting directoryTargeting, ImmutableList<TargetingDimension> targetingDimensionOrder) {
            return new AutoValue_NestedTargetingValidator_DirectoryNestedTargeting(directoryTargeting, targetingDimensionOrder);
        }

        public abstract Targeting.AssetsDirectoryTargeting getTargeting();

        public abstract ImmutableList<TargetingDimension> getTargetingDimensionOrder();
    }
}

