/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SdkBundleModulesMandatoryFilesPresenceValidator
extends SubValidator {
    @Override
    public void validateSdkModulesZipFile(ZipFile modulesFile) {
        SdkBundleModulesMandatoryFilesPresenceValidator.checkHasSdkModulesConfig(modulesFile);
        ImmutableSet moduleDirectories = (ImmutableSet)Collections.list(modulesFile.entries()).stream().map(ZipEntry::getName).map(ZipPath::create).filter((Predicate<ZipPath> & Serializable)entryPath -> entryPath.getNameCount() > 1).map((Function<ZipPath, ZipPath> & Serializable)entryPath -> entryPath.getName(0)).collect(ImmutableSet.toImmutableSet());
        for (ZipPath moduleDir : moduleDirectories) {
            SdkBundleModulesMandatoryFilesPresenceValidator.checkModuleHasAndroidManifest(modulesFile, moduleDir, moduleDir.toString());
        }
    }

    private static void checkHasSdkModulesConfig(ZipFile modulesFile) {
        if (modulesFile.getEntry("SdkModulesConfig.pb") == null) {
            throw InvalidBundleException.builder().withUserMessage("The archive doesn't seem to be an SDK Bundle, it is missing required file '%s'.", "SdkModulesConfig.pb").build();
        }
    }

    private static void checkModuleHasAndroidManifest(ZipFile zipFile, ZipPath moduleBaseDir, String moduleName) {
        ZipPath moduleManifestPath = moduleBaseDir.resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath());
        if (zipFile.getEntry(moduleManifestPath.toString()) == null) {
            throw InvalidBundleException.builder().withUserMessage("Module '%s' is missing mandatory file '%s'.", moduleName, BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()).build();
        }
    }
}

