/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.DexFilesValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SdkAndroidManifestValidator;
import com.android.tools.build.bundletool.validation.SdkBundleMandatoryFilesPresenceValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModuleNameValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModuleResourceIdValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.collect.ImmutableList;
import java.util.zip.ZipFile;

public class SdkBundleModulesValidator {
    static final ImmutableList<SubValidator> MODULE_FILES_SUB_VALIDATORS = ImmutableList.of((Object)new SdkBundleMandatoryFilesPresenceValidator());
    static final ImmutableList<SubValidator> MODULE_SUB_VALIDATORS = ImmutableList.of((Object)new BundleFilesValidator(), (Object)new SdkBundleModuleNameValidator(), (Object)new DexFilesValidator(), (Object)new SdkAndroidManifestValidator(), (Object)new ResourceTableValidator(), (Object)new SdkBundleModuleResourceIdValidator());

    public void validateModuleZipFiles(ImmutableList<ZipFile> moduleZipFiles) {
        ValidatorRunner validatorRunner = new ValidatorRunner(MODULE_FILES_SUB_VALIDATORS);
        moduleZipFiles.forEach(validatorRunner::validateModuleZipFile);
    }

    public void validateSdkBundleModules(ImmutableList<BundleModule> modules) {
        new ValidatorRunner(MODULE_SUB_VALIDATORS).validateBundleModules(modules);
    }
}

