/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.apk;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.security.auth.x500.X500Principal;
import shadow.bundletool.com.android.apksig.ApkVerifier;
import shadow.bundletool.com.android.apksig.SigningCertificateLineage;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;
import shadow.bundletool.com.android.apksig.apk.ApkSigningBlockNotFoundException;
import shadow.bundletool.com.android.apksig.apk.ApkUtils;
import shadow.bundletool.com.android.apksig.internal.apk.ContentDigestAlgorithm;
import shadow.bundletool.com.android.apksig.internal.apk.SignatureAlgorithm;
import shadow.bundletool.com.android.apksig.internal.apk.SignatureInfo;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1BerParser;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1DecodingException;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1DerEncoder;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1EncodingException;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1OpaqueObject;
import shadow.bundletool.com.android.apksig.internal.pkcs7.AlgorithmIdentifier;
import shadow.bundletool.com.android.apksig.internal.pkcs7.ContentInfo;
import shadow.bundletool.com.android.apksig.internal.pkcs7.EncapsulatedContentInfo;
import shadow.bundletool.com.android.apksig.internal.pkcs7.IssuerAndSerialNumber;
import shadow.bundletool.com.android.apksig.internal.pkcs7.SignedData;
import shadow.bundletool.com.android.apksig.internal.pkcs7.SignerIdentifier;
import shadow.bundletool.com.android.apksig.internal.pkcs7.SignerInfo;
import shadow.bundletool.com.android.apksig.internal.util.ByteBufferDataSource;
import shadow.bundletool.com.android.apksig.internal.util.ChainedDataSource;
import shadow.bundletool.com.android.apksig.internal.util.Pair;
import shadow.bundletool.com.android.apksig.internal.util.VerityTreeBuilder;
import shadow.bundletool.com.android.apksig.internal.x509.RSAPublicKey;
import shadow.bundletool.com.android.apksig.internal.x509.SubjectPublicKeyInfo;
import shadow.bundletool.com.android.apksig.internal.zip.ZipUtils;
import shadow.bundletool.com.android.apksig.util.DataSink;
import shadow.bundletool.com.android.apksig.util.DataSinks;
import shadow.bundletool.com.android.apksig.util.DataSource;
import shadow.bundletool.com.android.apksig.util.DataSources;
import shadow.bundletool.com.android.apksig.util.RunnablesExecutor;
import shadow.bundletool.com.android.apksig.util.RunnablesProvider;

public class ApkSigningBlockUtils {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final long CONTENT_DIGESTED_CHUNK_MAX_SIZE_BYTES = 0x100000L;
    public static final int ANDROID_COMMON_PAGE_ALIGNMENT_BYTES = 4096;
    public static final byte[] APK_SIGNING_BLOCK_MAGIC = new byte[]{65, 80, 75, 32, 83, 105, 103, 32, 66, 108, 111, 99, 107, 32, 52, 50};
    private static final int VERITY_PADDING_BLOCK_ID = 1114793335;
    private static final ContentDigestAlgorithm[] V4_CONTENT_DIGEST_ALGORITHMS = new ContentDigestAlgorithm[]{ContentDigestAlgorithm.CHUNKED_SHA512, ContentDigestAlgorithm.VERITY_CHUNKED_SHA256, ContentDigestAlgorithm.CHUNKED_SHA256};
    public static final int VERSION_SOURCE_STAMP = 0;
    public static final int VERSION_JAR_SIGNATURE_SCHEME = 1;
    public static final int VERSION_APK_SIGNATURE_SCHEME_V2 = 2;
    public static final int VERSION_APK_SIGNATURE_SCHEME_V3 = 3;
    public static final int VERSION_APK_SIGNATURE_SCHEME_V4 = 4;

    public static int compareSignatureAlgorithm(SignatureAlgorithm alg1, SignatureAlgorithm alg2) {
        ContentDigestAlgorithm digestAlg1 = alg1.getContentDigestAlgorithm();
        ContentDigestAlgorithm digestAlg2 = alg2.getContentDigestAlgorithm();
        return ApkSigningBlockUtils.compareContentDigestAlgorithm(digestAlg1, digestAlg2);
    }

    private static int compareContentDigestAlgorithm(ContentDigestAlgorithm alg1, ContentDigestAlgorithm alg2) {
        switch (alg1) {
            case CHUNKED_SHA256: {
                switch (alg2) {
                    case CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: 
                    case VERITY_CHUNKED_SHA256: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
            case CHUNKED_SHA512: {
                switch (alg2) {
                    case CHUNKED_SHA256: 
                    case VERITY_CHUNKED_SHA256: {
                        return 1;
                    }
                    case CHUNKED_SHA512: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
            case VERITY_CHUNKED_SHA256: {
                switch (alg2) {
                    case CHUNKED_SHA256: {
                        return 1;
                    }
                    case VERITY_CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
        }
        throw new IllegalArgumentException("Unknown alg1: " + (Object)((Object)alg1));
    }

    public static void verifyIntegrity(RunnablesExecutor executor, DataSource beforeApkSigningBlock, DataSource centralDir, ByteBuffer eocd, Set<ContentDigestAlgorithm> contentDigestAlgorithms, Result result) throws IOException, NoSuchAlgorithmException {
        Map<ContentDigestAlgorithm, byte[]> actualContentDigests;
        if (contentDigestAlgorithms.isEmpty()) {
            throw new RuntimeException("No content digests found");
        }
        ByteBuffer modifiedEocd = ByteBuffer.allocate(eocd.remaining());
        int eocdSavedPos = eocd.position();
        modifiedEocd.order(ByteOrder.LITTLE_ENDIAN);
        modifiedEocd.put(eocd);
        modifiedEocd.flip();
        eocd.position(eocdSavedPos);
        ZipUtils.setZipEocdCentralDirectoryOffset(modifiedEocd, beforeApkSigningBlock.size());
        try {
            actualContentDigests = ApkSigningBlockUtils.computeContentDigests(executor, contentDigestAlgorithms, beforeApkSigningBlock, centralDir, new ByteBufferDataSource(modifiedEocd));
            if (actualContentDigests.containsKey((Object)ContentDigestAlgorithm.VERITY_CHUNKED_SHA256)) {
                if (beforeApkSigningBlock.size() % 4096L != 0L) {
                    throw new RuntimeException("APK Signing Block is not aligned on 4k boundary: " + beforeApkSigningBlock.size());
                }
                long centralDirOffset = ZipUtils.getZipEocdCentralDirectoryOffset(eocd);
                long signingBlockSize = centralDirOffset - beforeApkSigningBlock.size();
                if (signingBlockSize % 4096L != 0L) {
                    throw new RuntimeException("APK Signing Block size is not multiple of page size: " + signingBlockSize);
                }
            }
        }
        catch (DigestException e11) {
            throw new RuntimeException("Failed to compute content digests", e11);
        }
        if (!contentDigestAlgorithms.equals(actualContentDigests.keySet())) {
            throw new RuntimeException("Mismatch between sets of requested and computed content digests . Requested: " + contentDigestAlgorithms + ", computed: " + actualContentDigests.keySet());
        }
        for (Result.SignerInfo signerInfo : result.signers) {
            for (Result.SignerInfo.ContentDigest expected : signerInfo.contentDigests) {
                byte[] actualDigest;
                ContentDigestAlgorithm contentDigestAlgorithm;
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(expected.getSignatureAlgorithmId());
                if (signatureAlgorithm == null || !contentDigestAlgorithms.contains((Object)(contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm()))) continue;
                byte[] expectedDigest = expected.getValue();
                if (!Arrays.equals(expectedDigest, actualDigest = actualContentDigests.get((Object)contentDigestAlgorithm))) {
                    if (result.signatureSchemeVersion == 2) {
                        signerInfo.addError(ApkVerifier.Issue.V2_SIG_APK_DIGEST_DID_NOT_VERIFY, new Object[]{contentDigestAlgorithm, ApkSigningBlockUtils.toHex(expectedDigest), ApkSigningBlockUtils.toHex(actualDigest)});
                        continue;
                    }
                    if (result.signatureSchemeVersion != 3) continue;
                    signerInfo.addError(ApkVerifier.Issue.V3_SIG_APK_DIGEST_DID_NOT_VERIFY, new Object[]{contentDigestAlgorithm, ApkSigningBlockUtils.toHex(expectedDigest), ApkSigningBlockUtils.toHex(actualDigest)});
                    continue;
                }
                signerInfo.verifiedContentDigests.put(contentDigestAlgorithm, actualDigest);
            }
        }
    }

    public static ByteBuffer findApkSignatureSchemeBlock(ByteBuffer apkSigningBlock, int blockId, Result result) throws SignatureNotFoundException {
        ApkSigningBlockUtils.checkByteOrderLittleEndian(apkSigningBlock);
        ByteBuffer pairs = ApkSigningBlockUtils.sliceFromTo(apkSigningBlock, 8, apkSigningBlock.capacity() - 24);
        int entryCount = 0;
        while (pairs.hasRemaining()) {
            ++entryCount;
            if (pairs.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + entryCount);
            }
            long lenLong = pairs.getLong();
            if (lenLong < 4L || lenLong > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + lenLong);
            }
            int len = (int)lenLong;
            int nextEntryPos = pairs.position() + len;
            if (len > pairs.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + len + ", available: " + pairs.remaining());
            }
            int id2 = pairs.getInt();
            if (id2 == blockId) {
                return ApkSigningBlockUtils.getByteBuffer(pairs, len - 4);
            }
            pairs.position(nextEntryPos);
        }
        throw new SignatureNotFoundException("No APK Signature Scheme block in APK Signing Block with ID: " + blockId);
    }

    public static void checkByteOrderLittleEndian(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer sliceFromTo(ByteBuffer source, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start: " + end + " < " + start);
        }
        int capacity = source.capacity();
        if (end > source.capacity()) {
            throw new IllegalArgumentException("end > capacity: " + end + " > " + capacity);
        }
        int originalLimit = source.limit();
        int originalPosition = source.position();
        try {
            source.position(0);
            source.limit(end);
            source.position(start);
            ByteBuffer result = source.slice();
            result.order(source.order());
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.position(0);
            source.limit(originalLimit);
            source.position(originalPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getByteBuffer(ByteBuffer source, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        int originalLimit = source.limit();
        int position = source.position();
        int limit = position + size;
        if (limit < position || limit > originalLimit) {
            throw new BufferUnderflowException();
        }
        source.limit(limit);
        try {
            ByteBuffer result = source.slice();
            result.order(source.order());
            source.position(limit);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.limit(originalLimit);
        }
    }

    public static ByteBuffer getLengthPrefixedSlice(ByteBuffer source) throws ApkFormatException {
        if (source.remaining() < 4) {
            throw new ApkFormatException("Remaining buffer too short to contain length of length-prefixed field. Remaining: " + source.remaining());
        }
        int len = source.getInt();
        if (len < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (len > source.remaining()) {
            throw new ApkFormatException("Length-prefixed field longer than remaining buffer. Field length: " + len + ", remaining: " + source.remaining());
        }
        return ApkSigningBlockUtils.getByteBuffer(source, len);
    }

    public static byte[] readLengthPrefixedByteArray(ByteBuffer buf) throws ApkFormatException {
        int len = buf.getInt();
        if (len < 0) {
            throw new ApkFormatException("Negative length");
        }
        if (len > buf.remaining()) {
            throw new ApkFormatException("Underflow while reading length-prefixed value. Length: " + len + ", available: " + buf.remaining());
        }
        byte[] result = new byte[len];
        buf.get(result);
        return result;
    }

    public static String toHex(byte[] value) {
        StringBuilder sb2 = new StringBuilder(value.length * 2);
        int len = value.length;
        for (int i11 = 0; i11 < len; ++i11) {
            int hi2 = (value[i11] & 0xFF) >>> 4;
            int lo2 = value[i11] & 0xF;
            sb2.append(HEX_DIGITS[hi2]).append(HEX_DIGITS[lo2]);
        }
        return sb2.toString();
    }

    public static Map<ContentDigestAlgorithm, byte[]> computeContentDigests(RunnablesExecutor executor, Set<ContentDigestAlgorithm> digestAlgorithms, DataSource beforeCentralDir, DataSource centralDir, DataSource eocd) throws IOException, NoSuchAlgorithmException, DigestException {
        HashMap<ContentDigestAlgorithm, byte[]> contentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
        HashSet<ContentDigestAlgorithm> oneMbChunkBasedAlgorithm = new HashSet<ContentDigestAlgorithm>();
        for (ContentDigestAlgorithm digestAlgorithm : digestAlgorithms) {
            if (digestAlgorithm != ContentDigestAlgorithm.CHUNKED_SHA256 && digestAlgorithm != ContentDigestAlgorithm.CHUNKED_SHA512) continue;
            oneMbChunkBasedAlgorithm.add(digestAlgorithm);
        }
        ApkSigningBlockUtils.computeOneMbChunkContentDigests(executor, oneMbChunkBasedAlgorithm, new DataSource[]{beforeCentralDir, centralDir, eocd}, contentDigests);
        if (digestAlgorithms.contains((Object)ContentDigestAlgorithm.VERITY_CHUNKED_SHA256)) {
            ApkSigningBlockUtils.computeApkVerityDigest(beforeCentralDir, centralDir, eocd, contentDigests);
        }
        return contentDigests;
    }

    /*
     * WARNING - void declaration
     */
    static void computeOneMbChunkContentDigests(Set<ContentDigestAlgorithm> digestAlgorithms, DataSource[] contents, Map<ContentDigestAlgorithm, byte[]> outputContentDigests) throws IOException, NoSuchAlgorithmException, DigestException {
        void var13_19;
        long chunkCountLong = 0L;
        for (DataSource input : contents) {
            chunkCountLong += ApkSigningBlockUtils.getChunkCount(input.size(), 0x100000L);
        }
        if (chunkCountLong > Integer.MAX_VALUE) {
            throw new DigestException("Input too long: " + chunkCountLong + " chunks");
        }
        int chunkCount = (int)chunkCountLong;
        ContentDigestAlgorithm[] digestAlgorithmsArray = digestAlgorithms.toArray(new ContentDigestAlgorithm[digestAlgorithms.size()]);
        MessageDigest[] mds = new MessageDigest[digestAlgorithmsArray.length];
        byte[][] digestsOfChunks = new byte[digestAlgorithmsArray.length][];
        int[] digestOutputSizes = new int[digestAlgorithmsArray.length];
        for (int i11 = 0; i11 < digestAlgorithmsArray.length; ++i11) {
            int digestOutputSizeBytes;
            ContentDigestAlgorithm digestAlgorithm = digestAlgorithmsArray[i11];
            digestOutputSizes[i11] = digestOutputSizeBytes = digestAlgorithm.getChunkDigestOutputSizeBytes();
            byte[] byArray = new byte[5 + chunkCount * digestOutputSizeBytes];
            byArray[0] = 90;
            ApkSigningBlockUtils.setUnsignedInt32LittleEndian(chunkCount, byArray, 1);
            digestsOfChunks[i11] = byArray;
            String jcaAlgorithm = digestAlgorithm.getJcaMessageDigestAlgorithm();
            mds[i11] = MessageDigest.getInstance(jcaAlgorithm);
        }
        DataSink mdSink = DataSinks.asDataSink(mds);
        byte[] chunkContentPrefix = new byte[5];
        chunkContentPrefix[0] = -91;
        int chunkIndex = 0;
        for (DataSource input : contents) {
            long inputOffset = 0L;
            long inputRemaining = input.size();
            while (inputRemaining > 0L) {
                int chunkSize = (int)Math.min(inputRemaining, 0x100000L);
                ApkSigningBlockUtils.setUnsignedInt32LittleEndian(chunkSize, chunkContentPrefix, 1);
                for (int i12 = 0; i12 < mds.length; ++i12) {
                    mds[i12].update(chunkContentPrefix);
                }
                try {
                    input.feed(inputOffset, chunkSize, mdSink);
                }
                catch (IOException e11) {
                    throw new IOException("Failed to read chunk #" + chunkIndex, e11);
                }
                for (int i11 = 0; i11 < digestAlgorithmsArray.length; ++i11) {
                    MessageDigest md2 = mds[i11];
                    byte[] concatenationOfChunkCountAndChunkDigests = digestsOfChunks[i11];
                    int expectedDigestSizeBytes = digestOutputSizes[i11];
                    int actualDigestSizeBytes = md2.digest(concatenationOfChunkCountAndChunkDigests, 5 + chunkIndex * expectedDigestSizeBytes, expectedDigestSizeBytes);
                    if (actualDigestSizeBytes == expectedDigestSizeBytes) continue;
                    throw new RuntimeException("Unexpected output size of " + md2.getAlgorithm() + " digest: " + actualDigestSizeBytes);
                }
                inputOffset += (long)chunkSize;
                inputRemaining -= (long)chunkSize;
                ++chunkIndex;
            }
        }
        boolean bl2 = false;
        while (var13_19 < digestAlgorithmsArray.length) {
            ContentDigestAlgorithm digestAlgorithm = digestAlgorithmsArray[var13_19];
            byte[] concatenationOfChunkCountAndChunkDigests = digestsOfChunks[var13_19];
            MessageDigest md3 = mds[var13_19];
            byte[] digest = md3.digest(concatenationOfChunkCountAndChunkDigests);
            outputContentDigests.put(digestAlgorithm, digest);
            ++var13_19;
        }
    }

    static void computeOneMbChunkContentDigests(RunnablesExecutor executor, Set<ContentDigestAlgorithm> digestAlgorithms, DataSource[] contents, Map<ContentDigestAlgorithm, byte[]> outputContentDigests) throws NoSuchAlgorithmException, DigestException {
        long chunkCountLong = 0L;
        for (DataSource input : contents) {
            chunkCountLong += ApkSigningBlockUtils.getChunkCount(input.size(), 0x100000L);
        }
        if (chunkCountLong > Integer.MAX_VALUE) {
            throw new DigestException("Input too long: " + chunkCountLong + " chunks");
        }
        int chunkCount = (int)chunkCountLong;
        ArrayList<ChunkDigests> chunkDigestsList = new ArrayList<ChunkDigests>(digestAlgorithms.size());
        for (ContentDigestAlgorithm algorithms : digestAlgorithms) {
            chunkDigestsList.add(new ChunkDigests(algorithms, chunkCount));
        }
        ChunkSupplier chunkSupplier = new ChunkSupplier(contents);
        executor.execute((RunnablesProvider & Serializable)() -> new ChunkDigester(chunkSupplier, chunkDigestsList));
        for (ChunkDigests chunkDigests : chunkDigestsList) {
            MessageDigest messageDigest = chunkDigests.createMessageDigest();
            outputContentDigests.put(chunkDigests.algorithm, messageDigest.digest(chunkDigests.concatOfDigestsOfChunks));
        }
    }

    private static void computeApkVerityDigest(DataSource beforeCentralDir, DataSource centralDir, DataSource eocd, Map<ContentDigestAlgorithm, byte[]> outputContentDigests) throws IOException, NoSuchAlgorithmException {
        ByteBuffer encoded = ApkSigningBlockUtils.createVerityDigestBuffer(true);
        try (VerityTreeBuilder builder = new VerityTreeBuilder(new byte[8]);){
            byte[] rootHash = builder.generateVerityTreeRootHash(beforeCentralDir, centralDir, eocd);
            encoded.put(rootHash);
            encoded.putLong(beforeCentralDir.size() + centralDir.size() + eocd.size());
            outputContentDigests.put(ContentDigestAlgorithm.VERITY_CHUNKED_SHA256, encoded.array());
        }
    }

    private static ByteBuffer createVerityDigestBuffer(boolean includeSourceDataSize) {
        int backBufferSize = ContentDigestAlgorithm.VERITY_CHUNKED_SHA256.getChunkDigestOutputSizeBytes();
        if (includeSourceDataSize) {
            backBufferSize += 8;
        }
        ByteBuffer encoded = ByteBuffer.allocate(backBufferSize);
        encoded.order(ByteOrder.LITTLE_ENDIAN);
        return encoded;
    }

    public static VerityTreeAndDigest computeChunkVerityTreeAndDigest(DataSource dataSource) throws IOException, NoSuchAlgorithmException {
        ByteBuffer encoded = ApkSigningBlockUtils.createVerityDigestBuffer(false);
        try (VerityTreeBuilder builder = new VerityTreeBuilder(null);){
            ByteBuffer tree = builder.generateVerityTree(dataSource);
            byte[] rootHash = builder.getRootHashFromTree(tree);
            encoded.put(rootHash);
            VerityTreeAndDigest verityTreeAndDigest = new VerityTreeAndDigest(ContentDigestAlgorithm.VERITY_CHUNKED_SHA256, encoded.array(), tree.array());
            return verityTreeAndDigest;
        }
    }

    private static long getChunkCount(long inputSize, long chunkSize) {
        return (inputSize + chunkSize - 1L) / chunkSize;
    }

    private static void setUnsignedInt32LittleEndian(int value, byte[] result, int offset) {
        result[offset] = (byte)(value & 0xFF);
        result[offset + 1] = (byte)(value >> 8 & 0xFF);
        result[offset + 2] = (byte)(value >> 16 & 0xFF);
        result[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    public static byte[] encodePublicKey(PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedPublicKey = null;
        if ("X.509".equals(publicKey.getFormat())) {
            encodedPublicKey = publicKey.getEncoded();
            if ("RSA".equals(publicKey.getAlgorithm())) {
                try {
                    ByteBuffer encodedPublicKeyBuffer = ByteBuffer.wrap(encodedPublicKey);
                    SubjectPublicKeyInfo subjectPublicKeyInfo = Asn1BerParser.parse(encodedPublicKeyBuffer, SubjectPublicKeyInfo.class);
                    ByteBuffer subjectPublicKeyBuffer = subjectPublicKeyInfo.subjectPublicKey;
                    byte padding = subjectPublicKeyBuffer.get();
                    RSAPublicKey rsaPublicKey = Asn1BerParser.parse(subjectPublicKeyBuffer, RSAPublicKey.class);
                    if (rsaPublicKey.modulus.compareTo(BigInteger.ZERO) < 0) {
                        byte[] encodedModulus = rsaPublicKey.modulus.toByteArray();
                        byte[] reencodedModulus = new byte[encodedModulus.length + 1];
                        reencodedModulus[0] = 0;
                        System.arraycopy(encodedModulus, 0, reencodedModulus, 1, encodedModulus.length);
                        rsaPublicKey.modulus = new BigInteger(reencodedModulus);
                        byte[] reencodedRSAPublicKey = Asn1DerEncoder.encode(rsaPublicKey);
                        byte[] reencodedSubjectPublicKey = new byte[reencodedRSAPublicKey.length + 1];
                        reencodedSubjectPublicKey[0] = padding;
                        System.arraycopy(reencodedRSAPublicKey, 0, reencodedSubjectPublicKey, 1, reencodedRSAPublicKey.length);
                        subjectPublicKeyInfo.subjectPublicKey = ByteBuffer.wrap(reencodedSubjectPublicKey);
                        encodedPublicKey = Asn1DerEncoder.encode(subjectPublicKeyInfo);
                    }
                }
                catch (Asn1DecodingException | Asn1EncodingException e11) {
                    System.out.println("Caught a exception encoding the public key: " + e11);
                    e11.printStackTrace();
                    encodedPublicKey = null;
                }
            }
        }
        if (encodedPublicKey == null) {
            try {
                encodedPublicKey = KeyFactory.getInstance(publicKey.getAlgorithm()).getKeySpec(publicKey, X509EncodedKeySpec.class).getEncoded();
            }
            catch (InvalidKeySpecException e12) {
                throw new InvalidKeyException("Failed to obtain X.509 encoded form of public key " + publicKey + " of class " + publicKey.getClass().getName(), e12);
            }
        }
        if (encodedPublicKey == null || encodedPublicKey.length == 0) {
            throw new InvalidKeyException("Failed to obtain X.509 encoded form of public key " + publicKey + " of class " + publicKey.getClass().getName());
        }
        return encodedPublicKey;
    }

    public static List<byte[]> encodeCertificates(List<X509Certificate> certificates) throws CertificateEncodingException {
        ArrayList<byte[]> result = new ArrayList<byte[]>(certificates.size());
        for (X509Certificate certificate : certificates) {
            result.add(certificate.getEncoded());
        }
        return result;
    }

    public static byte[] encodeAsLengthPrefixedElement(byte[] bytes) {
        byte[][] adapterBytes = new byte[][]{bytes};
        return ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(adapterBytes);
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedElements(List<byte[]> sequence) {
        return ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements((byte[][])sequence.toArray((T[])new byte[sequence.size()][]));
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedElements(byte[][] sequence) {
        int payloadSize = 0;
        for (byte[] element : sequence) {
            payloadSize += 4 + element.length;
        }
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        for (byte[] element : sequence) {
            result.putInt(element.length);
            result.put(element);
        }
        return result.array();
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(List<Pair<Integer, byte[]>> sequence) {
        int resultSize = 0;
        for (Pair<Integer, byte[]> element : sequence) {
            resultSize += 12 + element.getSecond().length;
        }
        ByteBuffer result = ByteBuffer.allocate(resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        for (Pair<Integer, byte[]> element : sequence) {
            byte[] second = element.getSecond();
            result.putInt(8 + second.length);
            result.putInt(element.getFirst());
            result.putInt(second.length);
            result.put(second);
        }
        return result.array();
    }

    public static SignatureInfo findSignature(DataSource apk, ApkUtils.ZipSections zipSections, int blockId, Result result) throws IOException, SignatureNotFoundException {
        DataSource apkSigningBlock;
        long apkSigningBlockOffset;
        try {
            ApkUtils.ApkSigningBlock apkSigningBlockInfo = ApkUtils.findApkSigningBlock(apk, zipSections);
            apkSigningBlockOffset = apkSigningBlockInfo.getStartOffset();
            apkSigningBlock = apkSigningBlockInfo.getContents();
        }
        catch (ApkSigningBlockNotFoundException e11) {
            throw new SignatureNotFoundException(e11.getMessage(), e11);
        }
        ByteBuffer apkSigningBlockBuf = apkSigningBlock.getByteBuffer(0L, (int)apkSigningBlock.size());
        apkSigningBlockBuf.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer apkSignatureSchemeBlock = ApkSigningBlockUtils.findApkSignatureSchemeBlock(apkSigningBlockBuf, blockId, result);
        return new SignatureInfo(apkSignatureSchemeBlock, apkSigningBlockOffset, zipSections.getZipCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectory());
    }

    public static Pair<DataSource, Integer> generateApkSigningBlockPadding(DataSource beforeCentralDir, boolean apkSigningBlockPaddingSupported) {
        int padSizeBeforeSigningBlock = 0;
        if (apkSigningBlockPaddingSupported && beforeCentralDir.size() % 4096L != 0L) {
            padSizeBeforeSigningBlock = (int)(4096L - beforeCentralDir.size() % 4096L);
            beforeCentralDir = new ChainedDataSource(beforeCentralDir, DataSources.asDataSource(ByteBuffer.allocate(padSizeBeforeSigningBlock)));
        }
        return Pair.of(beforeCentralDir, padSizeBeforeSigningBlock);
    }

    public static DataSource copyWithModifiedCDOffset(DataSource beforeCentralDir, DataSource eocd) throws IOException {
        long centralDirOffsetForDigesting = beforeCentralDir.size();
        ByteBuffer eocdBuf = ByteBuffer.allocate((int)eocd.size());
        eocdBuf.order(ByteOrder.LITTLE_ENDIAN);
        eocd.copyTo(0L, (int)eocd.size(), eocdBuf);
        eocdBuf.flip();
        ZipUtils.setZipEocdCentralDirectoryOffset(eocdBuf, centralDirOffsetForDigesting);
        return DataSources.asDataSource(eocdBuf);
    }

    public static byte[] generateApkSigningBlock(List<Pair<byte[], Integer>> apkSignatureSchemeBlockPairs) {
        int blocksSize = 0;
        for (Pair<byte[], Integer> schemeBlockPair : apkSignatureSchemeBlockPairs) {
            blocksSize += 12 + schemeBlockPair.getFirst().length;
        }
        int resultSize = 8 + blocksSize + 8 + 16;
        ByteBuffer paddingPair = null;
        if (resultSize % 4096 != 0) {
            int padding = 4096 - resultSize % 4096;
            if (padding < 12) {
                padding += 4096;
            }
            paddingPair = ByteBuffer.allocate(padding).order(ByteOrder.LITTLE_ENDIAN);
            paddingPair.putLong(padding - 8);
            paddingPair.putInt(1114793335);
            paddingPair.rewind();
            resultSize += padding;
        }
        ByteBuffer result = ByteBuffer.allocate(resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        long blockSizeFieldValue = (long)resultSize - 8L;
        result.putLong(blockSizeFieldValue);
        for (Pair<byte[], Integer> schemeBlockPair : apkSignatureSchemeBlockPairs) {
            byte[] apkSignatureSchemeBlock = schemeBlockPair.getFirst();
            int apkSignatureSchemeId = schemeBlockPair.getSecond();
            long pairSizeFieldValue = 4L + (long)apkSignatureSchemeBlock.length;
            result.putLong(pairSizeFieldValue);
            result.putInt(apkSignatureSchemeId);
            result.put(apkSignatureSchemeBlock);
        }
        if (paddingPair != null) {
            result.put(paddingPair);
        }
        result.putLong(blockSizeFieldValue);
        result.put(APK_SIGNING_BLOCK_MAGIC);
        return result.array();
    }

    public static Pair<List<SignerConfig>, Map<ContentDigestAlgorithm, byte[]>> computeContentDigests(RunnablesExecutor executor, DataSource beforeCentralDir, DataSource centralDir, DataSource eocd, List<SignerConfig> signerConfigs) throws IOException, NoSuchAlgorithmException, SignatureException {
        Map<ContentDigestAlgorithm, byte[]> contentDigests;
        if (signerConfigs.isEmpty()) {
            throw new IllegalArgumentException("No signer configs provided. At least one is required");
        }
        HashSet<ContentDigestAlgorithm> contentDigestAlgorithms = new HashSet<ContentDigestAlgorithm>(1);
        for (SignerConfig signerConfig : signerConfigs) {
            for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
                contentDigestAlgorithms.add(signatureAlgorithm.getContentDigestAlgorithm());
            }
        }
        try {
            contentDigests = ApkSigningBlockUtils.computeContentDigests(executor, contentDigestAlgorithms, beforeCentralDir, centralDir, eocd);
        }
        catch (IOException e11) {
            throw new IOException("Failed to read APK being signed", e11);
        }
        catch (DigestException e12) {
            throw new SignatureException("Failed to compute digests of APK", e12);
        }
        return Pair.of(signerConfigs, contentDigests);
    }

    public static List<SupportedSignature> getSignaturesToVerify(List<SupportedSignature> signatures, int minSdkVersion, int maxSdkVersion) throws NoSupportedSignaturesException {
        HashMap<Integer, SupportedSignature> bestSigAlgorithmOnSdkVersion = new HashMap<Integer, SupportedSignature>();
        int minProvidedSignaturesVersion = Integer.MAX_VALUE;
        for (SupportedSignature sig : signatures) {
            SupportedSignature candidate;
            SignatureAlgorithm sigAlgorithm = sig.algorithm;
            int sigMinSdkVersion = sigAlgorithm.getMinSdkVersion();
            if (sigMinSdkVersion > maxSdkVersion) continue;
            if (sigMinSdkVersion < minProvidedSignaturesVersion) {
                minProvidedSignaturesVersion = sigMinSdkVersion;
            }
            if ((candidate = (SupportedSignature)bestSigAlgorithmOnSdkVersion.get(sigMinSdkVersion)) != null && ApkSigningBlockUtils.compareSignatureAlgorithm(sigAlgorithm, candidate.algorithm) <= 0) continue;
            bestSigAlgorithmOnSdkVersion.put(sigMinSdkVersion, sig);
        }
        if (minSdkVersion < minProvidedSignaturesVersion) {
            throw new NoSupportedSignaturesException("Minimum provided signature version " + minProvidedSignaturesVersion + " > minSdkVersion " + minSdkVersion);
        }
        if (bestSigAlgorithmOnSdkVersion.isEmpty()) {
            throw new NoSupportedSignaturesException("No supported signature");
        }
        ArrayList<SupportedSignature> signaturesToVerify = new ArrayList<SupportedSignature>(bestSigAlgorithmOnSdkVersion.values());
        Collections.sort(signaturesToVerify, (Comparator & Serializable)(sig1, sig2) -> Integer.compare(sig1.algorithm.getId(), sig2.algorithm.getId()));
        return signaturesToVerify;
    }

    public static List<Pair<Integer, byte[]>> generateSignaturesOverData(SignerConfig signerConfig, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        ArrayList<Pair<Integer, byte[]>> signatures = new ArrayList<Pair<Integer, byte[]>>(signerConfig.signatureAlgorithms.size());
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            byte[] signatureBytes;
            Signature signature;
            Pair<String, ? extends AlgorithmParameterSpec> sigAlgAndParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams();
            String jcaSignatureAlgorithm = sigAlgAndParams.getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = sigAlgAndParams.getSecond();
            try {
                signature = Signature.getInstance(jcaSignatureAlgorithm);
                signature.initSign(signerConfig.privateKey);
                if (jcaSignatureAlgorithmParams != null) {
                    signature.setParameter(jcaSignatureAlgorithmParams);
                }
                signature.update(data);
                signatureBytes = signature.sign();
            }
            catch (InvalidKeyException e11) {
                throw new InvalidKeyException("Failed to sign using " + jcaSignatureAlgorithm, e11);
            }
            catch (InvalidAlgorithmParameterException | SignatureException e12) {
                throw new SignatureException("Failed to sign using " + jcaSignatureAlgorithm, e12);
            }
            try {
                signature = Signature.getInstance(jcaSignatureAlgorithm);
                signature.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    signature.setParameter(jcaSignatureAlgorithmParams);
                }
                signature.update(data);
                if (!signature.verify(signatureBytes)) {
                    throw new SignatureException("Failed to verify generated " + jcaSignatureAlgorithm + " signature using public key from certificate");
                }
            }
            catch (InvalidKeyException e13) {
                throw new InvalidKeyException("Failed to verify generated " + jcaSignatureAlgorithm + " signature using public key from certificate", e13);
            }
            catch (InvalidAlgorithmParameterException | SignatureException e14) {
                throw new SignatureException("Failed to verify generated " + jcaSignatureAlgorithm + " signature using public key from certificate", e14);
            }
            signatures.add(Pair.of(signatureAlgorithm.getId(), signatureBytes));
        }
        return signatures;
    }

    public static byte[] generatePkcs7DerEncodedMessage(byte[] signatureBytes, ByteBuffer data, List<X509Certificate> signerCerts, AlgorithmIdentifier digestAlgorithmId, AlgorithmIdentifier signatureAlgorithmId) throws Asn1EncodingException, CertificateEncodingException {
        SignerInfo signerInfo = new SignerInfo();
        signerInfo.version = 1;
        X509Certificate signingCert = signerCerts.get(0);
        X500Principal signerCertIssuer = signingCert.getIssuerX500Principal();
        signerInfo.sid = new SignerIdentifier(new IssuerAndSerialNumber(new Asn1OpaqueObject(signerCertIssuer.getEncoded()), signingCert.getSerialNumber()));
        signerInfo.digestAlgorithm = digestAlgorithmId;
        signerInfo.signatureAlgorithm = signatureAlgorithmId;
        signerInfo.signature = ByteBuffer.wrap(signatureBytes);
        SignedData signedData = new SignedData();
        signedData.certificates = new ArrayList<Asn1OpaqueObject>(signerCerts.size());
        for (X509Certificate cert : signerCerts) {
            signedData.certificates.add(new Asn1OpaqueObject(cert.getEncoded()));
        }
        signedData.version = 1;
        signedData.digestAlgorithms = Collections.singletonList(digestAlgorithmId);
        signedData.encapContentInfo = new EncapsulatedContentInfo("1.2.840.113549.1.7.1");
        signedData.encapContentInfo.content = data;
        signedData.signerInfos = Collections.singletonList(signerInfo);
        ContentInfo contentInfo = new ContentInfo();
        contentInfo.contentType = "1.2.840.113549.1.7.2";
        contentInfo.content = new Asn1OpaqueObject(Asn1DerEncoder.encode(signedData));
        return Asn1DerEncoder.encode(contentInfo);
    }

    public static byte[] pickBestDigestForV4(Map<ContentDigestAlgorithm, byte[]> contentDigests) {
        for (ContentDigestAlgorithm algo : V4_CONTENT_DIGEST_ALGORITHMS) {
            if (!contentDigests.containsKey((Object)algo)) continue;
            return contentDigests.get((Object)algo);
        }
        return null;
    }

    public static class SigningSchemeBlockAndDigests {
        public final Pair<byte[], Integer> signingSchemeBlock;
        public final Map<ContentDigestAlgorithm, byte[]> digestInfo;

        public SigningSchemeBlockAndDigests(Pair<byte[], Integer> signingSchemeBlock, Map<ContentDigestAlgorithm, byte[]> digestInfo) {
            this.signingSchemeBlock = signingSchemeBlock;
            this.digestInfo = digestInfo;
        }
    }

    public static class SupportedSignature {
        public final SignatureAlgorithm algorithm;
        public final byte[] signature;

        public SupportedSignature(SignatureAlgorithm algorithm, byte[] signature) {
            this.algorithm = algorithm;
            this.signature = signature;
        }
    }

    public static class Result {
        public final int signatureSchemeVersion;
        public boolean verified;
        public final List<SignerInfo> signers = new ArrayList<SignerInfo>();
        public SigningCertificateLineage signingCertificateLineage = null;
        private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
        private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

        public Result(int signatureSchemeVersion) {
            this.signatureSchemeVersion = signatureSchemeVersion;
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (!this.signers.isEmpty()) {
                for (SignerInfo signer : this.signers) {
                    if (!signer.containsErrors()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean containsWarnings() {
            if (!this.mWarnings.isEmpty()) {
                return true;
            }
            if (!this.signers.isEmpty()) {
                for (SignerInfo signer : this.signers) {
                    if (!signer.containsWarnings()) continue;
                    return true;
                }
            }
            return false;
        }

        public void addError(ApkVerifier.Issue msg, Object ... parameters) {
            this.mErrors.add(new ApkVerifier.IssueWithParams(msg, parameters));
        }

        public void addWarning(ApkVerifier.Issue msg, Object ... parameters) {
            this.mWarnings.add(new ApkVerifier.IssueWithParams(msg, parameters));
        }

        public List<ApkVerifier.IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerifier.IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        public static class SignerInfo {
            public int index;
            public List<X509Certificate> certs = new ArrayList<X509Certificate>();
            public List<ContentDigest> contentDigests = new ArrayList<ContentDigest>();
            public Map<ContentDigestAlgorithm, byte[]> verifiedContentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
            public List<Signature> signatures = new ArrayList<Signature>();
            public Map<SignatureAlgorithm, byte[]> verifiedSignatures = new HashMap<SignatureAlgorithm, byte[]>();
            public List<AdditionalAttribute> additionalAttributes = new ArrayList<AdditionalAttribute>();
            public byte[] signedData;
            public int minSdkVersion;
            public int maxSdkVersion;
            public SigningCertificateLineage signingCertificateLineage;
            private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
            private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

            public void addError(ApkVerifier.Issue msg, Object ... parameters) {
                this.mErrors.add(new ApkVerifier.IssueWithParams(msg, parameters));
            }

            public void addWarning(ApkVerifier.Issue msg, Object ... parameters) {
                this.mWarnings.add(new ApkVerifier.IssueWithParams(msg, parameters));
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public boolean containsWarnings() {
                return !this.mWarnings.isEmpty();
            }

            public List<ApkVerifier.IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerifier.IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public static class AdditionalAttribute {
                private final int mId;
                private final byte[] mValue;

                public AdditionalAttribute(int id2, byte[] value) {
                    this.mId = id2;
                    this.mValue = (byte[])value.clone();
                }

                public int getId() {
                    return this.mId;
                }

                public byte[] getValue() {
                    return (byte[])this.mValue.clone();
                }
            }

            public static class Signature {
                private final int mAlgorithmId;
                private final byte[] mValue;

                public Signature(int algorithmId, byte[] value) {
                    this.mAlgorithmId = algorithmId;
                    this.mValue = value;
                }

                public int getAlgorithmId() {
                    return this.mAlgorithmId;
                }

                public byte[] getValue() {
                    return this.mValue;
                }
            }

            public static class ContentDigest {
                private final int mSignatureAlgorithmId;
                private final byte[] mValue;

                public ContentDigest(int signatureAlgorithmId, byte[] value) {
                    this.mSignatureAlgorithmId = signatureAlgorithmId;
                    this.mValue = value;
                }

                public int getSignatureAlgorithmId() {
                    return this.mSignatureAlgorithmId;
                }

                public byte[] getValue() {
                    return this.mValue;
                }
            }
        }
    }

    public static class SignerConfig {
        public PrivateKey privateKey;
        public List<X509Certificate> certificates;
        public List<SignatureAlgorithm> signatureAlgorithms;
        public int minSdkVersion;
        public int maxSdkVersion;
        public SigningCertificateLineage mSigningCertificateLineage;
    }

    public static class SignatureNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SignatureNotFoundException(String message2) {
            super(message2);
        }

        public SignatureNotFoundException(String message2, Throwable cause) {
            super(message2, cause);
        }
    }

    public static class NoSupportedSignaturesException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoSupportedSignaturesException(String message2) {
            super(message2);
        }
    }

    public static class VerityTreeAndDigest {
        public final ContentDigestAlgorithm contentDigestAlgorithm;
        public final byte[] rootHash;
        public final byte[] tree;

        VerityTreeAndDigest(ContentDigestAlgorithm contentDigestAlgorithm, byte[] rootHash, byte[] tree) {
            this.contentDigestAlgorithm = contentDigestAlgorithm;
            this.rootHash = rootHash;
            this.tree = tree;
        }
    }

    private static class ChunkSupplier
    implements Supplier<Chunk> {
        private final DataSource[] dataSources;
        private final int[] chunkCounts;
        private final int totalChunkCount;
        private final AtomicInteger nextIndex;

        private ChunkSupplier(DataSource[] dataSources) {
            this.dataSources = dataSources;
            this.chunkCounts = new int[dataSources.length];
            int totalChunkCount = 0;
            for (int i11 = 0; i11 < dataSources.length; ++i11) {
                long chunkCount = ApkSigningBlockUtils.getChunkCount(dataSources[i11].size(), 0x100000L);
                if (chunkCount > Integer.MAX_VALUE) {
                    throw new RuntimeException(String.format("Number of chunks in dataSource[%d] is greater than max int.", i11));
                }
                this.chunkCounts[i11] = (int)chunkCount;
                totalChunkCount = (int)((long)totalChunkCount + chunkCount);
            }
            this.totalChunkCount = totalChunkCount;
            this.nextIndex = new AtomicInteger(0);
        }

        @Override
        public Chunk get() {
            long dataSourceChunkOffset;
            int index = this.nextIndex.getAndIncrement();
            if (index < 0 || index >= this.totalChunkCount) {
                return null;
            }
            int dataSourceIndex = 0;
            for (dataSourceChunkOffset = (long)index; dataSourceIndex < this.dataSources.length && dataSourceChunkOffset >= (long)this.chunkCounts[dataSourceIndex]; dataSourceChunkOffset -= (long)this.chunkCounts[dataSourceIndex], ++dataSourceIndex) {
            }
            long remainingSize = Math.min(this.dataSources[dataSourceIndex].size() - dataSourceChunkOffset * 0x100000L, 0x100000L);
            int size = (int)remainingSize;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            try {
                this.dataSources[dataSourceIndex].copyTo(dataSourceChunkOffset * 0x100000L, size, buffer);
            }
            catch (IOException e11) {
                throw new IllegalStateException("Failed to read chunk", e11);
            }
            buffer.rewind();
            return new Chunk(index, buffer, size);
        }

        static class Chunk {
            private final int chunkIndex;
            private final ByteBuffer data;
            private final int size;

            private Chunk(int chunkIndex, ByteBuffer data, int size) {
                this.chunkIndex = chunkIndex;
                this.data = data;
                this.size = size;
            }
        }
    }

    private static class ChunkDigester
    implements Runnable {
        private final ChunkSupplier dataSupplier;
        private final List<ChunkDigests> chunkDigests;
        private final List<MessageDigest> messageDigests;
        private final DataSink mdSink;

        private ChunkDigester(ChunkSupplier dataSupplier, List<ChunkDigests> chunkDigests) {
            this.dataSupplier = dataSupplier;
            this.chunkDigests = chunkDigests;
            this.messageDigests = new ArrayList<MessageDigest>(chunkDigests.size());
            for (ChunkDigests chunkDigest : chunkDigests) {
                try {
                    this.messageDigests.add(chunkDigest.createMessageDigest());
                }
                catch (NoSuchAlgorithmException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            this.mdSink = DataSinks.asDataSink(this.messageDigests.toArray(new MessageDigest[0]));
        }

        @Override
        public void run() {
            byte[] chunkContentPrefix = new byte[5];
            chunkContentPrefix[0] = -91;
            try {
                ChunkSupplier.Chunk chunk = this.dataSupplier.get();
                while (chunk != null) {
                    int size = chunk.size;
                    if ((long)size > 0x100000L) {
                        throw new RuntimeException("Chunk size greater than expected: " + size);
                    }
                    ApkSigningBlockUtils.setUnsignedInt32LittleEndian(size, chunkContentPrefix, 1);
                    this.mdSink.consume(chunkContentPrefix, 0, chunkContentPrefix.length);
                    this.mdSink.consume(chunk.data);
                    for (int i11 = 0; i11 < this.chunkDigests.size(); ++i11) {
                        ChunkDigests chunkDigest = this.chunkDigests.get(i11);
                        int actualDigestSize = this.messageDigests.get(i11).digest(chunkDigest.concatOfDigestsOfChunks, chunkDigest.getOffset(chunk.chunkIndex), chunkDigest.digestOutputSize);
                        if (actualDigestSize == chunkDigest.digestOutputSize) continue;
                        throw new RuntimeException("Unexpected output size of " + (Object)((Object)chunkDigest.algorithm) + " digest: " + actualDigestSize);
                    }
                    chunk = this.dataSupplier.get();
                }
            }
            catch (IOException | DigestException e11) {
                throw new RuntimeException(e11);
            }
        }
    }

    private static class ChunkDigests {
        private final ContentDigestAlgorithm algorithm;
        private final int digestOutputSize;
        private final byte[] concatOfDigestsOfChunks;

        private ChunkDigests(ContentDigestAlgorithm algorithm, int chunkCount) {
            this.algorithm = algorithm;
            this.digestOutputSize = this.algorithm.getChunkDigestOutputSizeBytes();
            this.concatOfDigestsOfChunks = new byte[5 + chunkCount * this.digestOutputSize];
            this.concatOfDigestsOfChunks[0] = 90;
            ApkSigningBlockUtils.setUnsignedInt32LittleEndian(chunkCount, this.concatOfDigestsOfChunks, 1);
        }

        private MessageDigest createMessageDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance(this.algorithm.getJcaMessageDigestAlgorithm());
        }

        private int getOffset(int chunkIndex) {
            return 5 + chunkIndex * this.digestOutputSize;
        }
    }
}

