/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.util.function.Function;
import org.gradle.internal.classpath.Instrumented;
import shadow.bundletool.com.android.ddmlib.Log;

public final class DdmPreferences {
    public static final boolean DEFAULT_INITIAL_THREAD_UPDATE = false;
    public static final boolean DEFAULT_INITIAL_HEAP_UPDATE = false;
    public static final Log.LogLevel DEFAULT_LOG_LEVEL = Log.LogLevel.ERROR;
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_PROFILER_BUFFER_SIZE_MB = 8;
    public static final boolean DEFAULT_USE_ADBHOST = false;
    public static final String DEFAULT_ADBHOST_VALUE = "127.0.0.1";
    private static boolean sThreadUpdate = false;
    private static boolean sInitialHeapUpdate = false;
    private static Log.LogLevel sLogLevel = DEFAULT_LOG_LEVEL;
    private static int sTimeOut = 5000;
    private static int sProfilerBufferSizeMb = 8;
    private static boolean sUseAdbHost = false;
    private static String sAdbHostValue = "127.0.0.1";
    private static int sJdwpMaxPacketSize = DdmPreferences.getPropertyOrDefault("DDMLIB_JDWP_MAX_PACKET_SIZE", 0x32000000, Integer::parseInt);
    private static boolean sJdwpProxyEnabled = DdmPreferences.getPropertyOrDefault("DDMLIB_JDWP_PROXY_ENABLED", true, Boolean::parseBoolean);
    private static int sJdwpProxyPort = DdmPreferences.getPropertyOrDefault("DDMLIB_JDWP_PROXY_PORT", 8599, Integer::parseInt);

    public static boolean getInitialThreadUpdate() {
        return sThreadUpdate;
    }

    public static void setInitialThreadUpdate(boolean state) {
        sThreadUpdate = state;
    }

    public static boolean getInitialHeapUpdate() {
        return sInitialHeapUpdate;
    }

    public static void setInitialHeapUpdate(boolean state) {
        sInitialHeapUpdate = state;
    }

    public static Log.LogLevel getLogLevel() {
        return sLogLevel;
    }

    public static void setLogLevel(String value) {
        sLogLevel = Log.LogLevel.getByString(value);
        Log.setLevel(sLogLevel);
    }

    public static int getTimeOut() {
        return sTimeOut;
    }

    public static void setTimeOut(int timeOut) {
        sTimeOut = timeOut;
    }

    public static int getProfilerBufferSizeMb() {
        return sProfilerBufferSizeMb;
    }

    public static void setProfilerBufferSizeMb(int bufferSizeMb) {
        sProfilerBufferSizeMb = bufferSizeMb;
    }

    public static boolean getUseAdbHost() {
        return sUseAdbHost;
    }

    public static void setUseAdbHost(boolean useAdbHost) {
        sUseAdbHost = useAdbHost;
    }

    public static String getAdbHostValue() {
        return sAdbHostValue;
    }

    public static void setAdbHostValue(String adbHostValue) {
        sAdbHostValue = adbHostValue;
    }

    public static void enableJdwpProxyService(boolean enabled) {
        sJdwpProxyEnabled = enabled;
    }

    public static boolean isJdwpProxyEnabled() {
        return sJdwpProxyEnabled;
    }

    public static void setJdwpProxyPort(int port) {
        sJdwpProxyPort = port;
    }

    public static int getJdwpProxyPort() {
        return sJdwpProxyPort;
    }

    private static <T> T getPropertyOrDefault(String property, T def, Function<String, T> parser) {
        try {
            return parser.apply(Instrumented.systemProperty((String)property, (String)(def + ""), (String)"shadow.bundletool.com.android.ddmlib.DdmPreferences"));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public static int getJdwpMaxPacketSize() {
        return sJdwpMaxPacketSize;
    }

    public static void setsJdwpMaxPacketSize(int size) {
        sJdwpMaxPacketSize = size;
    }

    private DdmPreferences() {
    }
}

