/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.jdwp;

import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.JdwpClientManager;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.JdwpClientManagerId;

public class JdwpClientManagerFactory {
    private Map<JdwpClientManagerId, JdwpClientManager> myConnections = new HashMap<JdwpClientManagerId, JdwpClientManager>();
    Selector selector;

    public JdwpClientManagerFactory(Selector selector) {
        this.selector = selector;
    }

    public JdwpClientManager getConnection(String deviceId, int pid) {
        return this.myConnections.getOrDefault(new JdwpClientManagerId(deviceId, pid), null);
    }

    public JdwpClientManager createConnection(JdwpClientManagerId id2) throws AdbCommandRejectedException, TimeoutException, IOException {
        JdwpClientManager connection = this.myConnections.get(id2);
        if (connection == null) {
            connection = new JdwpClientManager(id2, this.selector);
            connection.addShutdownListener((JdwpClientManager.ShutdownListener & Serializable)() -> this.myConnections.remove(id2));
            this.myConnections.put(id2, connection);
        }
        return connection;
    }
}

