/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.SdkConstants;
import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.LineCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class ApkInfoParser {
    private static final Pattern PATTERN = Pattern.compile("^package: name='([^']+)' versionCode='([0-9]*)' versionName='([^']*)'.*$");
    private final File aapt2File;
    private final ProcessExecutor mProcessExecutor;

    public ApkInfoParser(File aapt2File, ProcessExecutor processExecutor) {
        this.aapt2File = FileInterceptorsDeclaration.intercept_isDirectory((File)aapt2File, (String)"com.android.builder.core.ApkInfoParser") ? new File(aapt2File, SdkConstants.FN_AAPT2) : aapt2File;
        if (!this.aapt2File.getName().toLowerCase(Locale.ENGLISH).startsWith("aapt2")) {
            throw new IllegalStateException("AAPT is deprecated now, AAPT2 should be used instead");
        }
        this.mProcessExecutor = processExecutor;
    }

    public ApkInfo parseApk(File apkFile) throws ProcessException {
        if (!FileInterceptorsDeclaration.intercept_isFile((File)this.aapt2File, (String)"com.android.builder.core.ApkInfoParser")) {
            throw new IllegalStateException("aapt is missing from location: " + this.aapt2File.getAbsolutePath());
        }
        return ApkInfoParser.getApkInfo(this.getAaptOutput(apkFile));
    }

    @VisibleForTesting
    static ApkInfo getApkInfo(List<String> aaptOutput) {
        String pkgName = null;
        String versionCode = null;
        String versionName = null;
        for (String line : aaptOutput) {
            Matcher m11 = PATTERN.matcher(line);
            if (!m11.matches()) continue;
            pkgName = m11.group(1);
            versionCode = m11.group(2);
            versionName = m11.group(3);
            break;
        }
        if (pkgName == null) {
            throw new RuntimeException("Failed to find apk information with aapt");
        }
        Integer intVersionCode = null;
        try {
            intVersionCode = Integer.parseInt(versionCode);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new ApkInfo(pkgName, intVersionCode, versionName);
    }

    public List<String> getAaptOutput(File apkFile) throws ProcessException {
        return this.invokeAaptWithParameters(apkFile, "dump", "badging");
    }

    public List<String> getManifestContent(File apkFile) throws ProcessException {
        return this.invokeAaptWithParameters(apkFile, "dump", "xmltree", "--file", "AndroidManifest.xml");
    }

    public List<String> getConfigurations(File apkFile) throws ProcessException {
        return this.invokeAaptWithParameters(apkFile, "dump", "configurations");
    }

    private List<String> invokeAaptWithParameters(File apkFile, String ... parameters) throws ProcessException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.aapt2File);
        builder.addArgs(parameters);
        builder.addArgs(apkFile.getPath());
        CachedProcessOutputHandler processOutputHandler = new CachedProcessOutputHandler();
        this.mProcessExecutor.execute(builder.createProcess(), (ProcessOutputHandler)processOutputHandler).rethrowFailure();
        BaseProcessOutputHandler.BaseProcessOutput output2 = processOutputHandler.getProcessOutput();
        LineCollector lineCollector = new LineCollector();
        output2.processStandardOutputLines((LineProcessor)lineCollector);
        return lineCollector.getResult();
    }

    public static final class ApkInfo {
        private final String mPackageName;
        private final Integer mVersionCode;
        private final String mVersionName;

        private ApkInfo(String packageName, Integer versionCode, String versionName) {
            this.mPackageName = packageName;
            this.mVersionCode = versionCode;
            this.mVersionName = versionName;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public Integer getVersionCode() {
            return this.mVersionCode;
        }

        public String getVersionName() {
            return this.mVersionName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("packageName", (Object)this.mPackageName).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).toString();
        }
    }
}

