/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.DirectoryBasedClassFileInput;
import com.android.utils.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

final class FileBasedClassFileEntry
implements ClassFileEntry {
    private final String relativePath;
    private final Path fullPath;
    private final DirectoryBasedClassFileInput input;

    public FileBasedClassFileEntry(Path rootPath, Path fullPath, DirectoryBasedClassFileInput input) {
        this.relativePath = PathUtils.toSystemIndependentPath((Path)rootPath.relativize(fullPath));
        this.fullPath = fullPath;
        this.input = input;
    }

    @Override
    public String name() {
        return this.fullPath.getFileName().toString();
    }

    @Override
    public long getSize() throws IOException {
        return Files.size(this.fullPath);
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public ClassFileInput getInput() {
        return this.input;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return NioFileInterceptors.intercept_readAllBytes((Path)this.fullPath, (String)"com.android.builder.dexing.FileBasedClassFileEntry");
    }

    @Override
    public int readAllBytes(byte[] bytes) throws IOException {
        try (SeekableByteChannel sbc = NioFileInterceptors.intercept_newByteChannel((Path)this.fullPath, (OpenOption[])new OpenOption[0], (String)"com.android.builder.dexing.FileBasedClassFileEntry");){
            int n11;
            block13: {
                InputStream in2 = Channels.newInputStream(sbc);
                try {
                    long size = sbc.size();
                    if (size > (long)bytes.length) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    n11 = in2.read(bytes, 0, (int)size);
                    if (in2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in2.close();
            }
            return n11;
        }
    }
}

