/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing.r8;

import com.android.builder.dexing.r8.CachingArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.DirectoryClassFileProvider;
import com.android.tools.r8.ProgramResource;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class ClassFileProviderFactory
implements Closeable {
    private static final AtomicLong nextId = new AtomicLong();
    private List<ClassFileResourceProvider> providers;
    private final OrderedClassFileResourceProvider orderedClassFileResourceProvider;
    private final long id = nextId.addAndGet(1L);

    public ClassFileProviderFactory(Collection<Path> paths) throws IOException {
        this.providers = Lists.newArrayListWithExpectedSize((int)paths.size());
        for (Path path : paths) {
            if (!FileInterceptorsDeclaration.intercept_exists((File)path.toFile(), (String)"com.android.builder.dexing.r8.ClassFileProviderFactory")) continue;
            this.providers.add(ClassFileProviderFactory.createProvider(path));
        }
        this.orderedClassFileResourceProvider = new OrderedClassFileResourceProvider(this.providers);
    }

    public long getId() {
        return this.id;
    }

    @Override
    public void close() throws IOException {
        for (ClassFileResourceProvider provider : this.providers) {
            if (!(provider instanceof Closeable)) continue;
            ((Closeable)((Object)provider)).close();
        }
        this.providers.clear();
    }

    public ClassFileResourceProvider getOrderedProvider() {
        return this.orderedClassFileResourceProvider;
    }

    private static ClassFileResourceProvider createProvider(Path entry) throws IOException {
        if (NioFileInterceptors.intercept_isRegularFile((Path)entry, (LinkOption[])new LinkOption[0], (String)"com.android.builder.dexing.r8.ClassFileProviderFactory")) {
            return new CachingArchiveClassFileProvider(entry);
        }
        if (NioFileInterceptors.intercept_isDirectory((Path)entry, (LinkOption[])new LinkOption[0], (String)"com.android.builder.dexing.r8.ClassFileProviderFactory")) {
            return DirectoryClassFileProvider.fromDirectory(entry);
        }
        throw new FileNotFoundException(entry.toString());
    }

    private static class OrderedClassFileResourceProvider
    implements ClassFileResourceProvider {
        private final java.util.function.Supplier<Map<String, ClassFileResourceProvider>> descriptors = Suppliers.memoize((Supplier & Serializable)() -> {
            HashMap descs = Maps.newHashMap();
            for (ClassFileResourceProvider provider : providers) {
                for (String s11 : provider.getClassDescriptors()) {
                    if (descs.containsKey(s11)) continue;
                    descs.put(s11, provider);
                }
            }
            return descs;
        });

        OrderedClassFileResourceProvider(List<ClassFileResourceProvider> providers) {
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.descriptors.get().keySet();
        }

        @Override
        public ProgramResource getProgramResource(String descriptor) {
            ClassFileResourceProvider provider = this.descriptors.get().get(descriptor);
            if (provider == null) {
                return null;
            }
            return provider.getProgramResource(descriptor);
        }
    }
}

