/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.DirectoryEntry;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.ZipCentralDirectory;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public final class RelativeFiles {
    private RelativeFiles() {
    }

    public static Set<RelativeFile> fromDirectory(File directory) {
        return Collections.unmodifiableSet(RelativeFiles.fromDirectory(directory, directory));
    }

    public static Set<RelativeFile> fromDirectory(File directory, Predicate<RelativeFile> filter) {
        return Collections.unmodifiableSet(Sets.filter(RelativeFiles.fromDirectory(directory, directory), filter::test));
    }

    private static Set<RelativeFile> fromDirectory(File base, File directory) {
        File[] directoryFiles;
        Preconditions.checkArgument((boolean)FileInterceptorsDeclaration.intercept_isDirectory((File)base, (String)"com.android.builder.files.RelativeFiles"), (String)"!File.isDirectory(): %s", (Object)base);
        Preconditions.checkArgument((boolean)FileInterceptorsDeclaration.intercept_isDirectory((File)directory, (String)"com.android.builder.files.RelativeFiles"), (String)"!File.isDirectory(): %s", (Object)directory);
        HashSet files = Sets.newHashSet();
        for (File file : directoryFiles = (File[])Verify.verifyNotNull((Object)FileInterceptorsDeclaration.intercept_listFiles((File)directory, (String)"com.android.builder.files.RelativeFiles"), (String)"directory.listFiles() == null", (Object[])new Object[0])) {
            if (FileInterceptorsDeclaration.intercept_isDirectory((File)file, (String)"com.android.builder.files.RelativeFiles")) {
                files.addAll(RelativeFiles.fromDirectory(base, file));
                continue;
            }
            files.add(new RelativeFile(base, file));
        }
        return files;
    }

    public static Predicate<RelativeFile> fromPathPredicate(Predicate<String> predicate) {
        return (Predicate<RelativeFile> & Serializable)rf2 -> predicate.test(rf2.getRelativePath());
    }

    public static Set<RelativeFile> fromZip(ZipCentralDirectory zip) throws IOException {
        Collection<DirectoryEntry> values = zip.getEntries().values();
        HashSet files = Sets.newHashSetWithExpectedSize((int)values.size());
        for (DirectoryEntry entry : values) {
            files.add(new RelativeFile(zip.getFile(), entry.getName()));
        }
        return Collections.unmodifiableSet(files);
    }
}

