/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.builder.packaging.DexPackagingMode;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.text.StringsKt;

public class PackagingUtils {
    public static final ImmutableList<String> DEFAULT_AAPT_NO_COMPRESS_EXTENSIONS = ImmutableList.of((Object)".jpg", (Object)".jpeg", (Object)".png", (Object)".gif", (Object)".opus", (Object)".wav", (Object)".mp2", (Object)".mp3", (Object)".ogg", (Object)".aac", (Object)".mpg", (Object)".mpeg", (Object[])new String[]{".mid", ".midi", ".smf", ".jet", ".rtttl", ".imy", ".xmf", ".mp4", ".m4a", ".m4v", ".3gp", ".3gpp", ".3g2", ".3gpp2", ".amr", ".awb", ".wma", ".wmv", ".webm", ".mkv", ".webp"});
    public static final ImmutableList<String> DEFAULT_NO_COMPRESS_FILE_NAMES = ImmutableList.of((Object)"baseline.prof", (Object)"baseline.profm");
    public static final ImmutableSet<Character> ECMA_SCRIPT_ESCAPABLE_CHARACTERS = ImmutableSet.of((Object)Character.valueOf('^'), (Object)Character.valueOf('$'), (Object)Character.valueOf('\\'), (Object)Character.valueOf('.'), (Object)Character.valueOf('*'), (Object)Character.valueOf('+'), (Object[])new Character[]{Character.valueOf('?'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|')});
    private static final ImmutableList<String> NON_RESOURCES_EXTENSIONS = ImmutableList.builder().add((Object)"aidl").add((Object)"rs").add((Object)"fs").add((Object)"rsh").add((Object)"d").add((Object)"java").add((Object)"scala").add((Object)"scc").add((Object)"swp").build();
    public static final ImmutableList<String> SIGNING_EXTENSIONS = ImmutableList.of((Object)"SF", (Object)"RSA", (Object)"DSA", (Object)"EC");

    public static boolean checkFileForApkPackaging(String filePath, boolean allowClassFiles) {
        String fileName = new File(filePath).getName();
        return !PackagingUtils.isOfNonResourcesExtensions(Files.getFileExtension((String)fileName), allowClassFiles) && !filePath.equals("META-INF/MANIFEST.MF") && !PackagingUtils.isUsedForSigning(filePath) && !PackagingUtils.isMavenMetadata(filePath);
    }

    private static boolean isMavenMetadata(String filePath) {
        return filePath.startsWith("META-INF/maven");
    }

    private static boolean isUsedForSigning(String filePath) {
        if (!"META-INF".equals(new File(filePath).getParent())) {
            return false;
        }
        String fileExtension = Files.getFileExtension((String)filePath);
        for (String extension : SIGNING_EXTENSIONS) {
            if (!fileExtension.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOfNonResourcesExtensions(String extension, boolean allowClassFiles) {
        for (String ext : NON_RESOURCES_EXTENSIONS) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return !allowClassFiles && "class".equals(extension);
    }

    public static Predicate<String> getNoCompressPredicate(Collection<String> aaptOptionsNoCompress, NativeLibrariesPackagingMode nativeLibsPackagingMode, DexPackagingMode dexPackagingMode) {
        ImmutableList.Builder finalList = ImmutableList.builder();
        finalList.addAll(PackagingUtils.getAllNoCompressFileNames());
        PackagingUtils.getAllNoCompressExtensions((ImmutableList.Builder<String>)finalList, aaptOptionsNoCompress, nativeLibsPackagingMode, dexPackagingMode);
        return PackagingUtils.getNoCompressPredicateForExtensions((Iterable<String>)finalList.build());
    }

    public static Predicate<String> getNoCompressPredicateForJavaRes(Collection<String> aaptOptionsNoCompress) {
        ImmutableList.Builder finalList = ImmutableList.builder();
        PackagingUtils.getAllNoCompressExtensions((ImmutableList.Builder<String>)finalList, aaptOptionsNoCompress, NativeLibrariesPackagingMode.COMPRESSED, DexPackagingMode.COMPRESSED);
        return PackagingUtils.getNoCompressPredicateForExtensions((Iterable<String>)finalList.build());
    }

    public static List<String> getNoCompressGlobsForBundle(Collection<String> aaptOptionsNoCompress) {
        ImmutableList.Builder extensions = ImmutableList.builder();
        PackagingUtils.getAllNoCompressExtensions((ImmutableList.Builder<String>)extensions, aaptOptionsNoCompress, NativeLibrariesPackagingMode.COMPRESSED, DexPackagingMode.COMPRESSED);
        return (List)extensions.build().stream().map(PackagingUtils::toCaseInsensitiveGlobForBundle).sorted().collect(ImmutableList.toImmutableList());
    }

    private static String toCaseInsensitiveGlobForBundle(String glob) {
        return PackagingUtils.toCaseInsensitiveGlob(glob, "**", "[", "", "]", (Collection<Character>)ImmutableList.of());
    }

    public static List<String> getNoCompressForAapt(Collection<String> aaptOptionsNoCompress) {
        return (List)aaptOptionsNoCompress.stream().map(PackagingUtils::toCaseInsensitiveGlobForAapt).sorted().collect(ImmutableList.toImmutableList());
    }

    private static String toCaseInsensitiveGlobForAapt(String glob) {
        return PackagingUtils.toCaseInsensitiveGlob(glob, "", "(", "|", ")", ECMA_SCRIPT_ESCAPABLE_CHARACTERS);
    }

    private static String toCaseInsensitiveGlob(String glob, String prefix, String alternativesStart, String alternativesSeparator, String alternativesEnd, Collection<Character> escapableCharacters) {
        int codePoint;
        StringBuilder sb2 = new StringBuilder(glob.length() + prefix.length());
        sb2.append(prefix);
        for (int index = 0; index < glob.length(); index += Character.charCount(codePoint)) {
            boolean mixedCase;
            codePoint = glob.codePointAt(index);
            int upperCodePoint = Character.toUpperCase(codePoint);
            int lowerCodePoint = Character.toLowerCase(codePoint);
            boolean bl2 = mixedCase = codePoint != upperCodePoint || codePoint != lowerCodePoint;
            if (mixedCase) {
                sb2.append(alternativesStart);
            }
            if (lowerCodePoint != codePoint) {
                sb2.appendCodePoint(lowerCodePoint);
                sb2.append(alternativesSeparator);
            }
            if (escapableCharacters.contains(Character.valueOf(glob.charAt(index)))) {
                sb2.append('\\');
            }
            sb2.appendCodePoint(codePoint);
            if (upperCodePoint != codePoint) {
                sb2.append(alternativesSeparator);
                sb2.appendCodePoint(upperCodePoint);
            }
            if (!mixedCase) continue;
            sb2.append(alternativesEnd);
        }
        return sb2.toString();
    }

    public static NativeLibrariesPackagingMode getNativeLibrariesLibrariesPackagingMode(Boolean extractNativeLibs) {
        if (Boolean.FALSE.equals(extractNativeLibs)) {
            return NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED;
        }
        return NativeLibrariesPackagingMode.COMPRESSED;
    }

    public static DexPackagingMode getDexPackagingMode(Boolean useEmbeddedDex, boolean useLegacyPackaging) {
        if (Boolean.TRUE.equals(useEmbeddedDex)) {
            return DexPackagingMode.UNCOMPRESSED;
        }
        if (useLegacyPackaging) {
            return DexPackagingMode.COMPRESSED;
        }
        return DexPackagingMode.UNCOMPRESSED;
    }

    @VisibleForTesting
    static Predicate<String> getNoCompressPredicateForExtensions(Iterable<String> noCompressExtensions) {
        return (Predicate<String> & Serializable)name -> {
            for (String extension : noCompressExtensions) {
                if (!StringsKt.endsWith((String)name, (String)extension, (boolean)true)) continue;
                return true;
            }
            return false;
        };
    }

    private static List<String> getAllNoCompressFileNames() {
        return DEFAULT_NO_COMPRESS_FILE_NAMES;
    }

    private static void getAllNoCompressExtensions(ImmutableList.Builder<String> into, Collection<String> aaptOptionsNoCompress, NativeLibrariesPackagingMode nativeLibrariesPackagingMode, DexPackagingMode dexPackagingMode) {
        into.addAll(DEFAULT_AAPT_NO_COMPRESS_EXTENSIONS);
        into.add((Object)".tflite");
        if (nativeLibrariesPackagingMode == NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED) {
            into.add((Object)".so");
        }
        if (dexPackagingMode == DexPackagingMode.UNCOMPRESSED) {
            into.add((Object)".dex");
        }
        if (aaptOptionsNoCompress != null) {
            into.addAll(aaptOptionsNoCompress);
        }
    }
}

