/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.SdkConstants;
import com.android.builder.internal.FakeAndroidTarget;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class PlatformLoader
implements SdkLoader {
    private static PlatformLoader sLoader;
    private final File mTreeLocation;
    private File mHostToolsFolder;
    private SdkInfo mSdkInfo;
    private final ImmutableList<File> mRepositories;

    public static synchronized SdkLoader getLoader(File treeLocation) {
        if (sLoader == null) {
            sLoader = new PlatformLoader(treeLocation);
        } else if (!FileUtils.isSameFile((File)treeLocation, (File)PlatformLoader.sLoader.mTreeLocation)) {
            throw new IllegalStateException(String.format("%s already created using %s; cannot also use %s", PlatformLoader.class.getSimpleName(), PlatformLoader.sLoader.mTreeLocation, treeLocation));
        }
        return sLoader;
    }

    public static synchronized void unload() {
        sLoader = null;
    }

    @Override
    public TargetInfo getTargetInfo(String targetHash, Revision buildToolRevision, ILogger logger, SdkLibData sdkLibData) {
        this.init(logger);
        FakeAndroidTarget androidTarget = new FakeAndroidTarget(this.mTreeLocation.getPath(), targetHash);
        Path hostTools = this.getHostToolsFolder().toPath();
        BuildToolInfo buildToolInfo = BuildToolInfo.modifiedLayout((Revision)buildToolRevision, (Path)this.mTreeLocation.toPath(), (Path)hostTools.resolve(SdkConstants.FN_AAPT), (Path)hostTools.resolve(SdkConstants.FN_AIDL), (Path)hostTools.resolve(SdkConstants.FN_RENDERSCRIPT), (Path)this.mTreeLocation.toPath().resolve("prebuilts/sdk/renderscript/include"), (Path)this.mTreeLocation.toPath().resolve("prebuilts/sdk/renderscript/clang-include"), (Path)hostTools.resolve(SdkConstants.FN_BCC_COMPAT), (Path)hostTools.resolve("arm-linux-androideabi-ld"), (Path)hostTools.resolve("aarch64-linux-android-ld"), (Path)hostTools.resolve("i686-linux-android-ld"), (Path)hostTools.resolve("x86_64-linux-android-ld"), (Path)hostTools.resolve("mipsel-linux-android-ld"), (Path)hostTools.resolve("lld"), (Path)hostTools.resolve(SdkConstants.FN_ZIPALIGN), (Path)hostTools.resolve(SdkConstants.FN_AAPT2));
        return new TargetInfo(androidTarget, buildToolInfo);
    }

    @Override
    public SdkInfo getSdkInfo(ILogger logger) {
        this.init(logger);
        return this.mSdkInfo;
    }

    @Override
    public ImmutableList<File> getRepositories() {
        return this.mRepositories;
    }

    @Override
    public File installSdkTool(SdkLibData sdkLibData, String packageId) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        progress.logWarning("Installing missing SDK components is not supported when building using an SDK from platform prebuilds.");
        return null;
    }

    @Override
    public ImmutableList<String> retrieveRepoIdsWithPrefix(SdkLibData sdkLibData, String prefix) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        progress.logWarning("Retrieving remote repositories is not supported when building using an SDK from platform prebuilds.");
        return null;
    }

    @Override
    public File getLocalEmulator(ILogger logger) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        progress.logWarning("Retrieving the Emulator is not supported when building using an SDK from platform prebuilds.");
        return null;
    }

    private PlatformLoader(File treeLocation) {
        this.mTreeLocation = treeLocation;
        this.mRepositories = ImmutableList.of((Object)new File(this.mTreeLocation + "/prebuilts/sdk/m2repository"));
    }

    private synchronized void init(ILogger logger) {
        if (this.mSdkInfo == null) {
            String host;
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                host = "darwin-x86";
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                host = "linux-x86";
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
            this.mSdkInfo = new SdkInfo(new File(this.mTreeLocation, "out/host/" + host + "/framework/annotations.jar"), new File(this.mTreeLocation, "out/host/" + host + "/bin/adb"));
        }
    }

    private synchronized File getHostToolsFolder() {
        if (this.mHostToolsFolder == null) {
            File tools = new File(this.mTreeLocation, "prebuilts/sdk/tools");
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                this.mHostToolsFolder = new File(tools, "darwin/bin");
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                this.mHostToolsFolder = new File(tools, "linux/bin");
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
            if (!FileInterceptorsDeclaration.intercept_isDirectory((File)this.mHostToolsFolder, (String)"com.android.builder.sdk.PlatformLoader")) {
                throw new IllegalStateException("Host tools folder missing: " + this.mHostToolsFolder.getAbsolutePath());
            }
        }
        return this.mHostToolsFolder;
    }
}

