/*
 * Decompiled with CFR 0.152.
 */
package com.google.gms.googleservices;

import com.google.gms.googleservices.GoogleServicesPlugin;
import com.google.gms.googleservices.GoogleServicesTask;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J&\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001b2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050 H\u0002J&\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001b2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050 H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u0005*\u00060\u001bj\u0002`#H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u001b*\u00060\u001bj\u0002`#2\u0006\u0010%\u001a\u00020\u0005H\u0002J&\u0010&\u001a\u00020\u0019*\u00060\u001bj\u0002`#2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050 H\u0002J&\u0010'\u001a\u00020\u0019*\u00060\u001bj\u0002`#2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050 H\u0002J$\u0010(\u001a\u00020\u0019*\u00060\u001bj\u0002`#2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050 J&\u0010)\u001a\u00020\u0019*\u00060\u001bj\u0002`#2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050 H\u0002J$\u0010*\u001a\u00020\u0019*\u00060\u001bj\u0002`#2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050 R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lcom/google/gms/googleservices/GoogleServicesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "gmpAppId", "Ljava/io/File;", "getGmpAppId", "googleServicesJsonFiles", "", "getGoogleServicesJsonFiles", "intermediateDir", "getIntermediateDir", "()Ljava/io/File;", "missingGoogleServicesStrategy", "Lcom/google/gms/googleservices/GoogleServicesPlugin$MissingGoogleServicesStrategy;", "getMissingGoogleServicesStrategy", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "action", "", "getClientForPackageName", "Lcom/google/gson/JsonObject;", "jsonObject", "handleFirebaseUrl", "rootObject", "resValues", "", "handleProjectNumberAndProjectId", "getAndroidApiKey", "Lcom/google/gms/googleservices/FirebaseClientData;", "getServiceByName", "serviceName", "handleAnalytics", "handleGoogleApiKey", "handleGoogleAppId", "handleMapsService", "handleWebClientId", "Companion", "google-services-plugin"})
public abstract class GoogleServicesTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String JSON_FILE_NAME = "google-services.json";
    @NotNull
    private static final String STATUS_DISABLED = "1";
    @NotNull
    private static final String STATUS_ENABLED = "2";
    @NotNull
    private static final String OAUTH_CLIENT_TYPE_WEB = "3";

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @Internal
    @NotNull
    public final File getIntermediateDir() {
        Object object = this.getOutputDirectory().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDirectory.asFile.get()");
        return (File)object;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract Property<Collection<File>> getGoogleServicesJsonFiles();

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Input
    @NotNull
    public abstract Property<GoogleServicesPlugin.MissingGoogleServicesStrategy> getMissingGoogleServicesStrategy();

    @OutputFile
    @NotNull
    public abstract Property<File> getGmpAppId();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() throws GradleException {
        JsonObject jsonObject;
        Object object;
        void $this$filterTo$iv$iv;
        Object object2 = this.getGoogleServicesJsonFiles().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"googleServicesJsonFiles.get()");
        Iterable $this$filter$iv = (Iterable)object2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!FileInterceptorsDeclaration.intercept_isFile((File)it, (String)"com.google.gms.googleservices.GoogleServicesTask")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jsonFiles = (List)destination$iv$iv;
        if (jsonFiles.isEmpty()) {
            Object object3 = this.getGoogleServicesJsonFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"googleServicesJsonFiles.get()");
            String message2 = StringsKt.trimIndent((String)("\n                File google-services.json is missing. \n                The Google Services Plugin cannot function without it. \n                Searched locations: " + CollectionsKt.joinToString$default((Iterable)((Iterable)object3), null, null, null, (int)0, null, (Function1)action.message.1.INSTANCE, (int)31, null) + "\n                "));
            GoogleServicesPlugin.MissingGoogleServicesStrategy missingGoogleServicesStrategy = (GoogleServicesPlugin.MissingGoogleServicesStrategy)((Object)this.getMissingGoogleServicesStrategy().get());
            switch (missingGoogleServicesStrategy == null ? -1 : WhenMappings.$EnumSwitchMapping$0[missingGoogleServicesStrategy.ordinal()]) {
                case 1: {
                    throw new GradleException(message2);
                }
                case 2: {
                    this.getLogger().warn(message2);
                }
            }
            return;
        }
        File quickstartFile = (File)CollectionsKt.first((List)jsonFiles);
        this.getLogger().info("Parsing json file: " + quickstartFile.getPath());
        File intermediateDir = ((Directory)this.getOutputDirectory().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)intermediateDir, (String)"intermediateDir");
        FilesKt.deleteRecursively((File)intermediateDir);
        if (!intermediateDir.mkdirs()) {
            throw new GradleException("Failed to create folder: " + intermediateDir);
        }
        JsonParser jsonParser = new JsonParser();
        destination$iv$iv = quickstartFile;
        Charset $i$f$filterTo22 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = destination$iv$iv;
        FileInputStream fileInputStream = new FileInputStream((File)object4);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)object4, (String)"com.google.gms.googleservices.GoogleServicesTask");
        object = new InputStreamReader((InputStream)fileInputStream, $i$f$filterTo22);
        JsonElement root = jsonParser.parse((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)));
        if (!root.isJsonObject()) {
            throw new GradleException("Malformed root json at " + quickstartFile.getAbsolutePath());
        }
        JsonObject rootObject = root.getAsJsonObject();
        Map resValues = new TreeMap();
        Intrinsics.checkNotNullExpressionValue((Object)rootObject, (String)"rootObject");
        this.handleProjectNumberAndProjectId(rootObject, resValues);
        this.handleFirebaseUrl(rootObject, resValues);
        JsonObject jsonObject2 = this.getClientForPackageName(rootObject);
        if (jsonObject2 == null) {
            throw new GradleException("No matching client found for package name '" + this.getApplicationId().get() + "' in " + quickstartFile.getPath());
        }
        JsonObject $this$action_u24lambda_u241 = jsonObject = jsonObject2;
        boolean bl = false;
        this.handleAnalytics($this$action_u24lambda_u241, resValues);
        this.handleMapsService($this$action_u24lambda_u241, resValues);
        this.handleGoogleApiKey($this$action_u24lambda_u241, resValues);
        this.handleGoogleAppId($this$action_u24lambda_u241, resValues);
        this.handleWebClientId($this$action_u24lambda_u241, resValues);
        File values = new File(intermediateDir, "values");
        if (!FileInterceptorsDeclaration.intercept_exists((File)values, (String)"com.google.gms.googleservices.GoogleServicesTask") && !values.mkdirs()) {
            throw new GradleException("Failed to create folder: " + values);
        }
        FilesKt.writeText((File)new File(values, "values.xml"), (String)GoogleServicesTask.Companion.getValuesContent(resValues), (Charset)Charsets.UTF_8);
    }

    private final void handleFirebaseUrl(JsonObject rootObject, Map<String, String> resValues) throws IOException {
        JsonObject jsonObject = rootObject.getAsJsonObject("project_info");
        if (jsonObject == null) {
            throw new GradleException("Missing project_info object");
        }
        JsonObject projectInfo = jsonObject;
        JsonPrimitive firebaseUrl = projectInfo.getAsJsonPrimitive("firebase_url");
        if (firebaseUrl != null) {
            resValues.put("firebase_database_url", firebaseUrl.getAsString());
        }
    }

    private final void handleProjectNumberAndProjectId(JsonObject rootObject, Map<String, String> resValues) throws IOException {
        JsonObject jsonObject = rootObject.getAsJsonObject("project_info");
        if (jsonObject == null) {
            throw new GradleException("Missing project_info object");
        }
        JsonObject projectInfo = jsonObject;
        JsonPrimitive jsonPrimitive = projectInfo.getAsJsonPrimitive("project_number");
        if (jsonPrimitive == null) {
            throw new GradleException("Missing project_info/project_number object");
        }
        JsonPrimitive projectNumber = jsonPrimitive;
        resValues.put("gcm_defaultSenderId", projectNumber.getAsString());
        JsonPrimitive jsonPrimitive2 = projectInfo.getAsJsonPrimitive("project_id");
        if (jsonPrimitive2 == null) {
            throw new GradleException("Missing project_info/project_id object");
        }
        JsonPrimitive projectId = jsonPrimitive2;
        resValues.put("project_id", projectId.getAsString());
        JsonPrimitive bucketName = projectInfo.getAsJsonPrimitive("storage_bucket");
        if (bucketName != null) {
            resValues.put("google_storage_bucket", bucketName.getAsString());
        }
    }

    private final JsonObject getClientForPackageName(JsonObject jsonObject) {
        JsonArray array = jsonObject.getAsJsonArray("client");
        if (array != null) {
            int count = array.size();
            for (int i = 0; i < count; ++i) {
                JsonPrimitive clientPackageName;
                JsonObject androidClientInfo;
                JsonObject clientInfo;
                JsonObject clientObject;
                JsonElement clientElement = array.get(i);
                if (clientElement == null || !clientElement.isJsonObject() || (clientObject = clientElement.getAsJsonObject()).getAsJsonObject("client_info") == null || clientInfo.getAsJsonObject("android_client_info") == null || androidClientInfo.getAsJsonPrimitive("package_name") == null || !Intrinsics.areEqual((Object)this.getApplicationId().get(), (Object)clientPackageName.getAsString())) continue;
                return clientObject;
            }
        }
        return null;
    }

    public final void handleGoogleAppId(@NotNull JsonObject $this$handleGoogleAppId, @NotNull Map<String, String> resValues) throws IOException {
        JsonPrimitive googleAppId;
        Intrinsics.checkNotNullParameter((Object)$this$handleGoogleAppId, (String)"<this>");
        Intrinsics.checkNotNullParameter(resValues, (String)"resValues");
        JsonObject jsonObject = $this$handleGoogleAppId.getAsJsonObject("client_info");
        if (jsonObject == null) {
            throw new GradleException("Client does not have client info");
        }
        JsonObject clientInfo = jsonObject;
        JsonPrimitive jsonPrimitive = googleAppId = clientInfo.getAsJsonPrimitive("mobilesdk_app_id");
        String googleAppIdStr = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
        CharSequence charSequence = googleAppIdStr;
        if (charSequence == null || charSequence.length() == 0) {
            throw new GradleException("Missing Google App Id. Please follow instructions on https://firebase.google.com/ to get a valid config file that contains a Google App Id");
        }
        resValues.put("google_app_id", googleAppIdStr);
        Object object = this.getGmpAppId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gmpAppId.get()");
        FilesKt.writeText((File)((File)object), (String)googleAppIdStr, (Charset)Charsets.UTF_8);
    }

    public final void handleWebClientId(@NotNull JsonObject $this$handleWebClientId, @NotNull Map<String, String> resValues) {
        Intrinsics.checkNotNullParameter((Object)$this$handleWebClientId, (String)"<this>");
        Intrinsics.checkNotNullParameter(resValues, (String)"resValues");
        JsonArray array = $this$handleWebClientId.getAsJsonArray("oauth_client");
        if (array != null) {
            int count = array.size();
            for (int i = 0; i < count; ++i) {
                JsonPrimitive clientType;
                String clientTypeStr;
                JsonObject oauthClientObject;
                JsonElement oauthClientElement = array.get(i);
                if (oauthClientElement == null || !oauthClientElement.isJsonObject() || (oauthClientObject = oauthClientElement.getAsJsonObject()).getAsJsonPrimitive("client_type") == null || !Intrinsics.areEqual((Object)OAUTH_CLIENT_TYPE_WEB, (Object)(clientTypeStr = clientType.getAsString()))) continue;
                JsonPrimitive jsonPrimitive = oauthClientObject.getAsJsonPrimitive("client_id");
                if (jsonPrimitive == null) continue;
                JsonPrimitive clientId = jsonPrimitive;
                resValues.put("default_web_client_id", clientId.getAsString());
                return;
            }
        }
    }

    private final void handleAnalytics(JsonObject $this$handleAnalytics, Map<String, String> resValues) throws IOException {
        JsonObject jsonObject = this.getServiceByName($this$handleAnalytics, "analytics_service");
        if (jsonObject == null) {
            return;
        }
        JsonObject analyticsService = jsonObject;
        JsonObject jsonObject2 = analyticsService.getAsJsonObject("analytics_property");
        if (jsonObject2 == null) {
            return;
        }
        JsonObject analyticsProp = jsonObject2;
        JsonPrimitive jsonPrimitive = analyticsProp.getAsJsonPrimitive("tracking_id");
        if (jsonPrimitive == null) {
            return;
        }
        JsonPrimitive trackingId = jsonPrimitive;
        resValues.put("ga_trackingId", trackingId.getAsString());
        File xml = new File(((Directory)this.getOutputDirectory().get()).getAsFile(), "xml");
        if (!FileInterceptorsDeclaration.intercept_exists((File)xml, (String)"com.google.gms.googleservices.GoogleServicesTask") && !xml.mkdirs()) {
            throw new GradleException("Failed to create folder: " + xml);
        }
        File file = new File(xml, "global_tracker.xml");
        String string = trackingId.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trackingId.asString");
        FilesKt.writeText((File)file, (String)GoogleServicesTask.Companion.getGlobalTrackerContent(string), (Charset)Charsets.UTF_8);
    }

    private final void handleMapsService(JsonObject $this$handleMapsService, Map<String, String> resValues) throws IOException {
        JsonObject jsonObject = this.getServiceByName($this$handleMapsService, "maps_service");
        if (jsonObject == null) {
            return;
        }
        JsonObject mapsService = jsonObject;
        String apiKey = this.getAndroidApiKey($this$handleMapsService);
        if (apiKey != null) {
            resValues.put("google_maps_key", apiKey);
            return;
        }
        throw new GradleException("Missing api_key/current_key object");
    }

    private final void handleGoogleApiKey(JsonObject $this$handleGoogleApiKey, Map<String, String> resValues) {
        String apiKey = this.getAndroidApiKey($this$handleGoogleApiKey);
        if (apiKey != null) {
            resValues.put("google_api_key", apiKey);
            resValues.put("google_crash_reporting_api_key", apiKey);
            return;
        }
        throw new GradleException("Missing api_key/current_key object");
    }

    private final String getAndroidApiKey(JsonObject $this$getAndroidApiKey) {
        JsonArray array = $this$getAndroidApiKey.getAsJsonArray("api_key");
        if (array != null) {
            int count = array.size();
            for (int i = 0; i < count; ++i) {
                JsonElement apiKeyElement = array.get(i);
                if (apiKeyElement == null || !apiKeyElement.isJsonObject()) continue;
                JsonObject apiKeyObject = apiKeyElement.getAsJsonObject();
                JsonPrimitive jsonPrimitive = apiKeyObject.getAsJsonPrimitive("current_key");
                if (jsonPrimitive == null) continue;
                JsonPrimitive currentKey = jsonPrimitive;
                return currentKey.getAsString();
            }
        }
        return null;
    }

    private final JsonObject getServiceByName(JsonObject $this$getServiceByName, String serviceName) {
        JsonObject jsonObject = $this$getServiceByName.getAsJsonObject("services");
        if (jsonObject == null) {
            return null;
        }
        JsonObject services = jsonObject;
        JsonObject jsonObject2 = services.getAsJsonObject(serviceName);
        if (jsonObject2 == null) {
            return null;
        }
        JsonObject service = jsonObject2;
        JsonPrimitive jsonPrimitive = service.getAsJsonPrimitive("status");
        if (jsonPrimitive == null) {
            return null;
        }
        JsonPrimitive status = jsonPrimitive;
        String statusStr = status.getAsString();
        if (Intrinsics.areEqual((Object)STATUS_DISABLED, (Object)statusStr)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)STATUS_ENABLED, (Object)statusStr)) {
            Logger logger = this.getLogger();
            String string = "Status with value '%1$s' for service '%2$s' is unknown";
            Object[] objectArray = new Object[]{statusStr, serviceName};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            logger.warn(string2);
            return null;
        }
        return service;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u001e\u0010\n\u001a\u00020\u00042\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/gms/googleservices/GoogleServicesTask$Companion;", "", "()V", "JSON_FILE_NAME", "", "OAUTH_CLIENT_TYPE_WEB", "STATUS_DISABLED", "STATUS_ENABLED", "getGlobalTrackerContent", "ga_trackingId", "getValuesContent", "values", "", "google-services-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final String getGlobalTrackerContent(String ga_trackingId) {
            return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <string name=\"ga_trackingId\" translatable=\"false\">" + ga_trackingId + "</string>\n</resources>\n";
        }

        private final String getValuesContent(Map<String, String> values) {
            StringBuilder sb = new StringBuilder(256);
            sb.append(StringsKt.trimIndent((String)"\n                    <?xml version=\"1.0\" encoding=\"utf-8\"?>\n                    <resources>\n                    \n                "));
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                sb.append("    <string name=\"").append(name).append("\" translatable=\"false\"");
                sb.append(">").append(value).append("</string>\n");
            }
            sb.append("</resources>\n");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GoogleServicesPlugin.MissingGoogleServicesStrategy.values().length];
            try {
                nArray[GoogleServicesPlugin.MissingGoogleServicesStrategy.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoogleServicesPlugin.MissingGoogleServicesStrategy.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoogleServicesPlugin.MissingGoogleServicesStrategy.IGNORE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

