/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.bytestorage;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class TemporaryFile
implements Closeable {
    private boolean deleted = false;
    private final File file;

    public TemporaryFile(File file) {
        this.file = file;
    }

    public File getFile() {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"File already deleted");
        return this.file;
    }

    @Override
    public void close() throws IOException {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        this.deleteFile(this.file);
    }

    private void deleteFile(File file) throws IOException {
        File[] contents;
        if (FileInterceptorsDeclaration.intercept_isDirectory((File)file, (String)"com.android.tools.build.apkzlib.bytestorage.TemporaryFile") && (contents = FileInterceptorsDeclaration.intercept_listFiles((File)file, (String)"com.android.tools.build.apkzlib.bytestorage.TemporaryFile")) != null) {
            for (File subFile : contents) {
                this.deleteFile(subFile);
            }
        }
        if (FileInterceptorsDeclaration.intercept_exists((File)file, (String)"com.android.tools.build.apkzlib.bytestorage.TemporaryFile") && !file.delete()) {
            throw new IOException("Failed to delete '" + file.getAbsolutePath() + "'");
        }
    }
}

