/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zip;

import com.android.tools.build.apkzlib.zip.AlignmentRule;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public final class AlignmentRules {
    private AlignmentRules() {
    }

    public static AlignmentRule constant(int alignment) {
        Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0, (Object)"alignment <= 0");
        return (AlignmentRule & Serializable)path -> alignment;
    }

    public static AlignmentRule constantForSuffix(String suffix, int alignment) {
        Preconditions.checkArgument((!suffix.isEmpty() ? 1 : 0) != 0, (Object)"suffix.isEmpty()");
        Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0, (Object)"alignment <= 0");
        return (AlignmentRule & Serializable)path -> path.endsWith(suffix) ? alignment : 1;
    }

    public static AlignmentRule compose(AlignmentRule ... rules) {
        return (AlignmentRule & Serializable)path -> {
            for (AlignmentRule r : rules) {
                int align = r.alignment(path);
                if (align == 1) continue;
                return align;
            }
            return 1;
        };
    }
}

