/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.component.impl;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.AndroidResources;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.component.NestedComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.component.features.BuildConfigCreationConfig;
import com.android.build.gradle.internal.component.legacy.OldVariantApiLegacySupport;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.IssueReporter;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Strings;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a*\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0000\u001a/\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u0002H\u0019H\u0000\u00a2\u0006\u0002\u0010\u001d\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001e"}, d2={"ENABLE_LEGACY_API", "", "getENABLE_LEGACY_API", "()Ljava/lang/String;", "getCompiledManifest", "Lorg/gradle/api/file/FileCollection;", "component", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "getJavaClasspath", "configType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ConsumedConfigType;", "classesType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "generatedBytecodeKey", "", "getAndroidResources", "Lcom/android/build/api/variant/AndroidResources;", "Lcom/android/build/api/component/impl/ComponentImpl;", "getMainTargetSdkVersion", "Lcom/android/build/api/variant/AndroidVersion;", "Lcom/android/build/gradle/internal/component/NestedComponentCreationConfig;", "isTestApk", "", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "warnAboutAccessingVariantApiValueForDisabledFeature", "T", "featureName", "apiName", "value", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "gradle-core"})
@JvmName(name="ComponentUtils")
@SourceDebugExtension(value={"SMAP\nComponentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentUtils.kt\ncom/android/build/api/component/impl/ComponentUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,146:1\n37#2,2:147\n*S KotlinDebug\n*F\n+ 1 ComponentUtils.kt\ncom/android/build/api/component/impl/ComponentUtils\n*L\n128#1:147,2\n*E\n"})
public final class ComponentUtils {
    @NotNull
    private static final String ENABLE_LEGACY_API = "Turn on with by putting '" + BooleanOption.ENABLE_LEGACY_API.getPropertyName() + "=true in gradle.properties'\nUsing this deprecated API may still fail, depending on usage of the new Variant API, like computing applicationId via a task output.";

    @NotNull
    public static final String getENABLE_LEGACY_API() {
        return ENABLE_LEGACY_API;
    }

    @NotNull
    public static final AndroidResources getAndroidResources(@NotNull ComponentImpl<?> $this$getAndroidResources) {
        Intrinsics.checkNotNullParameter($this$getAndroidResources, (String)"<this>");
        AndroidResourcesCreationConfig androidResourcesCreationConfig2 = $this$getAndroidResources.getAndroidResourcesCreationConfig();
        if (androidResourcesCreationConfig2 == null || (androidResourcesCreationConfig2 = androidResourcesCreationConfig2.getAndroidResources()) == null) {
            androidResourcesCreationConfig2 = $this$getAndroidResources.getAssetsCreationConfig().getAndroidResources();
        }
        return androidResourcesCreationConfig2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTestApk(@NotNull ApkCreationConfig $this$isTestApk) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestApk, (String)"<this>");
        ProjectOptions projectOptions = $this$isTestApk.getServices().getProjectOptions();
        Boolean bl = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (bl == null) {
            boolean bl2;
            if (!Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI))) return true;
            if ($this$isTestApk.getGlobal().getTargetDeployApiFromIDE() != null) return true;
            AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)$this$isTestApk.getGlobal().getCompileSdkHashString());
            if (androidVersion != null) {
                if (androidVersion.isPreview()) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ($this$isTestApk.getMinSdk().getCodename() != null) return true;
            if ($this$isTestApk.getTargetSdk().getCodename() == null) return false;
            return true;
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final <T> T warnAboutAccessingVariantApiValueForDisabledFeature(@NotNull ComponentCreationConfig $this$warnAboutAccessingVariantApiValueForDisabledFeature, @NotNull String featureName2, @NotNull String apiName, T value) {
        Intrinsics.checkNotNullParameter((Object)$this$warnAboutAccessingVariantApiValueForDisabledFeature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)featureName2, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
        IssueReporter.reportWarning$default((IssueReporter)$this$warnAboutAccessingVariantApiValueForDisabledFeature.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.ACCESSING_DISABLED_FEATURE_VARIANT_API, (String)("Accessing value " + apiName + " in variant " + $this$warnAboutAccessingVariantApiValueForDisabledFeature.getName() + " has no effect as the feature " + featureName2 + " is disabled."), null, null, (int)12, null);
        return value;
    }

    @NotNull
    public static final com.android.build.api.variant.AndroidVersion getMainTargetSdkVersion(@NotNull NestedComponentCreationConfig $this$getMainTargetSdkVersion) {
        com.android.build.api.variant.AndroidVersion androidVersion;
        Intrinsics.checkNotNullParameter((Object)$this$getMainTargetSdkVersion, (String)"<this>");
        VariantCreationConfig variantCreationConfig = $this$getMainTargetSdkVersion.getMainVariant();
        if (variantCreationConfig instanceof ApkCreationConfig) {
            VariantCreationConfig variantCreationConfig2 = $this$getMainTargetSdkVersion.getMainVariant();
            Intrinsics.checkNotNull((Object)variantCreationConfig2, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.component.ApkCreationConfig");
            androidVersion = ((ApkCreationConfig)((Object)variantCreationConfig2)).getTargetSdk();
        } else if (variantCreationConfig instanceof LibraryCreationConfig) {
            VariantCreationConfig variantCreationConfig3 = $this$getMainTargetSdkVersion.getMainVariant();
            Intrinsics.checkNotNull((Object)variantCreationConfig3, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.component.LibraryCreationConfig");
            androidVersion = ((LibraryCreationConfig)variantCreationConfig3).getTargetSdk();
        } else {
            androidVersion = $this$getMainTargetSdkVersion.getMinSdk();
        }
        return androidVersion;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileCollection getJavaClasspath(@NotNull ComponentCreationConfig component2, @NotNull AndroidArtifacts.ConsumedConfigType configType, @NotNull AndroidArtifacts.ArtifactType classesType, @Nullable Object generatedBytecodeKey) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter((Object)((Object)classesType), (String)"classesType");
        FileCollection mainCollection = null;
        mainCollection = VariantDependencies.getArtifactFileCollection$default(component2.getVariantDependencies(), configType, AndroidArtifacts.ArtifactScope.ALL, classesType, null, 8, null);
        OldVariantApiLegacySupport oldVariantApiLegacySupport2 = component2.getOldVariantApiLegacySupport();
        if (oldVariantApiLegacySupport2 != null) {
            OldVariantApiLegacySupport it = oldVariantApiLegacySupport2;
            boolean bl = false;
            FileCollection fileCollection2 = mainCollection.plus(it.getVariantData().getGeneratedBytecode(generatedBytecodeKey));
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"mainCollection.plus(\n   \u2026tedBytecodeKey)\n        )");
            mainCollection = fileCollection2;
        }
        Object object = new FileCollection[4];
        AndroidResourcesCreationConfig androidResourcesCreationConfig2 = component2.getAndroidResourcesCreationConfig();
        object[0] = androidResourcesCreationConfig2 != null ? androidResourcesCreationConfig2.getCompiledRClasses(configType) : null;
        BuildConfigCreationConfig buildConfigCreationConfig2 = component2.getBuildConfigCreationConfig();
        object[1] = buildConfigCreationConfig2 != null ? buildConfigCreationConfig2.getCompiledBuildConfig() : null;
        object[2] = ComponentUtils.getCompiledManifest(component2);
        object[3] = mainCollection;
        object = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        FileCollection[] fileCollectionArray = thisCollection$iv.toArray(new FileCollection[0]);
        mainCollection = component2.getServices().fileCollection(Arrays.copyOf(fileCollectionArray, fileCollectionArray.length));
        return mainCollection;
    }

    private static final FileCollection getCompiledManifest(ComponentCreationConfig component2) {
        FileCollection fileCollection2;
        boolean manifestClassRequired = component2.getComponentType().getRequiresManifest() && component2.getServices().getProjectOptions().get(BooleanOption.GENERATE_MANIFEST_CLASS);
        boolean isTest = component2.getComponentType().isForTesting();
        boolean isAar = component2.getComponentType().isAar();
        if (manifestClassRequired && !isAar && !isTest) {
            Object[] objectArray = new Object[]{component2.getArtifacts().get(InternalArtifactType.COMPILE_MANIFEST_JAR.INSTANCE)};
            fileCollection2 = (FileCollection)component2.getServices().fileCollection(objectArray);
        } else {
            fileCollection2 = (FileCollection)component2.getServices().fileCollection();
        }
        return fileCollection2;
    }
}

