/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.cxx.configure.CmakeLocator;
import com.android.build.gradle.internal.cxx.configure.NinjaLocator;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.utils.cxx.os.OsBehaviorKt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b&\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u001e\u001f !\"B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eH\u0002R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\n \b*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$ServiceParameters;", "exec", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/process/ExecOperations;)V", "androidLocationProvider", "Lcom/android/build/gradle/internal/services/AndroidLocationsBuildService;", "kotlin.jvm.PlatformType", "getAndroidLocationProvider", "()Lcom/android/build/gradle/internal/services/AndroidLocationsBuildService;", "cmakeLocations", "", "Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$CMakeLocatorParameters;", "Ljava/io/File;", "ninjaLocations", "Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$NinjaLocatorParameters;", "sdkComponents", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkComponents", "()Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "toolVersions", "", "locateCMake", "cmakeVersionFromDsl", "localPropertiesCMakeDir", "locateNinja", "cmakeBinFolder", "versionOf", "tool", "CMakeLocatorParameters", "Companion", "NinjaLocatorParameters", "RegistrationAction", "ServiceParameters", "gradle-core"})
public abstract class NativeLocationsBuildService
implements BuildService<ServiceParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations exec;
    @NotNull
    private final Map<CMakeLocatorParameters, File> cmakeLocations;
    @NotNull
    private final Map<NinjaLocatorParameters, File> ninjaLocations;
    @NotNull
    private final Map<File, String> toolVersions;

    @Inject
    public NativeLocationsBuildService(@NotNull ExecOperations exec) {
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        this.exec = exec;
        this.cmakeLocations = new LinkedHashMap();
        this.ninjaLocations = new LinkedHashMap();
        this.toolVersions = new LinkedHashMap();
    }

    private final AndroidLocationsBuildService getAndroidLocationProvider() {
        return (AndroidLocationsBuildService)((ServiceParameters)this.getParameters()).getAndroidLocationsService().get();
    }

    private final SdkComponentsBuildService getSdkComponents() {
        return (SdkComponentsBuildService)((ServiceParameters)this.getParameters()).getSdkService().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final File locateCMake(@Nullable String cmakeVersionFromDsl, @Nullable File localPropertiesCMakeDir) {
        ThreadLoggingEnvironment.Companion.requireExplicitLogger();
        Map<CMakeLocatorParameters, File> map = this.cmakeLocations;
        synchronized (map) {
            File location2;
            CMakeLocatorParameters locatorKey;
            block5: {
                boolean bl = false;
                locatorKey = new CMakeLocatorParameters(cmakeVersionFromDsl, localPropertiesCMakeDir);
                if (!this.cmakeLocations.containsKey(locatorKey)) break block5;
                File file = this.cmakeLocations.get(locatorKey);
                return file;
            }
            CmakeLocator cmakeLocator = new CmakeLocator();
            AndroidLocationsBuildService androidLocationsBuildService = this.getAndroidLocationProvider();
            Intrinsics.checkNotNullExpressionValue((Object)androidLocationsBuildService, (String)"androidLocationProvider");
            File file = cmakeLocator.findCmakePath(cmakeVersionFromDsl, localPropertiesCMakeDir, androidLocationsBuildService, ((Directory)this.getSdkComponents().getSdkDirectoryProvider().get()).getAsFile(), (Function1<? super File, String>)((Function1)new Function1<File, String>((Object)this){

                @NotNull
                public final String invoke(@NotNull File p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return NativeLocationsBuildService.access$versionOf((NativeLocationsBuildService)this.receiver, p0);
                }
            }), new Consumer(this){
                final /* synthetic */ NativeLocationsBuildService this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(@NotNull String version) {
                    Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                    NativeLocationsBuildService.access$getSdkComponents(this.this$0).installCmake(version);
                }
            });
            File file2 = location2 = file != null ? FilesKt.resolve((File)file, (String)("bin/cmake" + OsBehaviorKt.getExe())) : null;
            if (location2 != null) {
                this.cmakeLocations.put(locatorKey, location2);
            }
            File file3 = location2;
            return file3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final File locateNinja(@Nullable File cmakeBinFolder) {
        ThreadLoggingEnvironment.Companion.requireExplicitLogger();
        Map<NinjaLocatorParameters, File> map = this.ninjaLocations;
        synchronized (map) {
            boolean bl = false;
            File file = this.ninjaLocations.computeIfAbsent(new NinjaLocatorParameters(cmakeBinFolder), new Function(cmakeBinFolder, this){
                final /* synthetic */ File $cmakeBinFolder;
                final /* synthetic */ NativeLocationsBuildService this$0;
                {
                    this.$cmakeBinFolder = $cmakeBinFolder;
                    this.this$0 = $receiver;
                }

                @Nullable
                public final File apply(@NotNull NinjaLocatorParameters it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new NinjaLocator().findNinjaPath(this.$cmakeBinFolder, ((Directory)NativeLocationsBuildService.access$getSdkComponents(this.this$0).getSdkDirectoryProvider().get()).getAsFile());
                }
            });
            return file;
        }
    }

    private final String versionOf(File tool) {
        String string = this.toolVersions.computeIfAbsent(tool, new Function(this, tool){
            final /* synthetic */ NativeLocationsBuildService this$0;
            final /* synthetic */ File $tool;
            {
                this.this$0 = $receiver;
                this.$tool = $tool;
            }

            @NotNull
            public final String apply(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                NativeLocationsBuildService.access$getExec$p(this.this$0).exec(new Action(this.$tool, stdout){
                    final /* synthetic */ File $tool;
                    final /* synthetic */ ByteArrayOutputStream $stdout;
                    {
                        this.$tool = $tool;
                        this.$stdout = $stdout;
                    }

                    public final void execute(ExecSpec spec) {
                        Object[] objectArray = new Object[]{String.valueOf(this.$tool), "--version"};
                        spec.commandLine(objectArray);
                        spec.setStandardOutput((OutputStream)this.$stdout);
                    }
                });
                return String.valueOf(stdout);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"private fun versionOf(to\u2026\"$stdout\"\n        }\n    }");
        return string;
    }

    public static final /* synthetic */ ExecOperations access$getExec$p(NativeLocationsBuildService $this) {
        return $this.exec;
    }

    public static final /* synthetic */ String access$versionOf(NativeLocationsBuildService $this, File tool) {
        return $this.versionOf(tool);
    }

    public static final /* synthetic */ SdkComponentsBuildService access$getSdkComponents(NativeLocationsBuildService $this) {
        return $this.getSdkComponents();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$CMakeLocatorParameters;", "", "cmakeVersionFromDsl", "", "localPropertiesCMakeDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "getCmakeVersionFromDsl", "()Ljava/lang/String;", "getLocalPropertiesCMakeDir", "()Ljava/io/File;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-core"})
    private static final class CMakeLocatorParameters {
        @Nullable
        private final String cmakeVersionFromDsl;
        @Nullable
        private final File localPropertiesCMakeDir;

        public CMakeLocatorParameters(@Nullable String cmakeVersionFromDsl, @Nullable File localPropertiesCMakeDir) {
            this.cmakeVersionFromDsl = cmakeVersionFromDsl;
            this.localPropertiesCMakeDir = localPropertiesCMakeDir;
        }

        @Nullable
        public final String getCmakeVersionFromDsl() {
            return this.cmakeVersionFromDsl;
        }

        @Nullable
        public final File getLocalPropertiesCMakeDir() {
            return this.localPropertiesCMakeDir;
        }

        @Nullable
        public final String component1() {
            return this.cmakeVersionFromDsl;
        }

        @Nullable
        public final File component2() {
            return this.localPropertiesCMakeDir;
        }

        @NotNull
        public final CMakeLocatorParameters copy(@Nullable String cmakeVersionFromDsl, @Nullable File localPropertiesCMakeDir) {
            return new CMakeLocatorParameters(cmakeVersionFromDsl, localPropertiesCMakeDir);
        }

        public static /* synthetic */ CMakeLocatorParameters copy$default(CMakeLocatorParameters cMakeLocatorParameters, String string, File file, int n, Object object) {
            if ((n & 1) != 0) {
                string = cMakeLocatorParameters.cmakeVersionFromDsl;
            }
            if ((n & 2) != 0) {
                file = cMakeLocatorParameters.localPropertiesCMakeDir;
            }
            return cMakeLocatorParameters.copy(string, file);
        }

        @NotNull
        public String toString() {
            return "CMakeLocatorParameters(cmakeVersionFromDsl=" + this.cmakeVersionFromDsl + ", localPropertiesCMakeDir=" + this.localPropertiesCMakeDir + ")";
        }

        public int hashCode() {
            int result2 = this.cmakeVersionFromDsl == null ? 0 : this.cmakeVersionFromDsl.hashCode();
            result2 = result2 * 31 + (this.localPropertiesCMakeDir == null ? 0 : this.localPropertiesCMakeDir.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CMakeLocatorParameters)) {
                return false;
            }
            CMakeLocatorParameters cMakeLocatorParameters = (CMakeLocatorParameters)other;
            if (!Intrinsics.areEqual((Object)this.cmakeVersionFromDsl, (Object)cMakeLocatorParameters.cmakeVersionFromDsl)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.localPropertiesCMakeDir, (Object)cMakeLocatorParameters.localPropertiesCMakeDir);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$Companion;", "", "()V", "register", "", "project", "Lorg/gradle/api/Project;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void register(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            new RegistrationAction(project).execute().get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$NinjaLocatorParameters;", "", "cmakeBinFolder", "Ljava/io/File;", "(Ljava/io/File;)V", "getCmakeBinFolder", "()Ljava/io/File;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
    private static final class NinjaLocatorParameters {
        @Nullable
        private final File cmakeBinFolder;

        public NinjaLocatorParameters(@Nullable File cmakeBinFolder) {
            this.cmakeBinFolder = cmakeBinFolder;
        }

        @Nullable
        public final File getCmakeBinFolder() {
            return this.cmakeBinFolder;
        }

        @Nullable
        public final File component1() {
            return this.cmakeBinFolder;
        }

        @NotNull
        public final NinjaLocatorParameters copy(@Nullable File cmakeBinFolder) {
            return new NinjaLocatorParameters(cmakeBinFolder);
        }

        public static /* synthetic */ NinjaLocatorParameters copy$default(NinjaLocatorParameters ninjaLocatorParameters, File file, int n, Object object) {
            if ((n & 1) != 0) {
                file = ninjaLocatorParameters.cmakeBinFolder;
            }
            return ninjaLocatorParameters.copy(file);
        }

        @NotNull
        public String toString() {
            return "NinjaLocatorParameters(cmakeBinFolder=" + this.cmakeBinFolder + ")";
        }

        public int hashCode() {
            return this.cmakeBinFolder == null ? 0 : this.cmakeBinFolder.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NinjaLocatorParameters)) {
                return false;
            }
            NinjaLocatorParameters ninjaLocatorParameters = (NinjaLocatorParameters)other;
            return Intrinsics.areEqual((Object)this.cmakeBinFolder, (Object)ninjaLocatorParameters.cmakeBinFolder);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService;", "Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$ServiceParameters;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nNativeLocationsBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeLocationsBuildService.kt\ncom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$RegistrationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,213:1\n67#2:214\n67#2:215\n*S KotlinDebug\n*F\n+ 1 NativeLocationsBuildService.kt\ncom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$RegistrationAction\n*L\n132#1:214\n133#1:215\n*E\n"})
    private static final class RegistrationAction
    extends ServiceRegistrationAction<NativeLocationsBuildService, ServiceParameters> {
        public RegistrationAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, NativeLocationsBuildService.class, null, null, 12, null);
        }

        @Override
        public void configure(@NotNull ServiceParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Property<SdkComponentsBuildService> property = parameters.getSdkService();
            BuildServiceRegistry buildServiceRegistry = this.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
            BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
            boolean $i$f$getBuildService = false;
            property.set(BuildServicesKt.getBuildService(buildServiceRegistry$iv, SdkComponentsBuildService.class));
            Property<AndroidLocationsBuildService> property2 = parameters.getAndroidLocationsService();
            BuildServiceRegistry buildServiceRegistry2 = this.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry2, (String)"project.gradle.sharedServices");
            buildServiceRegistry$iv = buildServiceRegistry2;
            $i$f$getBuildService = false;
            property2.set(BuildServicesKt.getBuildService(buildServiceRegistry$iv, AndroidLocationsBuildService.class));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NativeLocationsBuildService$ServiceParameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "androidLocationsService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/AndroidLocationsBuildService;", "getAndroidLocationsService", "()Lorg/gradle/api/provider/Property;", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "gradle-core"})
    public static interface ServiceParameters
    extends BuildServiceParameters {
        @NotNull
        public Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public Property<AndroidLocationsBuildService> getAndroidLocationsService();
    }
}

