/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.level2;

import com.android.builder.model.level2.Library;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public final class AndroidLibraryImpl
implements Library,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String address;
    private final File artifact;
    private final File folder;
    private final List<String> localJarPaths;

    public AndroidLibraryImpl(String address, File artifact, File folder2, File resStaticLibrary, List<String> localJarPaths) {
        this.address = address;
        this.artifact = artifact;
        this.folder = folder2;
        this.localJarPaths = ImmutableList.copyOf(localJarPaths);
    }

    public int getType() {
        return 1;
    }

    public String getArtifactAddress() {
        return this.address;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public File getFolder() {
        return this.folder;
    }

    public String getManifest() {
        return "AndroidManifest.xml";
    }

    public String getJarFile() {
        return "jars" + File.separatorChar + "classes.jar";
    }

    public String getCompileJarFile() {
        return FileInterceptorsDeclaration.intercept_exists((File)FileUtils.join((File)this.folder, (String[])new String[]{"api.jar"}), (String)"com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl") ? "api.jar" : this.getJarFile();
    }

    public String getResFolder() {
        return "res";
    }

    public File getResStaticLibrary() {
        File file = FileUtils.join((File)this.folder, (String[])new String[]{"res.apk"});
        return FileInterceptorsDeclaration.intercept_isFile((File)file, (String)"com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl") ? file : null;
    }

    public String getAssetsFolder() {
        return "assets";
    }

    public Collection<String> getLocalJars() {
        return this.localJarPaths;
    }

    public String getJniFolder() {
        return "jni";
    }

    public String getAidlFolder() {
        return "aidl";
    }

    public String getRenderscriptFolder() {
        return "rs";
    }

    public String getProguardRules() {
        return "proguard.txt";
    }

    public String getLintJar() {
        return "jars" + File.separatorChar + "lint.jar";
    }

    public String getExternalAnnotations() {
        return "jars" + File.separatorChar + "annotations.zip";
    }

    public String getPublicResources() {
        return "public.txt";
    }

    public String getSymbolFile() {
        return "R.txt";
    }

    public String getVariant() {
        throw new UnsupportedOperationException("getVariant() cannot be called when getType() returns ANDROID_LIBRARY");
    }

    public String getBuildId() {
        throw new UnsupportedOperationException("getBuildId() cannot be called when getType() returns ANDROID_LIBRARY");
    }

    public String getProjectPath() {
        throw new UnsupportedOperationException("getProjectPath() cannot be called when getType() returns ANDROID_LIBRARY");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidLibraryImpl that = (AndroidLibraryImpl)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.artifact, that.artifact) && Objects.equals(this.folder, that.folder) && Objects.equals(this.localJarPaths, that.localJarPaths);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.artifact, this.folder, this.localJarPaths);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("artifact", (Object)this.artifact).add("folder", (Object)this.folder).add("localJarPath", this.localJarPaths).toString();
    }
}

