/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.apksig.util.RunnablesExecutor;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigVersions;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Predicate;

public class IncrementalPackagerBuilder {
    private ApkCreatorFactory.CreationData.Builder creationDataBuilder = ApkCreatorFactory.CreationData.builder();
    private NativeLibrariesPackagingMode nativeLibrariesPackagingMode;
    private Predicate<String> noCompressPredicate;
    private File intermediateDir;
    private boolean debuggableBuild;
    private boolean deterministicEntryOrder = true;
    private boolean enableV3Signing = false;
    private boolean enableV4Signing = false;
    private boolean jniDebuggableBuild;
    private Set<String> abiFilters;
    private BuildType buildType;
    private Map<RelativeFile, FileStatus> changedDexFiles = new HashMap<RelativeFile, FileStatus>();
    private Map<RelativeFile, FileStatus> changedJavaResources = new HashMap<RelativeFile, FileStatus>();
    private List<SerializableChange> changedAssets = new ArrayList<SerializableChange>();
    private Map<RelativeFile, FileStatus> changedAndroidResources = new HashMap<RelativeFile, FileStatus>();
    private Map<RelativeFile, FileStatus> changedNativeLibs = new HashMap<RelativeFile, FileStatus>();
    private List<SerializableChange> changedAppMetadata = new ArrayList<SerializableChange>();
    private List<SerializableChange> changedArtProfile = new ArrayList<SerializableChange>();
    private List<SerializableChange> changedArtProfileMetadata = new ArrayList<SerializableChange>();
    private List<SerializableChange> changedVersionControlInfo = new ArrayList<SerializableChange>();

    public IncrementalPackagerBuilder(BuildType buildType) {
        this.abiFilters = new HashSet<String>();
        this.buildType = buildType;
        this.creationDataBuilder.setIncremental(buildType == BuildType.INCREMENTAL);
    }

    public IncrementalPackagerBuilder withSigning(SigningConfigData signingConfig2, SigningConfigVersions signingConfigVersions, int minSdk2, byte[] sdkDependencyData) {
        if (signingConfig2 == null) {
            return this;
        }
        try {
            String error = "SigningConfig \"" + signingConfig2.getName() + "\" is missing required property \"%s\".";
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig2.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig2.getStoreFile(), (String)error, (Object)"storeFile")), (String)((String)Preconditions.checkNotNull((Object)signingConfig2.getStorePassword(), (String)error, (Object)"storePassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig2.getKeyPassword(), (String)error, (Object)"keyPassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig2.getKeyAlias(), (String)error, (Object)"keyAlias")));
            boolean enableV1Signing2 = signingConfigVersions.getEnableV1Signing();
            boolean enableV2Signing2 = signingConfigVersions.getEnableV2Signing();
            this.enableV3Signing = signingConfigVersions.getEnableV3Signing();
            this.enableV4Signing = signingConfigVersions.getEnableV4Signing();
            if (this.enableV4Signing) {
                Preconditions.checkState((enableV2Signing2 || this.enableV3Signing ? 1 : 0) != 0, (Object)"V4 signing enabled, but v2 and v3 signing are not enabled. V4 signing requires either v2 or v3 signing.");
            }
            this.creationDataBuilder.setSigningOptions(SigningOptions.builder().setKey(certificateInfo.getKey()).setCertificates(new X509Certificate[]{certificateInfo.getCertificate()}).setV1SigningEnabled(enableV1Signing2).setV2SigningEnabled(enableV2Signing2).setMinSdkVersion(minSdk2).setValidation(this.computeValidation()).setSdkDependencyData(sdkDependencyData).setExecutor((RunnablesExecutor & Serializable)provider2 -> {
                ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
                try {
                    int jobCount = forkJoinPool.getParallelism();
                    ArrayList<Future> jobs = new ArrayList<Future>(jobCount);
                    for (int i = 0; i < jobCount; ++i) {
                        jobs.add(forkJoinPool.submit(provider2.createRunnable()));
                    }
                    for (Future future : jobs) {
                        future.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }).build());
        }
        catch (KeytoolException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private SigningOptions.Validation computeValidation() {
        switch (this.buildType) {
            case INCREMENTAL: {
                return SigningOptions.Validation.ASSUME_VALID;
            }
            case CLEAN: {
                return SigningOptions.Validation.ASSUME_INVALID;
            }
            case UNKNOWN: {
                return SigningOptions.Validation.ALWAYS_VALIDATE;
            }
        }
        throw new RuntimeException("Unknown IncrementalPackagerBuilder build type " + this.buildType);
    }

    public IncrementalPackagerBuilder withOutputFile(File f) {
        this.creationDataBuilder.setApkPath(f);
        return this;
    }

    public IncrementalPackagerBuilder withNativeLibraryPackagingMode(NativeLibrariesPackagingMode packagingMode) {
        this.nativeLibrariesPackagingMode = packagingMode;
        return this;
    }

    public IncrementalPackagerBuilder withNoCompressPredicate(Predicate<String> noCompressPredicate) {
        this.noCompressPredicate = noCompressPredicate;
        return this;
    }

    public IncrementalPackagerBuilder withIntermediateDir(File intermediateDir) {
        this.intermediateDir = intermediateDir;
        return this;
    }

    public IncrementalPackagerBuilder withCreatedBy(String createdBy) {
        this.creationDataBuilder.setCreatedBy(createdBy);
        return this;
    }

    public IncrementalPackagerBuilder withDebuggableBuild(boolean debuggableBuild) {
        this.debuggableBuild = debuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withDeterministicEntryOrder(boolean deterministicEntryOrder) {
        this.deterministicEntryOrder = deterministicEntryOrder;
        return this;
    }

    public IncrementalPackagerBuilder withJniDebuggableBuild(boolean jniDebuggableBuild) {
        this.jniDebuggableBuild = jniDebuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withAcceptedAbis(Set<String> acceptedAbis) {
        this.abiFilters = ImmutableSet.copyOf(acceptedAbis);
        return this;
    }

    public IncrementalPackagerBuilder withChangedDexFiles(Map<RelativeFile, FileStatus> changedDexFiles) {
        this.changedDexFiles = ImmutableMap.copyOf(changedDexFiles);
        return this;
    }

    public IncrementalPackagerBuilder withChangedJavaResources(Map<RelativeFile, FileStatus> changedJavaResources) {
        this.changedJavaResources = ImmutableMap.copyOf(changedJavaResources);
        return this;
    }

    public IncrementalPackagerBuilder withChangedAssets(Collection<SerializableChange> changedAssets) {
        this.changedAssets = ImmutableList.copyOf(changedAssets);
        return this;
    }

    public IncrementalPackagerBuilder withChangedAndroidResources(Map<RelativeFile, FileStatus> changedAndroidResources) {
        this.changedAndroidResources = ImmutableMap.copyOf(changedAndroidResources);
        return this;
    }

    public IncrementalPackagerBuilder withChangedNativeLibs(Map<RelativeFile, FileStatus> changedNativeLibs) {
        this.changedNativeLibs = ImmutableMap.copyOf(changedNativeLibs);
        return this;
    }

    public IncrementalPackagerBuilder withChangedAppMetadata(Collection<SerializableChange> changedAppMetadata) {
        this.changedAppMetadata = ImmutableList.copyOf(changedAppMetadata);
        return this;
    }

    public IncrementalPackagerBuilder withChangedArtProfile(Collection<SerializableChange> changedMergedProfile) {
        this.changedArtProfile = ImmutableList.copyOf(changedMergedProfile);
        return this;
    }

    public IncrementalPackagerBuilder withChangedArtProfileMetadata(Collection<SerializableChange> changedArtProfileMetadata) {
        this.changedArtProfileMetadata = ImmutableList.copyOf(changedArtProfileMetadata);
        return this;
    }

    public IncrementalPackagerBuilder withChangedVersionControlInfo(Collection<SerializableChange> changedVersionControlInfo) {
        this.changedVersionControlInfo = ImmutableList.copyOf(changedVersionControlInfo);
        return this;
    }

    public IncrementalPackager build() {
        Preconditions.checkState((this.intermediateDir != null ? 1 : 0) != 0, (Object)"intermediateDir == null");
        Preconditions.checkNotNull((Object)this.nativeLibrariesPackagingMode);
        Preconditions.checkNotNull(this.noCompressPredicate);
        this.creationDataBuilder.setNativeLibrariesPackagingMode(this.nativeLibrariesPackagingMode).setNoCompressPredicate(this.noCompressPredicate::test);
        try {
            return new IncrementalPackager(this.creationDataBuilder.build(), this.intermediateDir, ApkCreatorFactories.fromProjectProperties(this.debuggableBuild), this.abiFilters, this.jniDebuggableBuild, this.debuggableBuild, this.deterministicEntryOrder, this.enableV3Signing, this.enableV4Signing, this.changedDexFiles, this.changedJavaResources, this.changedAssets, this.changedAndroidResources, this.changedNativeLibs, this.changedAppMetadata, this.changedArtProfile, this.changedArtProfileMetadata, this.changedVersionControlInfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum BuildType {
        UNKNOWN,
        CLEAN,
        INCREMENTAL;

    }
}

