/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.zipflinger.ZipArchive;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u001a*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\r"}, d2={"extractApkFilesBypassingBundleTool", "", "Ljava/nio/file/Path;", "apkBundle", "getApkFiles", "device", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "moduleName", "", "apkBundles", "", "getDeviceSpec", "Lcom/android/bundle/Devices$DeviceSpec;", "gradle-core"})
@JvmName(name="BundleInstallUtils")
@SourceDebugExtension(value={"SMAP\nBundleInstallUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleInstallUtils.kt\ncom/android/build/gradle/internal/tasks/BundleInstallUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n1360#3:84\n1446#3,5:85\n*S KotlinDebug\n*F\n+ 1 BundleInstallUtils.kt\ncom/android/build/gradle/internal/tasks/BundleInstallUtils\n*L\n58#1:84\n58#1:85,5\n*E\n"})
public final class BundleInstallUtils {
    @NotNull
    public static final Devices.DeviceSpec getDeviceSpec(@NotNull DeviceConfigProvider device) {
        Devices.DeviceSpec.Builder builder;
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Devices.DeviceSpec.Builder spec = builder = Devices.DeviceSpec.newBuilder();
        boolean bl = false;
        Object object = device.getApiLevel();
        int it = ((Number)object).intValue();
        boolean bl2 = false;
        Object object2 = it > 0 ? object : null;
        if (object2 != null) {
            it = ((Number)object2).intValue();
            boolean bl3 = false;
            spec.setSdkVersion(it);
        }
        Object object3 = device.getApiCodeName();
        String string = object3;
        if (string != null) {
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apiCodeName");
            String it2 = object3;
            boolean bl4 = false;
            spec.setCodename(it2);
        }
        Object it3 = object = device.getAbis();
        boolean bl5 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
        Object object4 = !((Collection)it3).isEmpty() ? object : null;
        if (object4 != null) {
            it3 = object4;
            boolean bl6 = false;
            spec.addAllSupportedAbis((Iterable)it3);
        }
        object = device.getDensity();
        int it2 = ((Number)object).intValue();
        boolean bl7 = false;
        Object object5 = it2 > 0 ? object : null;
        if (object5 != null) {
            it2 = ((Number)object5).intValue();
            boolean bl8 = false;
            spec.setScreenDensity(it2);
        }
        Object object6 = object3 = device.getLanguageSplits();
        if (object6 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"languageSplits");
            it = object3;
            boolean bl9 = false;
            spec.addAllSupportedLocales((Iterable)it);
        }
        Devices.DeviceSpec deviceSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceSpec, (String)"newBuilder().also { spec\u2026cales(it) }\n    }.build()");
        return deviceSpec;
    }

    @NotNull
    public static final List<Path> getApkFiles(@NotNull Path apkBundle, @NotNull DeviceConfigProvider device, @Nullable String moduleName) {
        Intrinsics.checkNotNullParameter((Object)apkBundle, (String)"apkBundle");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return BundleInstallUtils.getApkFiles(SetsKt.setOf((Object)apkBundle), device, moduleName);
    }

    public static /* synthetic */ List getApkFiles$default(Path path, DeviceConfigProvider deviceConfigProvider, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles(path, deviceConfigProvider, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> getApkFiles(@NotNull Collection<? extends Path> apkBundles, @NotNull DeviceConfigProvider device, @Nullable String moduleName) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(apkBundles, (String)"apkBundles");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Path path = Files.createTempDirectory("apkSelect", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(\"apkSelect\")");
        Path tempFolder = path;
        Devices.DeviceSpec deviceSpec = BundleInstallUtils.getDeviceSpec(device);
        Iterable $this$flatMap$iv = apkBundles;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path apkBundle = (Path)element$iv$iv;
            boolean bl = false;
            ExtractApksCommand.Builder command = ExtractApksCommand.builder().setApksArchivePath(apkBundle).setDeviceSpec(deviceSpec).setOutputDirectory(tempFolder);
            if (moduleName != null) {
                String it;
                boolean bl2 = false;
                command.setModules(ImmutableSet.of((Object)it));
            }
            ImmutableList immutableList = command.build().execute();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"command.build().execute()");
            Iterable list$iv$iv = (Iterable)immutableList;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List apkPaths = (List)destination$iv$iv;
        return apkPaths;
    }

    public static /* synthetic */ List getApkFiles$default(Collection collection, DeviceConfigProvider deviceConfigProvider, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles(collection, deviceConfigProvider, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> extractApkFilesBypassingBundleTool(@NotNull Path apkBundle) {
        Intrinsics.checkNotNullParameter((Object)apkBundle, (String)"apkBundle");
        Path path = Files.createTempDirectory(PathsKt.getNameWithoutExtension((Path)apkBundle), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(apkB\u2026dle.nameWithoutExtension)");
        Path tempFolder = path;
        Path outputFile = tempFolder.resolve("extracted-apk.apk");
        Closeable closeable = (Closeable)new ZipArchive(apkBundle);
        Throwable throwable = null;
        try {
            long l;
            ZipArchive it = (ZipArchive)closeable;
            boolean bl = false;
            Closeable closeable2 = it.getInputStream("standalones/standalone.apk");
            Throwable throwable2 = null;
            try {
                InputStream inputStream = (InputStream)closeable2;
                boolean bl2 = false;
                l = Files.copy(inputStream, outputFile, new CopyOption[0]);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return CollectionsKt.listOf((Object)outputFile);
    }
}

