/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.AllTestResults;
import com.android.build.gradle.internal.test.report.ClassPageRenderer;
import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.HtmlReportRenderer;
import com.android.build.gradle.internal.test.report.OverviewPageRenderer;
import com.android.build.gradle.internal.test.report.PackagePageRenderer;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestResult;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestReport {
    private final HtmlReportRenderer htmlRenderer = new HtmlReportRenderer();
    private final ReportType reportType;
    private final List<File> resultDirs;
    private final File reportDir;

    public TestReport(ReportType reportType, File resultDir, File reportDir) {
        this(reportType, (List<File>)ImmutableList.of((Object)resultDir), reportDir);
    }

    public TestReport(ReportType reportType, List<File> resultDirs, File reportDir) {
        this.reportType = reportType;
        this.resultDirs = resultDirs;
        this.reportDir = reportDir;
        this.htmlRenderer.requireResource(this.getClass().getResource("report.js"));
        this.htmlRenderer.requireResource(this.getClass().getResource("base-style.css"));
        this.htmlRenderer.requireResource(this.getClass().getResource("style.css"));
    }

    public CompositeTestResults generateReport() {
        AllTestResults model = this.loadModel();
        this.generateFiles(model);
        return model;
    }

    private AllTestResults loadModel() {
        AllTestResults model = new AllTestResults();
        for (File resultDir : this.resultDirs) {
            File[] files2;
            if (!FileInterceptorsDeclaration.intercept_exists((File)resultDir, (String)"com.android.build.gradle.internal.test.report.TestReport") || (files2 = FileInterceptorsDeclaration.intercept_listFiles((File)resultDir, (String)"com.android.build.gradle.internal.test.report.TestReport")) == null) continue;
            for (File file : files2) {
                if (!file.getName().startsWith("TEST-") || !file.getName().endsWith(".xml")) continue;
                this.mergeFromFile(file, model);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mergeFromFile(File file, AllTestResults model) {
        FileInputStream inputStream = null;
        try {
            void document332;
            File file2 = file;
            FileInputStream fileInputStream = new FileInputStream(file2);
            FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file2, (String)"com.android.build.gradle.internal.test.report.TestReport");
            inputStream = fileInputStream;
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(inputStream));
            }
            finally {
                ((InputStream)inputStream).close();
            }
            String deviceName = null;
            String projectName = null;
            String flavorName2 = null;
            NodeList propertiesList = document332.getElementsByTagName("properties");
            for (int i = 0; i < propertiesList.getLength(); ++i) {
                Element properties = (Element)propertiesList.item(i);
                XPath xPath = XPathFactory.newInstance().newXPath();
                deviceName = xPath.evaluate("property[@name='device']/@value", properties);
                projectName = xPath.evaluate("property[@name='project']/@value", properties);
                flavorName2 = xPath.evaluate("property[@name='flavor']/@value", properties);
            }
            NodeList testCases = document332.getElementsByTagName("testcase");
            for (int i = 0; i < testCases.getLength(); ++i) {
                Element testCase = (Element)testCases.item(i);
                String className = testCase.getAttribute("classname");
                String testName = testCase.getAttribute("name");
                BigDecimal duration = this.parse(testCase.getAttribute("time"));
                duration = duration.multiply(BigDecimal.valueOf(1000L));
                NodeList failures = testCase.getElementsByTagName("failure");
                TestResult testResult = model.addTest(className, testName, duration.longValue(), deviceName, projectName, flavorName2);
                for (int j = 0; j < failures.getLength(); ++j) {
                    Element failure = (Element)failures.item(j);
                    testResult.addFailure(failure.getAttribute("message"), failure.getTextContent(), deviceName, projectName, flavorName2);
                }
                if (testCase.getElementsByTagName("skipped").getLength() <= 0) continue;
                testResult.ignored(deviceName, projectName, flavorName2);
            }
            NodeList ignoredTestCases = document332.getElementsByTagName("ignored-testcase");
            for (int i = 0; i < ignoredTestCases.getLength(); ++i) {
                Element testCase = (Element)ignoredTestCases.item(i);
                String className = testCase.getAttribute("classname");
                String testName = testCase.getAttribute("name");
                model.addTest(className, testName, 0L, deviceName, projectName, flavorName2).ignored(deviceName, projectName, flavorName2);
            }
            String suiteClassName = document332.getDocumentElement().getAttribute("name");
            if (!StringsKt.isBlank((CharSequence)suiteClassName)) {
                ClassTestResults suiteResults = model.addTestClass(suiteClassName);
                NodeList stdOutElements = document332.getElementsByTagName("system-out");
                for (int i = 0; i < stdOutElements.getLength(); ++i) {
                    suiteResults.addStandardOutput(deviceName, stdOutElements.item(i).getTextContent());
                }
                NodeList stdErrElements = document332.getElementsByTagName("system-err");
                for (int i = 0; i < stdErrElements.getLength(); ++i) {
                    suiteResults.addStandardError(deviceName, stdErrElements.item(i).getTextContent());
                }
            } else {
                NodeList stdOutElements = document332.getElementsByTagName("system-out");
                for (int i = 0; i < stdOutElements.getLength(); ++i) {
                    model.addStandardOutput(deviceName, stdOutElements.item(i).getTextContent());
                }
                NodeList stdErrElements = document332.getElementsByTagName("system-err");
                for (int i = 0; i < stdErrElements.getLength(); ++i) {
                    model.addStandardError(deviceName, stdErrElements.item(i).getTextContent());
                }
            }
        }
        catch (Exception e) {
            try {
                throw new GradleException(String.format("Could not load test results from '%s'.", file), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(inputStream, (boolean)true);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)inputStream, (boolean)true);
            return;
        }
        catch (IOException document332) {
            return;
        }
    }

    private void generateFiles(AllTestResults model) {
        try {
            this.generatePage(model, new OverviewPageRenderer(this.reportType), new File(this.reportDir, "index.html"));
            for (PackageTestResults packageResults : model.getPackages()) {
                this.generatePage(packageResults, new PackagePageRenderer(this.reportType), new File(this.reportDir, packageResults.getFilename(this.reportType) + ".html"));
                for (ClassTestResults classResults : packageResults.getClasses()) {
                    this.generatePage(classResults, new ClassPageRenderer(this.reportType), new File(this.reportDir, classResults.getFilename(this.reportType) + ".html"));
                }
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not generate test report to '%s'.", this.reportDir), (Throwable)e);
        }
    }

    private <T extends CompositeTestResults> void generatePage(T model, PageRenderer<T> renderer, File outputFile) throws Exception {
        this.htmlRenderer.renderer(renderer).writeTo(model, outputFile);
    }

    public BigDecimal parse(String source) throws ParseException {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#.#", symbols);
        format.setParseBigDecimal(true);
        return (BigDecimal)format.parse(source);
    }
}

