/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class ChangeRecords {
    Map<String, Status> records = new HashMap<String, Status>();

    public synchronized void add(Status status, String filePath) {
        this.records.put(filePath, status);
    }

    public synchronized void addAll(ChangeRecords changeRecords) {
        for (Map.Entry<String, Status> changeRecord : changeRecords.records.entrySet()) {
            if (this.records.containsKey(changeRecord.getKey())) continue;
            this.records.put(changeRecord.getKey(), changeRecord.getValue());
        }
    }

    synchronized Status getChangeFor(String filePath) {
        return this.records.get(filePath);
    }

    void write(File file) throws IOException {
        Files.createParentDirs((File)file);
        try (FileWriter fileWriter = new FileWriter(file);){
            for (Map.Entry<String, Status> record : this.records.entrySet()) {
                fileWriter.write(String.format("%s,%s", record.getValue(), record.getKey()));
                fileWriter.write("\n");
            }
        }
    }

    synchronized Set<String> getFilesForStatus(Status status) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String s : this.records.keySet()) {
            if (this.getChangeFor(s) != status) continue;
            builder.add((Object)s);
        }
        return builder.build();
    }

    public static void process(File incrementalFile, RecordHandler handler2) throws IOException, TransformException {
        if (!FileInterceptorsDeclaration.intercept_isFile((File)incrementalFile, (String)"com.android.build.gradle.internal.transforms.ChangeRecords")) {
            return;
        }
        Map<String, Status> changeRecords = ChangeRecords.load((File)incrementalFile).records;
        FileUtils.delete((File)incrementalFile);
        if (changeRecords.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Status> changeRecord : changeRecords.entrySet()) {
            handler2.handle(changeRecord.getKey(), changeRecord.getValue());
        }
    }

    static ChangeRecords load(File file) throws IOException {
        ChangeRecords changeRecords = new ChangeRecords();
        List rawRecords = Files.readLines((File)file, (Charset)Charsets.UTF_8);
        for (String rawRecord : rawRecords) {
            StringTokenizer st = new StringTokenizer(rawRecord, ",");
            if (st.countTokens() != 2) {
                throw new IOException("Invalid incremental change record : " + rawRecord);
            }
            changeRecords.add(Status.valueOf((String)st.nextToken()), st.nextToken());
        }
        return changeRecords;
    }

    public static interface RecordHandler {
        public void handle(String var1, Status var2) throws IOException, TransformException;
    }
}

