/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.shrinker;

import com.android.aapt.Resources;
import com.android.build.shrinker.PossibleResourcesMarker;
import com.android.build.shrinker.ShrinkerDebugReporter;
import com.android.build.shrinker.obfuscation.ObfuscatedClasses;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class ResourceShrinkerModel {
    private final ShrinkerDebugReporter debugReporter;
    private final ResourceStore resourceStore;
    private ObfuscatedClasses obfuscatedClasses = ObfuscatedClasses.NO_OBFUSCATION;
    private final Set<String> strings = Sets.newHashSetWithExpectedSize((int)300);
    private final Map<String, Resources.ResourceTable> resourceTableCache = Maps.newHashMap();
    private boolean foundGetIdentifier = false;
    private boolean foundWebContent = false;

    public ResourceShrinkerModel(ShrinkerDebugReporter debugReporter, boolean supportMultipackages) {
        this.debugReporter = debugReporter;
        this.resourceStore = new ResourceStore(supportMultipackages);
    }

    public ShrinkerDebugReporter getDebugReporter() {
        return this.debugReporter;
    }

    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public ObfuscatedClasses getObfuscatedClasses() {
        return this.obfuscatedClasses;
    }

    public void setObfuscatedClasses(ObfuscatedClasses obfuscatedClasses) {
        this.obfuscatedClasses = obfuscatedClasses;
    }

    public ResourceUsageModel.Resource addResource(ResourceType type, String packageName, String name, String value) {
        int intValue = -1;
        try {
            intValue = value != null ? Integer.decode(value) : -1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.addResource(type, packageName, name, intValue);
    }

    public ResourceUsageModel.Resource addResource(ResourceType type, String packageName, String name, int value) {
        return this.resourceStore.addResource(new ResourceUsageModel.Resource(packageName, type, name, value));
    }

    public void addStringConstant(String string) {
        this.strings.add(string);
    }

    public boolean isFoundGetIdentifier() {
        return this.foundGetIdentifier;
    }

    public void setFoundGetIdentifier(boolean foundGetIdentifier) {
        this.foundGetIdentifier = foundGetIdentifier;
    }

    public boolean isFoundWebContent() {
        return this.foundWebContent;
    }

    public void setFoundWebContent(boolean foundWebContent) {
        this.foundWebContent = foundWebContent;
    }

    public Set<String> getStrings() {
        return this.strings;
    }

    public void keepPossiblyReferencedResources() {
        if (this.strings.isEmpty() || !this.resourceStore.getSafeMode() || !this.foundGetIdentifier && !this.foundWebContent) {
            return;
        }
        this.debugReporter.debug((Function0<String>)(Function0 & Serializable)() -> "android.content.res.Resources#getIdentifier present: " + this.foundGetIdentifier + "\nWeb content present: " + this.foundWebContent + "\nReferenced Strings:\n" + this.strings.stream().map((Function<String, String> & Serializable)s -> s.trim().replace("\n", "\\n")).filter((Predicate<String> & Serializable)s -> !s.isEmpty()).map((Function<String, String> & Serializable)s -> s.length() > 40 ? s.substring(0, 37) + "..." : s).collect(Collectors.joining("\n")));
        new PossibleResourcesMarker(this.debugReporter, this.resourceStore, this.strings, this.foundWebContent).markPossibleResourcesReachable();
    }

    public Resources.ResourceTable readResourceTable(Path resourceTablePath) {
        return this.resourceTableCache.computeIfAbsent(resourceTablePath.toString(), (Function<String, Resources.ResourceTable> & Serializable)path -> {
            try {
                return Resources.ResourceTable.parseFrom((byte[])NioFileInterceptors.intercept_readAllBytes((Path)resourceTablePath, (String)"com.android.build.shrinker.ResourceShrinkerModel"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

