/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.MlNames;
import com.android.tools.mlkit.TensorInfo;
import com.android.tools.mlkit.TfliteModelException;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.tensorflow.lite.support.metadata.MetadataExtractor;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import org.tensorflow.lite.support.metadata.schema.TensorMetadata;

class ModelVerifier {
    private static final String MODEL_UNSUPPORTED_PREFIX = "This model is not supported: ";

    ModelVerifier() {
    }

    static MetadataExtractor getExtractorWithVerification(ByteBuffer byteBuffer) throws TfliteModelException {
        MetadataExtractor extractor;
        try {
            extractor = new MetadataExtractor(byteBuffer);
        }
        catch (Exception e) {
            throw new TfliteModelException("Not a valid TensorFlow Lite model");
        }
        ModelVerifier.verifyModel(extractor);
        return extractor;
    }

    @VisibleForTesting
    static void verifyModel(MetadataExtractor extractor) throws TfliteModelException {
        ModelMetadata metadata = extractor.hasMetadata() ? extractor.getModelMetadata() : null;
        HashSet<String> inputNameSet = new HashSet<String>();
        for (int i = 0; i < extractor.getInputTensorCount(); ++i) {
            ModelVerifier.verifyDataType(extractor.getInputTensorType(i), i, TensorInfo.Source.INPUT);
            if (metadata == null) continue;
            TensorMetadata tensorMetadata = metadata.subgraphMetadata(0).inputTensorMetadata(i);
            ModelVerifier.verifyTensorMetadata(tensorMetadata, i, TensorInfo.Source.INPUT);
            String formattedName = MlNames.computeIdentifierName(tensorMetadata.name());
            if (inputNameSet.contains(formattedName)) {
                throw new TfliteModelException(String.format("%sTensors cannot have the same name (%s).", MODEL_UNSUPPORTED_PREFIX, formattedName));
            }
            inputNameSet.add(formattedName);
            if (TensorInfo.extractContentType(tensorMetadata) != TensorInfo.ContentType.IMAGE || extractor.getInputTensorShape(i).length == 4) continue;
            throw new TfliteModelException("This model is not supported: Image tensor shape must have length 4.");
        }
        HashSet<String> outputNameSet = new HashSet<String>();
        for (int i = 0; i < extractor.getOutputTensorCount(); ++i) {
            ModelVerifier.verifyDataType(extractor.getOutputTensorType(i), i, TensorInfo.Source.OUTPUT);
            if (metadata == null) continue;
            TensorMetadata tensorMetadata = metadata.subgraphMetadata(0).outputTensorMetadata(i);
            ModelVerifier.verifyTensorMetadata(tensorMetadata, i, TensorInfo.Source.OUTPUT);
            String formattedName = MlNames.computeIdentifierName(tensorMetadata.name());
            if (outputNameSet.contains(formattedName)) {
                throw new TfliteModelException(String.format("%sTensors cannot have the same name (%s).", MODEL_UNSUPPORTED_PREFIX, formattedName));
            }
            outputNameSet.add(formattedName);
        }
    }

    private static void verifyTensorMetadata(TensorMetadata tensorMetadata, int index, TensorInfo.Source source) throws TfliteModelException {
        if (tensorMetadata == null) {
            throw new TfliteModelException(MODEL_UNSUPPORTED_PREFIX + String.format("%s tensor %d does not have metadata.", source == TensorInfo.Source.INPUT ? "Input" : "Output", index));
        }
        if (tensorMetadata.name() == null) {
            throw new TfliteModelException(String.format("This model is not supported: %s tensor %d does not have a name.", source == TensorInfo.Source.INPUT ? "Input" : "Output", index));
        }
    }

    @VisibleForTesting
    static void verifyDataType(byte dataType, int index, TensorInfo.Source source) throws TfliteModelException {
        if (TensorInfo.DataType.fromByte(dataType) == TensorInfo.DataType.UNKNOWN) {
            throw new TfliteModelException(MODEL_UNSUPPORTED_PREFIX + String.format("Data type of %s tensor %d is not supported.", source == TensorInfo.Source.INPUT ? "input" : "output", index));
        }
    }
}

