/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtilsLite;
import com.android.apksig.internal.apk.ApkSupportedSignature;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.NoApkSupportedSignaturesException;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.SignatureNotFoundException;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipSections;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ApkSigningBlockUtilsLite {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private ApkSigningBlockUtilsLite() {
    }

    public static SignatureInfo findSignature(DataSource apk, ZipSections zipSections, int blockId) throws IOException, SignatureNotFoundException {
        DataSource apkSigningBlock;
        long apkSigningBlockOffset;
        try {
            ApkUtilsLite.ApkSigningBlock apkSigningBlockInfo = ApkUtilsLite.findApkSigningBlock(apk, zipSections);
            apkSigningBlockOffset = apkSigningBlockInfo.getStartOffset();
            apkSigningBlock = apkSigningBlockInfo.getContents();
        }
        catch (ApkSigningBlockNotFoundException e) {
            throw new SignatureNotFoundException(e.getMessage(), e);
        }
        ByteBuffer apkSigningBlockBuf = apkSigningBlock.getByteBuffer(0L, (int)apkSigningBlock.size());
        apkSigningBlockBuf.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer apkSignatureSchemeBlock = ApkSigningBlockUtilsLite.findApkSignatureSchemeBlock(apkSigningBlockBuf, blockId);
        return new SignatureInfo(apkSignatureSchemeBlock, apkSigningBlockOffset, zipSections.getZipCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectory());
    }

    public static ByteBuffer findApkSignatureSchemeBlock(ByteBuffer apkSigningBlock, int blockId) throws SignatureNotFoundException {
        ApkSigningBlockUtilsLite.checkByteOrderLittleEndian(apkSigningBlock);
        ByteBuffer pairs = ApkSigningBlockUtilsLite.sliceFromTo(apkSigningBlock, 8, apkSigningBlock.capacity() - 24);
        int entryCount = 0;
        while (pairs.hasRemaining()) {
            ++entryCount;
            if (pairs.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + entryCount);
            }
            long lenLong = pairs.getLong();
            if (lenLong < 4L || lenLong > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + lenLong);
            }
            int len = (int)lenLong;
            int nextEntryPos = pairs.position() + len;
            if (len > pairs.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + len + ", available: " + pairs.remaining());
            }
            int id = pairs.getInt();
            if (id == blockId) {
                return ApkSigningBlockUtilsLite.getByteBuffer(pairs, len - 4);
            }
            pairs.position(nextEntryPos);
        }
        throw new SignatureNotFoundException("No APK Signature Scheme block in APK Signing Block with ID: " + blockId);
    }

    public static void checkByteOrderLittleEndian(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    public static <T extends ApkSupportedSignature> List<T> getSignaturesToVerify(List<T> signatures, int minSdkVersion, int maxSdkVersion) throws NoApkSupportedSignaturesException {
        return ApkSigningBlockUtilsLite.getSignaturesToVerify(signatures, minSdkVersion, maxSdkVersion, false);
    }

    public static <T extends ApkSupportedSignature> List<T> getSignaturesToVerify(List<T> signatures, int minSdkVersion, int maxSdkVersion, boolean onlyRequireJcaSupport) throws NoApkSupportedSignaturesException {
        HashMap<Integer, ApkSupportedSignature> bestSigAlgorithmOnSdkVersion = new HashMap<Integer, ApkSupportedSignature>();
        int minProvidedSignaturesVersion = Integer.MAX_VALUE;
        for (ApkSupportedSignature sig : signatures) {
            ApkSupportedSignature candidate;
            SignatureAlgorithm sigAlgorithm = sig.algorithm;
            int sigMinSdkVersion = onlyRequireJcaSupport ? sigAlgorithm.getJcaSigAlgMinSdkVersion() : sigAlgorithm.getMinSdkVersion();
            if (sigMinSdkVersion > maxSdkVersion) continue;
            if (sigMinSdkVersion < minProvidedSignaturesVersion) {
                minProvidedSignaturesVersion = sigMinSdkVersion;
            }
            if ((candidate = (ApkSupportedSignature)bestSigAlgorithmOnSdkVersion.get(sigMinSdkVersion)) != null && ApkSigningBlockUtilsLite.compareSignatureAlgorithm(sigAlgorithm, candidate.algorithm) <= 0) continue;
            bestSigAlgorithmOnSdkVersion.put(sigMinSdkVersion, sig);
        }
        if (minSdkVersion < minProvidedSignaturesVersion) {
            throw new NoApkSupportedSignaturesException("Minimum provided signature version " + minProvidedSignaturesVersion + " > minSdkVersion " + minSdkVersion);
        }
        if (bestSigAlgorithmOnSdkVersion.isEmpty()) {
            throw new NoApkSupportedSignaturesException("No supported signature");
        }
        ArrayList signaturesToVerify = new ArrayList(bestSigAlgorithmOnSdkVersion.values());
        Collections.sort(signaturesToVerify, (Comparator & Serializable)(sig1, sig2) -> Integer.compare(sig1.algorithm.getId(), sig2.algorithm.getId()));
        return signaturesToVerify;
    }

    public static int compareSignatureAlgorithm(SignatureAlgorithm alg1, SignatureAlgorithm alg2) {
        ContentDigestAlgorithm digestAlg1 = alg1.getContentDigestAlgorithm();
        ContentDigestAlgorithm digestAlg2 = alg2.getContentDigestAlgorithm();
        return ApkSigningBlockUtilsLite.compareContentDigestAlgorithm(digestAlg1, digestAlg2);
    }

    private static int compareContentDigestAlgorithm(ContentDigestAlgorithm alg1, ContentDigestAlgorithm alg2) {
        switch (alg1) {
            case CHUNKED_SHA256: {
                switch (alg2) {
                    case CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: 
                    case VERITY_CHUNKED_SHA256: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
            case CHUNKED_SHA512: {
                switch (alg2) {
                    case CHUNKED_SHA256: 
                    case VERITY_CHUNKED_SHA256: {
                        return 1;
                    }
                    case CHUNKED_SHA512: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
            case VERITY_CHUNKED_SHA256: {
                switch (alg2) {
                    case CHUNKED_SHA256: {
                        return 1;
                    }
                    case VERITY_CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
        }
        throw new IllegalArgumentException("Unknown alg1: " + (Object)((Object)alg1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer sliceFromTo(ByteBuffer source, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start: " + end + " < " + start);
        }
        int capacity = source.capacity();
        if (end > source.capacity()) {
            throw new IllegalArgumentException("end > capacity: " + end + " > " + capacity);
        }
        int originalLimit = source.limit();
        int originalPosition = source.position();
        try {
            source.position(0);
            source.limit(end);
            source.position(start);
            ByteBuffer result = source.slice();
            result.order(source.order());
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.position(0);
            source.limit(originalLimit);
            source.position(originalPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getByteBuffer(ByteBuffer source, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        int originalLimit = source.limit();
        int position = source.position();
        int limit = position + size;
        if (limit < position || limit > originalLimit) {
            throw new BufferUnderflowException();
        }
        source.limit(limit);
        try {
            ByteBuffer result = source.slice();
            result.order(source.order());
            source.position(limit);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.limit(originalLimit);
        }
    }

    public static String toHex(byte[] value) {
        StringBuilder sb = new StringBuilder(value.length * 2);
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            int hi = (value[i] & 0xFF) >>> 4;
            int lo = value[i] & 0xF;
            sb.append(HEX_DIGITS[hi]).append(HEX_DIGITS[lo]);
        }
        return sb.toString();
    }

    public static ByteBuffer getLengthPrefixedSlice(ByteBuffer source) throws ApkFormatException {
        if (source.remaining() < 4) {
            throw new ApkFormatException("Remaining buffer too short to contain length of length-prefixed field. Remaining: " + source.remaining());
        }
        int len = source.getInt();
        if (len < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (len > source.remaining()) {
            throw new ApkFormatException("Length-prefixed field longer than remaining buffer. Field length: " + len + ", remaining: " + source.remaining());
        }
        return ApkSigningBlockUtilsLite.getByteBuffer(source, len);
    }

    public static byte[] readLengthPrefixedByteArray(ByteBuffer buf) throws ApkFormatException {
        int len = buf.getInt();
        if (len < 0) {
            throw new ApkFormatException("Negative length");
        }
        if (len > buf.remaining()) {
            throw new ApkFormatException("Underflow while reading length-prefixed value. Length: " + len + ", available: " + buf.remaining());
        }
        byte[] result = new byte[len];
        buf.get(result);
        return result;
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(List<Pair<Integer, byte[]>> sequence) {
        int resultSize = 0;
        for (Pair<Integer, byte[]> element : sequence) {
            resultSize += 12 + element.getSecond().length;
        }
        ByteBuffer result = ByteBuffer.allocate(resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        for (Pair<Integer, byte[]> element : sequence) {
            byte[] second = element.getSecond();
            result.putInt(8 + second.length);
            result.putInt(element.getFirst());
            result.putInt(second.length);
            result.put(second);
        }
        return result.array();
    }
}

