/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.MergingLogPersistUtil;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.RelativeResourceUtils;
import com.android.utils.FileUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

public class MergingLog {
    private final LoadingCache<String, Map<SourceFile, SourceFile>> mWholeFileMaps = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Map<SourceFile, SourceFile>>(){

        public Map<SourceFile, SourceFile> load(String shard) {
            return MergingLogPersistUtil.loadFromSingleFile(MergingLog.this.mOutputFolder, shard);
        }
    });
    private final CacheLoader<String, Map<SourceFile, Map<SourcePosition, SourceFilePosition>>> cacheLoader = new CacheLoader<String, Map<SourceFile, Map<SourcePosition, SourceFilePosition>>>(){

        public Map<SourceFile, Map<SourcePosition, SourceFilePosition>> load(String shard) throws Exception {
            return MergingLogPersistUtil.loadFromMultiFileVersion2(MergingLog.this.mOutputFolder, shard, !MergingLog.this.mSourceSetPaths.isEmpty());
        }
    };
    private final LoadingCache<String, Map<SourceFile, Map<SourcePosition, SourceFilePosition>>> mMergedFileMaps = CacheBuilder.newBuilder().build(this.cacheLoader);
    private final File mOutputFolder;
    private final Map<String, String> mSourceSetPaths;

    public MergingLog(File outputFolder) {
        this(outputFolder, Collections.EMPTY_MAP);
    }

    public MergingLog(File outputFolder, Map<String, String> sourceSetPaths) {
        this.mOutputFolder = outputFolder;
        this.mSourceSetPaths = sourceSetPaths;
    }

    public void logCopy(SourceFile source, SourceFile destination) {
        this.getWholeFileMap(destination).put(destination, source);
    }

    public void logCopy(File source, File destination) {
        this.logCopy(new SourceFile(source), new SourceFile(destination));
    }

    public void logCopy(File source, String sourcePath2, File destination, String destinationPath) {
        SourceFile sourceFile = new SourceFile(source);
        sourceFile.setOverrideSourcePath(sourcePath2);
        SourceFile destinationSource = new SourceFile(destination);
        destinationSource.setOverrideSourcePath(destinationPath);
        this.logCopy(sourceFile, destinationSource);
    }

    public void logRemove(SourceFile merged) {
        this.getWholeFileMap(merged).remove(merged);
        this.getMergedFileMap(merged).remove(merged);
    }

    public void logSource(SourceFile mergedFile, Map<SourcePosition, SourceFilePosition> map) {
        this.getMergedFileMap(mergedFile).put(mergedFile, map);
    }

    public void logSource(SourceFile mergedFile, String mergedFilePath, Map<SourcePosition, SourceFilePosition> map) {
        mergedFile.setOverrideSourcePath(mergedFilePath);
        this.getMergedFileMap(mergedFile).put(mergedFile, map);
    }

    private Map<SourceFile, SourceFile> getWholeFileMap(SourceFile file) {
        String shard = MergingLog.getShard(file);
        try {
            return (Map)this.mWholeFileMaps.get((Object)shard);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<SourceFile, Map<SourcePosition, SourceFilePosition>> getMergedFileMap(SourceFile file) {
        String shard = MergingLog.getShard(file);
        try {
            return (Map)this.mMergedFileMaps.get((Object)shard);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public SourceFile find(SourceFile mergedFile) {
        SourceFile sourceFile;
        Map<SourceFile, SourceFile> blameMap = this.getWholeFileMap(mergedFile);
        if (!blameMap.isEmpty() && !this.mSourceSetPaths.isEmpty() && mergedFile.getSourcePath() != null) {
            String relativePath = RelativeResourceUtils.getRelativeSourceSetPath(new File(mergedFile.getSourcePath()), this.mSourceSetPaths);
            SourceFile relativeMergedSourceFile = new SourceFile(new File(relativePath));
            relativeMergedSourceFile.setOverrideSourcePath(relativePath);
            SourceFile relativeSourceFile = blameMap.get(relativeMergedSourceFile);
            if (relativeSourceFile != null && relativeSourceFile.getSourcePath() != null) {
                String absoluteSourcePath = RelativeResourceUtils.relativeResourcePathToAbsolutePath(relativeSourceFile.getSourcePath(), this.mSourceSetPaths, FileSystems.getDefault());
                return new SourceFile(new File(absoluteSourcePath));
            }
        }
        return (sourceFile = blameMap.get(mergedFile)) != null ? sourceFile : mergedFile;
    }

    public SourceFilePosition find(SourceFilePosition mergedFilePosition) {
        SourceFile mergedSourceFile = mergedFilePosition.getFile();
        Map<SourcePosition, SourceFilePosition> positionMap = this.getPositionMap(mergedSourceFile, this.mSourceSetPaths);
        if (positionMap == null) {
            SourceFile sourceFile = this.find(mergedSourceFile);
            return new SourceFilePosition(sourceFile, mergedFilePosition.getPosition());
        }
        SourceFilePosition position = MergingLog.find(mergedFilePosition.getPosition(), positionMap);
        return position != null ? position : mergedFilePosition;
    }

    protected Map<SourcePosition, SourceFilePosition> getPositionMap(SourceFile mergedSourceFile, Map<String, String> sourceSetPaths) {
        if (!sourceSetPaths.isEmpty()) {
            String relativePath = RelativeResourceUtils.getRelativeSourceSetPath(mergedSourceFile.getSourceFile(), sourceSetPaths);
            SourceFile mergedAbsoluteSourceFile = new SourceFile(new File(relativePath));
            return this.getMergedFileMap(mergedAbsoluteSourceFile).get(mergedAbsoluteSourceFile);
        }
        return this.getMergedFileMap(mergedSourceFile).get(mergedSourceFile);
    }

    public static SourceFilePosition find(SourcePosition position, Map<SourcePosition, SourceFilePosition> positionMap) {
        Map.Entry candidate;
        TreeMap<SourcePosition, SourceFilePosition> sortedMap = new TreeMap<SourcePosition, SourceFilePosition>(SourcePosition::compareStart);
        sortedMap.putAll(positionMap);
        Map.Entry entry = candidate = position.getStartColumn() == -1 ? sortedMap.ceilingEntry(position) : sortedMap.floorEntry(position);
        if (candidate == null) {
            candidate = position.getStartColumn() == -1 ? sortedMap.lastEntry() : sortedMap.firstEntry();
        }
        int patience = 20;
        while (candidate != null && (position.compareEnd(candidate.getKey()) > 0 || position.compareStart((SourcePosition)candidate.getKey()) < 0)) {
            if (--patience == 0) {
                candidate = null;
                break;
            }
            candidate = sortedMap.lowerEntry((SourcePosition)candidate.getKey());
        }
        if (candidate == null) {
            return null;
        }
        return (SourceFilePosition)candidate.getValue();
    }

    private static String getShard(SourceFile sourceFile) {
        String sourcePath2 = sourceFile.getSourcePath();
        return sourcePath2 != null ? sourceFile.getSourceFile().getParentFile().getName() : "unknown";
    }

    public void write() throws IOException {
        FileUtils.mkdirs((File)this.mOutputFolder);
        for (Map.Entry entry : this.mMergedFileMaps.asMap().entrySet()) {
            MergingLogPersistUtil.saveToMultiFileVersion2(this.mOutputFolder, (String)entry.getKey(), (Map)entry.getValue());
        }
        for (Map.Entry entry : this.mWholeFileMaps.asMap().entrySet()) {
            MergingLogPersistUtil.saveToSingleFile(this.mOutputFolder, (String)entry.getKey(), (Map)entry.getValue());
        }
    }

    public SourceFile destinationFor(SourceFile original) {
        String shard = MergingLog.getShard(original);
        try {
            Optional dst = ((Map)this.mWholeFileMaps.get((Object)shard)).entrySet().stream().filter((Predicate<Map.Entry> & Serializable)e -> ((SourceFile)e.getValue()).equals((Object)original)).map(Map.Entry::getKey).findFirst();
            if (dst.isPresent()) {
                return (SourceFile)dst.get();
            }
            dst = ((Map)this.mMergedFileMaps.get((Object)shard)).entrySet().stream().filter((Predicate<Map.Entry> & Serializable)e -> ((Map)e.getValue()).values().stream().anyMatch((Predicate<SourceFilePosition> & Serializable)sfp -> sfp.getFile().equals((Object)original))).map(Map.Entry::getKey).findFirst();
            if (dst.isPresent()) {
                return (SourceFile)dst.get();
            }
            throw new RuntimeException("No destination found for " + original);
        }
        catch (ExecutionException e2) {
            throw new RuntimeException(e2);
        }
    }
}

