/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceResolver
extends RenderResources {
    public static final int MAX_RESOURCE_INDIRECTION = 50;
    public static final String THEME_NAME = "Theme";
    public static final String THEME_NAME_DOT = "Theme.";
    public static final String LEGACY_THEME = "";
    public static final Pattern DEVICE_DEFAULT_PATTERN = Pattern.compile("(\\p{Alpha}+)?\\.?DeviceDefault\\.?(.+)?");
    private final Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> mResources;
    private final Map<ResourceReference, StyleResourceValue> mStyleInheritanceMap = new HashMap<ResourceReference, StyleResourceValue>();
    private final Multimap<ResourceReference, StyleResourceValue> mReverseStyleInheritanceMap = HashMultimap.create();
    private final StyleResourceValue mDefaultTheme;
    private final List<StyleResourceValue> mThemes;
    private ILayoutLog mLogger;
    private String mDeviceDefaultParent;
    private SampleDataManager mSampleDataManager = new SampleDataManager();

    private ResourceResolver(Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, StyleResourceValue theme) {
        this.mResources = resources;
        this.mDefaultTheme = theme;
        this.mThemes = new LinkedList<StyleResourceValue>();
    }

    public static ResourceResolver create(Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, ResourceReference themeReference) {
        StyleResourceValue theme = null;
        if (themeReference != null) {
            assert (themeReference.getResourceType() == ResourceType.STYLE);
            theme = ResourceResolver.findTheme(themeReference, resources);
        }
        ResourceResolver resolver = new ResourceResolver(resources, theme);
        resolver.preProcessStyles();
        return resolver;
    }

    private static StyleResourceValue findTheme(ResourceReference themeReference, Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources) {
        Map<ResourceType, ResourceValueMap> namespaceMap = resources.get(themeReference.getNamespace());
        if (namespaceMap == null) {
            return null;
        }
        ResourceValueMap stylesMap = namespaceMap.get(ResourceType.STYLE);
        if (stylesMap == null) {
            return null;
        }
        ResourceValue resourceValue = (ResourceValue)stylesMap.get(themeReference.getName());
        return resourceValue instanceof StyleResourceValue ? (StyleResourceValue)resourceValue : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceResolver copy(ResourceResolver original) {
        if (original == null) {
            return null;
        }
        ResourceResolver resolver = new ResourceResolver(original.mResources, original.mDefaultTheme);
        resolver.mLogger = original.mLogger;
        resolver.mStyleInheritanceMap.putAll(original.mStyleInheritanceMap);
        resolver.mReverseStyleInheritanceMap.putAll(original.mReverseStyleInheritanceMap);
        List<StyleResourceValue> originalThemes = original.getAllThemes();
        List<StyleResourceValue> list = resolver.mThemes;
        synchronized (list) {
            resolver.mThemes.addAll(originalThemes);
        }
        return resolver;
    }

    @VisibleForTesting
    public static ResourceResolver withValues(ResourceValue ... values) {
        return ResourceResolver.withValues(Arrays.asList(values), null);
    }

    @VisibleForTesting
    public static ResourceResolver withValues(Iterable<ResourceValue> values, ResourceReference themeReference) {
        HashMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources = new HashMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>>();
        for (ResourceValue value : values) {
            Map<ResourceType, ResourceValueMap> byType = resources.computeIfAbsent(value.getNamespace(), (Function<ResourceNamespace, Map<ResourceType, ResourceValueMap>>)(Function<ResourceNamespace, Map> & Serializable)ns -> new EnumMap(ResourceType.class));
            ResourceValueMap resourceValueMap = byType.computeIfAbsent(value.getResourceType(), (Function<ResourceType, ResourceValueMap> & Serializable)t -> ResourceValueMap.create());
            Preconditions.checkArgument((!resourceValueMap.containsKey(value.getName()) ? 1 : 0) != 0, (Object)("Duplicate resource: " + value));
            resourceValueMap.put(value);
        }
        return ResourceResolver.create(resources, themeReference);
    }

    private ResourceValueMap getResourceValueMap(ResourceNamespace namespace, ResourceType type) {
        Map<ResourceType, ResourceValueMap> row = this.mResources.get(namespace);
        return row != null ? row.get(type) : null;
    }

    public void setDeviceDefaults(String deviceDefaultParent) {
        if (deviceDefaultParent.equals(this.mDeviceDefaultParent)) {
            return;
        }
        this.mDeviceDefaultParent = deviceDefaultParent;
        String parentName = Strings.emptyToNull((String)deviceDefaultParent);
        ResourceValueMap frameworkStyles = this.getResourceValueMap(ResourceNamespace.ANDROID, ResourceType.STYLE);
        if (frameworkStyles == null) {
            return;
        }
        for (ResourceValue value : frameworkStyles.values()) {
            Matcher matcher = DEVICE_DEFAULT_PATTERN.matcher(value.getName());
            if (!matcher.matches()) continue;
            String newParentStyle = Joiner.on((char)'.').skipNulls().join((Object)matcher.group(1), (Object)parentName, new Object[]{matcher.groupCount() > 1 ? matcher.group(2) : null});
            this.patchFrameworkStyleParent(value.getName(), newParentStyle);
        }
    }

    private void patchFrameworkStyleParent(String childStyleName, String parentName) {
        ResourceValueMap map = this.getResourceValueMap(ResourceNamespace.ANDROID, ResourceType.STYLE);
        if (map != null) {
            StyleResourceValue from = (StyleResourceValue)map.get(childStyleName);
            StyleResourceValue to = (StyleResourceValue)map.get(parentName);
            if (from != null && to != null) {
                this.mStyleInheritanceMap.put(from.asReference(), to);
                this.mReverseStyleInheritanceMap.clear();
            }
        }
    }

    public StyleResourceValue getTheme() {
        return this.mDefaultTheme;
    }

    @Deprecated
    public Map<ResourceType, ResourceValueMap> getProjectResources() {
        return this.mResources.get(ResourceNamespace.RES_AUTO);
    }

    @Deprecated
    public Map<ResourceType, ResourceValueMap> getFrameworkResources() {
        return this.mResources.get(ResourceNamespace.ANDROID);
    }

    public void setLogger(ILayoutLog logger) {
        this.mLogger = logger;
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mDefaultTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        if (theme == null) {
            return;
        }
        List<StyleResourceValue> list = this.mThemes;
        synchronized (list) {
            if (useAsPrimary) {
                this.mThemes.add(0, theme);
            } else {
                this.mThemes.add(theme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllThemes() {
        List<StyleResourceValue> list = this.mThemes;
        synchronized (list) {
            this.mThemes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStyles() {
        List<StyleResourceValue> list = this.mThemes;
        synchronized (list) {
            this.mThemes.clear();
            if (this.mDefaultTheme != null) {
                this.mThemes.add(this.mDefaultTheme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StyleResourceValue> getAllThemes() {
        List<StyleResourceValue> list = this.mThemes;
        synchronized (list) {
            return new ForwardingList<StyleResourceValue>(){

                protected List<StyleResourceValue> delegate() {
                    return ImmutableList.copyOf(ResourceResolver.this.mThemes);
                }

                public void clear() {
                    ResourceResolver.this.clearAllThemes();
                }
            };
        }
    }

    public boolean themeIsChildOfAny(StyleResourceValue childTheme, StyleResourceValue ... parentThemes) {
        if (parentThemes.length == 0) {
            throw new RuntimeException("At least 1 parent must be specified.");
        }
        ImmutableSet parents = ImmutableSet.copyOf((Object[])parentThemes);
        StyleResourceValue theme = childTheme;
        do {
            if ((theme = this.mStyleInheritanceMap.get(theme.asReference())) != null) continue;
            return false;
        } while (!parents.contains(theme));
        return true;
    }

    public StyleItemResourceValue findItemInStyle(StyleResourceValue style, ResourceReference attr) {
        for (int depth = 0; depth < 50; ++depth) {
            StyleItemResourceValue item = style.getItem(attr);
            if (item != null) {
                return item;
            }
            if ((style = this.mStyleInheritanceMap.get(style.asReference())) != null) continue;
            return null;
        }
        if (this.mLogger != null) {
            this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(style)), null, null, null);
        }
        return null;
    }

    private String computeCyclicStyleChain(StyleResourceValue style) {
        StringBuilder result2 = new StringBuilder(100);
        HashSet<StyleResourceValue> seen = new HashSet<StyleResourceValue>();
        for (int depth = 0; depth < 51; ++depth) {
            StyleResourceValue parentStyle;
            if (depth >= 50) {
                result2.append("...");
                break;
            }
            result2.append('\"');
            result2.append(style.getResourceUrl().getQualifiedName());
            result2.append('\"');
            if (!seen.add(style) || (parentStyle = this.mStyleInheritanceMap.get(style.asReference())) == null) break;
            if (style.getParentStyleName() != null) {
                result2.append(" specifies parent ");
            } else {
                result2.append(" implies parent ");
            }
            style = parentStyle;
        }
        return result2.toString();
    }

    public ResourceValue getUnresolvedResource(ResourceReference reference) {
        if (reference.getResourceType() == ResourceType.SAMPLE_DATA) {
            return this.findSampleDataValue(reference);
        }
        if (reference.getResourceType() == ResourceType.AAPT) {
            return ResourceResolver.buildAaptResourceValue(reference);
        }
        return this.findResource(reference);
    }

    private ResourceValue findResource(ResourceReference reference) {
        ResourceValueMap resourceValueMap = this.getResourceValueMap(reference.getNamespace(), reference.getResourceType());
        if (resourceValueMap != null) {
            return (ResourceValue)resourceValueMap.get(reference.getName());
        }
        return null;
    }

    public ResourceValue dereference(ResourceValue value) {
        ResourceReference reference = value.getReference();
        if (reference == null || !ResourceUrl.isValidName((String)reference.getName(), (ResourceType)reference.getResourceType())) {
            return null;
        }
        assert (value.getValue() != null);
        if (value.getValue().startsWith("?")) {
            if (this.mDefaultTheme == null) {
                return null;
            }
            if (reference.getResourceType() != ResourceType.ATTR) {
                return null;
            }
            return this.findItemInTheme(reference);
        }
        if (reference.getResourceType() == ResourceType.AAPT) {
            return ResourceResolver.buildAaptResourceValue(reference);
        }
        if (reference.getResourceType() == ResourceType.SAMPLE_DATA) {
            return this.findSampleDataValue(reference);
        }
        ResourceValue result2 = this.getUnresolvedResource(reference);
        if (result2 != null) {
            return result2;
        }
        if (value.getValue().startsWith("@+id/")) {
            return null;
        }
        if (this.mLogger != null) {
            this.mLogger.warning("resources.resolve", "Couldn't resolve resource " + reference.getResourceUrl(), null, (Object)reference);
        }
        return null;
    }

    public ResourceValue resolveResValue(ResourceValue resValue) {
        if (resValue == null) {
            return null;
        }
        boolean referenceToItself = false;
        for (int depth = 0; depth < 50; ++depth) {
            String value = resValue.getValue();
            if (value == null || resValue instanceof ArrayResourceValue) {
                return resValue;
            }
            ResourceValue resolvedResValue = this.dereference(resValue);
            if (resolvedResValue == null) {
                return resValue;
            }
            if (resolvedResValue.equals(resValue)) {
                referenceToItself = true;
                break;
            }
            resValue = resolvedResValue;
        }
        if (this.mLogger != null) {
            String msg = referenceToItself ? "Infinite cycle trying to resolve '%s': Render may not be accurate." : "Potential infinite cycle trying to resolve '%s': Render may not be accurate.";
            this.mLogger.error("broken", String.format(msg, resValue.getValue()), null, null, null);
        }
        return resValue;
    }

    private ResourceValue findSampleDataValue(ResourceReference value) {
        String name = value.getName();
        return Optional.ofNullable(this.getResourceValueMap(value.getNamespace(), value.getResourceType())).map((Function<ResourceValueMap, ResourceValue> & Serializable)t -> (ResourceValue)t.get(SampleDataManager.getResourceNameFromSampleReference(name))).filter(SampleDataResourceValue.class::isInstance).map(SampleDataResourceValue.class::cast).map(SampleDataResourceValue::getValueAsLines).map((Function<ImmutableList, String> & Serializable)content -> this.mSampleDataManager.getSampleDataLine(name, (ImmutableList<String>)content)).map((Function<String, ResourceValueImpl> & Serializable)lineContent -> new ResourceValueImpl(value.getNamespace(), ResourceType.SAMPLE_DATA, name, lineContent)).orElse(null);
    }

    private void preProcessStyles() {
        if (this.mDefaultTheme == null) {
            return;
        }
        this.mDeviceDefaultParent = null;
        for (Map<ResourceType, ResourceValueMap> mapForNamespace : this.mResources.values()) {
            ResourceValueMap styles = mapForNamespace.get(ResourceType.STYLE);
            if (styles == null) continue;
            for (ResourceValue value : styles.values()) {
                ResourceValue parentStyle;
                if (!(value instanceof StyleResourceValue)) continue;
                StyleResourceValue style = (StyleResourceValue)value;
                ResourceReference parent = style.getParentStyle();
                if (parent != null && (parentStyle = this.getUnresolvedResource(parent)) instanceof StyleResourceValue) {
                    this.mStyleInheritanceMap.put(style.asReference(), (StyleResourceValue)parentStyle);
                    continue;
                }
                if (this.mLogger == null) continue;
                this.mLogger.error("resources.resolve", String.format("Unable to resolve parent style name: %s", style.getParentStyleName()), null, null, null);
            }
        }
        this.clearStyles();
    }

    private void computeReverseStyleInheritance() {
        for (Map.Entry<ResourceReference, StyleResourceValue> entry : this.mStyleInheritanceMap.entrySet()) {
            StyleResourceValue parent = entry.getValue();
            ResourceValue child = this.findResource(entry.getKey());
            assert (child instanceof StyleResourceValue);
            this.mReverseStyleInheritanceMap.put((Object)parent.asReference(), (Object)((StyleResourceValue)child));
        }
    }

    private static ResourceValue buildAaptResourceValue(ResourceReference reference) {
        assert (reference.getResourceType() == ResourceType.AAPT);
        return new ResourceValueImpl(reference, reference.getName().substring("aapt".length()));
    }

    public StyleResourceValue getParent(StyleResourceValue style) {
        return this.mStyleInheritanceMap.get(style.asReference());
    }

    public Collection<StyleResourceValue> getChildren(StyleResourceValue style) {
        if (this.mReverseStyleInheritanceMap.isEmpty()) {
            this.computeReverseStyleInheritance();
        }
        return this.mReverseStyleInheritanceMap.get((Object)style.asReference());
    }

    public boolean styleExtends(StyleResourceValue child, StyleResourceValue ancestor) {
        StyleResourceValue current = child;
        while (current != null) {
            if (current.equals(ancestor)) {
                return true;
            }
            current = this.getParent(current);
        }
        return false;
    }

    public StyleResourceValue getStyle(ResourceReference styleReference) {
        ResourceValue style = styleReference.getResourceType() == ResourceType.ATTR ? this.resolveResValue(this.findItemInTheme(styleReference)) : this.getUnresolvedResource(styleReference);
        if (style == null) {
            return null;
        }
        if (style instanceof StyleResourceValue) {
            return (StyleResourceValue)style;
        }
        if (this.mLogger != null) {
            this.mLogger.error(null, String.format("Style %1$s is not of type STYLE (instead %2$s)", styleReference, style.getResourceType().toString()), null, null, (Object)styleReference);
        }
        return null;
    }

    public boolean isTheme(ResourceValue value, Map<ResourceValue, Boolean> cache) {
        Boolean known;
        if (cache != null && (known = cache.get(value)) != null) {
            return known;
        }
        if (value instanceof StyleResourceValue) {
            StyleResourceValue styleValue = (StyleResourceValue)value;
            for (int depth = 0; depth < 50; ++depth) {
                String name = styleValue.getName();
                if (styleValue.getNamespace() == ResourceNamespace.ANDROID && (name.equals(THEME_NAME) || name.startsWith(THEME_NAME_DOT))) {
                    if (cache != null) {
                        cache.put(value, true);
                    }
                    return true;
                }
                if ((styleValue = this.mStyleInheritanceMap.get(styleValue.asReference())) != null) continue;
                return false;
            }
            if (this.mLogger != null) {
                this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(styleValue)), null, null, null);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceResolver createRecorder(List<ResourceValue> lookupChain) {
        RecordingResourceResolver resolver = new RecordingResourceResolver(lookupChain, this.mResources, this.mDefaultTheme);
        resolver.mLogger = this.mLogger;
        resolver.mStyleInheritanceMap.putAll(this.mStyleInheritanceMap);
        List<StyleResourceValue> originalThemes = this.getAllThemes();
        List<StyleResourceValue> list = resolver.mThemes;
        synchronized (list) {
            resolver.mThemes.addAll(originalThemes);
        }
        return resolver;
    }

    @Deprecated
    public StyleResourceValue getCurrentTheme() {
        return this.getDefaultTheme();
    }

    @Deprecated
    public StyleResourceValue getTheme(String name, boolean frameworkTheme) {
        return this.getStyle(new ResourceReference(ResourceNamespace.fromBoolean((boolean)frameworkTheme), ResourceType.STYLE, name));
    }

    @Deprecated
    public ResourceValue getFrameworkResource(ResourceType resourceType, String resourceName) {
        return this.getResolvedResource(new ResourceReference(ResourceNamespace.ANDROID, resourceType, resourceName));
    }

    @Deprecated
    public ResourceValue getProjectResource(ResourceType resourceType, String resourceName) {
        return this.getResolvedResource(new ResourceReference(ResourceNamespace.RES_AUTO, resourceType, resourceName));
    }

    @Deprecated
    public final ResourceValue findItemInTheme(String attrName, boolean isFrameworkAttr) {
        return this.findItemInTheme(new ResourceReference(ResourceNamespace.fromBoolean((boolean)isFrameworkAttr), ResourceType.ATTR, attrName));
    }

    @Deprecated
    public final ResourceValue findItemInStyle(StyleResourceValue style, String attrName, boolean isFrameworkAttr) {
        return this.findItemInStyle(style, new ResourceReference(ResourceNamespace.fromBoolean((boolean)isFrameworkAttr), ResourceType.ATTR, attrName));
    }

    @Deprecated
    public final StyleResourceValue getStyle(String styleName, boolean isFramework) {
        return this.getStyle(new ResourceReference(ResourceNamespace.fromBoolean((boolean)isFramework), ResourceType.STYLE, styleName));
    }

    private static class RecordingResourceResolver
    extends ResourceResolver {
        private List<ResourceValue> mLookupChain;

        private RecordingResourceResolver(List<ResourceValue> lookupChain, Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, StyleResourceValue theme) {
            super(resources, theme);
            this.mLookupChain = lookupChain;
        }

        @Override
        public ResourceValue resolveResValue(ResourceValue resValue) {
            if (resValue != null) {
                this.mLookupChain.add(resValue);
            }
            return super.resolveResValue(resValue);
        }

        @Override
        public ResourceValue dereference(ResourceValue value) {
            ResourceValue resValue;
            if (!this.mLookupChain.isEmpty() && !this.mLookupChain.get(this.mLookupChain.size() - 1).equals(value)) {
                this.mLookupChain.add(value);
            }
            if ((resValue = super.dereference(value)) != null) {
                this.mLookupChain.add(resValue);
            }
            return resValue;
        }

        @Override
        public StyleItemResourceValue findItemInStyle(StyleResourceValue style, ResourceReference attr) {
            StyleItemResourceValue value = super.findItemInStyle(style, attr);
            if (value != null) {
                this.mLookupChain.add((ResourceValue)value);
            }
            return value;
        }

        public ResourceValue findItemInTheme(ResourceReference attr) {
            ResourceValue value = super.findItemInTheme(attr);
            if (value != null) {
                this.mLookupChain.add(value);
            }
            return value;
        }
    }
}

