/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public final class ResourceTable
extends ForwardingTable<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> {
    private final Table<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> delegate = Tables.newCustomTable(new HashMap(), (Supplier & Serializable)() -> Maps.newEnumMap(ResourceType.class));

    protected Table<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> delegate() {
        return this.delegate;
    }

    public void remove(ResourceItem resourceItem) {
        ResourceNamespace namespace = resourceItem.getNamespace();
        ResourceType type = resourceItem.getType();
        String name = resourceItem.getName();
        ListMultimap multimap = (ListMultimap)this.get(namespace, type);
        if (multimap != null) {
            multimap.remove((Object)name, (Object)resourceItem);
            if (multimap.isEmpty()) {
                this.remove(namespace, type);
            }
        }
    }

    public ListMultimap<String, ResourceItem> getOrPutEmpty(ResourceNamespace namespace, ResourceType resourceType) {
        ListMultimap multimap = (ListMultimap)this.get(namespace, resourceType);
        if (multimap == null) {
            multimap = ArrayListMultimap.create();
            this.put(namespace, resourceType, multimap);
        }
        return multimap;
    }

    public List<ResourceItem> get(ResourceReference reference) {
        ListMultimap multimap = (ListMultimap)this.get(reference.getNamespace(), reference.getResourceType());
        if (multimap == null) {
            return null;
        }
        return multimap.get((Object)reference.getName());
    }
}

