/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.ResourceType;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a*\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"checkForResources", "", "text", "", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "validation", "", "parseChild", "element", "Lorg/w3c/dom/Element;", "parseResourceForInlineResources", "Lcom/android/ide/common/symbols/SymbolTable;", "xmlDocument", "Lorg/w3c/dom/Document;", "sdk-common"})
@JvmName(name="ResourceExtraXmlParser")
public final class ResourceExtraXmlParser {
    @NotNull
    public static final SymbolTable parseResourceForInlineResources(@NotNull Document xmlDocument, @NotNull IdProvider idProvider, boolean validation) {
        Intrinsics.checkNotNullParameter((Object)xmlDocument, (String)"xmlDocument");
        Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
        Element element = xmlDocument.getDocumentElement();
        if (element == null) {
            throw new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        Element root = element;
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        ResourceExtraXmlParser.parseChild(root, builder, idProvider, validation);
        return builder.build();
    }

    public static /* synthetic */ SymbolTable parseResourceForInlineResources$default(Document document, IdProvider idProvider, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ResourceExtraXmlParser.parseResourceForInlineResources(document, idProvider, bl);
    }

    private static final void parseChild(Element element, SymbolTable.Builder builder, IdProvider idProvider, boolean validation) {
        NamedNodeMap attrs = element.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Node attr = attrs.item(i);
            Intrinsics.checkNotNull((Object)attr, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
            ResourceExtraXmlParser.checkForResources(((Attr)attr).getValue(), builder, idProvider, validation);
        }
        for (Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceExtraXmlParser.parseChild((Element)current, builder, idProvider, validation);
        }
    }

    static /* synthetic */ void parseChild$default(Element element, SymbolTable.Builder builder, IdProvider idProvider, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        ResourceExtraXmlParser.parseChild(element, builder, idProvider, bl);
    }

    private static final void checkForResources(String text, SymbolTable.Builder builder, IdProvider idProvider, boolean validation) {
        if (text != null && StringsKt.startsWith$default((String)text, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string = text.substring(5, text.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String name = string;
            Symbol newSymbol = Symbol.Companion.createSymbol$default(Symbol.Companion, ResourceType.ID, name, idProvider, false, validation, 8, null);
            if (!builder.contains(newSymbol)) {
                builder.add(newSymbol);
            }
        }
    }

    static /* synthetic */ void checkForResources$default(String string, SymbolTable.Builder builder, IdProvider idProvider, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        ResourceExtraXmlParser.checkForResources(string, builder, idProvider, bl);
    }
}

