/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.provision;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.instantapp.provision.ProvisionApksInstaller;
import com.android.instantapp.provision.ProvisionException;
import com.android.instantapp.provision.ProvisionListener;
import com.android.instantapp.sdk.InstantAppSdkException;
import com.android.instantapp.sdk.Metadata;
import com.android.instantapp.utils.DeviceUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class ProvisionRunner {
    private final Metadata myMetadata;
    private final Map<IDevice, ProvisionState> myProvisionCache;
    private final ProvisionListener myListener;
    private long shellTimeout = 500L;

    public ProvisionRunner(File instantAppSdk) throws ProvisionException {
        this(instantAppSdk, new ProvisionListener.NullListener());
    }

    public ProvisionRunner(File instantAppSdk, ProvisionListener listener) throws ProvisionException {
        Metadata metadata;
        if (!FileInterceptorsDeclaration.intercept_exists((File)instantAppSdk, (String)"com.android.instantapp.provision.ProvisionRunner") || !FileInterceptorsDeclaration.intercept_isDirectory((File)instantAppSdk, (String)"com.android.instantapp.provision.ProvisionRunner")) {
            throw new ProvisionException(ProvisionException.ErrorType.INVALID_SDK, "Path " + instantAppSdk.getAbsolutePath() + " is not valid.");
        }
        try {
            metadata = Metadata.getInstance(instantAppSdk);
        }
        catch (InstantAppSdkException e) {
            throw new ProvisionException(ProvisionException.ErrorType.INVALID_SDK, (Throwable)e);
        }
        this.myMetadata = metadata;
        this.myListener = listener;
        this.myProvisionCache = new HashMap<IDevice, ProvisionState>();
    }

    public void runProvision(IDevice device) throws ProvisionException {
        this.runProvision(device, 2);
    }

    public void runProvision(IDevice device, int retries) throws ProvisionException {
        boolean success = false;
        if (!this.myProvisionCache.containsKey(device)) {
            this.myProvisionCache.put(device, new ProvisionState());
        }
        while (!success) {
            try {
                this.runProvision(device, this.myProvisionCache.get(device));
                success = true;
            }
            catch (ProvisionException e) {
                if (retries > 0 && this.prepareRetry(e.getErrorType())) {
                    this.myListener.logMessage("Retrying to provision", e);
                    --retries;
                    try {
                        Thread.sleep(this.shellTimeout);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.myListener.printMessage("Provision failed: " + e.getMessage());
                this.myListener.logMessage("Provision failed", e);
                throw e;
            }
        }
    }

    private boolean prepareRetry(ProvisionException.ErrorType errorType) {
        switch (errorType) {
            case ARCH_NOT_SUPPORTED: 
            case DEVICE_NOT_SUPPORTED: 
            case NO_GOOGLE_ACCOUNT: 
            case INVALID_SDK: 
            case UNINSTALL_FAILED: 
            case CANCELLED: {
                return false;
            }
            case SHELL_TIMEOUT: {
                this.shellTimeout *= 2L;
                return true;
            }
            case ADB_FAILURE: 
            case INSTALL_FAILED: 
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    private void runProvision(IDevice device, ProvisionState provisionState) throws ProvisionException {
        this.myListener.setProgress(0.0);
        this.myListener.logMessage("Starting provision. Cached state: " + provisionState, null);
        this.myListener.printMessage("Starting provision");
        String buildType = DeviceUtils.getOsBuildType(device);
        int apiLevel = device.getVersion().getApiLevel();
        if (!this.myListener.isCancelled() && provisionState.lastSucceeded == ProvisionState.Step.NONE) {
            this.myListener.logMessage("Checking API level", null);
            if (DeviceUtils.isPostO(device)) {
                provisionState.lastSucceeded = ProvisionState.Step.FINISHED;
                this.myListener.logMessage("Device is post O", null);
                this.myListener.printMessage("Post O device, no provision needed.");
                this.myListener.setProgress(1.0);
                return;
            }
            provisionState.lastSucceeded = ProvisionState.Step.CHECK_POSTO;
        }
        this.myListener.setProgress(0.05);
        this.myListener.printMessage("Checking device");
        if (!this.myListener.isCancelled() && provisionState.lastSucceeded == ProvisionState.Step.CHECK_POSTO) {
            this.myListener.logMessage("Checking device architecture", null);
            provisionState.arch = this.getPreferredDeviceArchitecture(device);
            this.myListener.logMessage("Device architecture: " + provisionState.arch, null);
            provisionState.lastSucceeded = ProvisionState.Step.CHECK_ARCH;
        }
        this.myListener.setProgress(0.1);
        if (!this.myListener.isCancelled() && provisionState.lastSucceeded == ProvisionState.Step.CHECK_ARCH) {
            this.myListener.logMessage("Checking device information.", null);
            provisionState.deviceInfo = this.getDeviceInfo(device);
            this.myListener.logMessage("Device information: " + provisionState.deviceInfo, null);
            provisionState.lastSucceeded = ProvisionState.Step.CHECK_DEVICE;
        }
        this.myListener.setProgress(0.15);
        if (!this.myListener.isCancelled() && provisionState.lastSucceeded == ProvisionState.Step.CHECK_DEVICE) {
            this.myListener.logMessage("Checking device information.", null);
            this.checkLoggedInGoogleAccount(device);
            this.myListener.logMessage("Logged in Google account", null);
            provisionState.lastSucceeded = ProvisionState.Step.CHECK_ACCOUNT;
        }
        this.myListener.setProgress(0.2);
        if (!this.myListener.isCancelled() && provisionState.lastSucceeded == ProvisionState.Step.CHECK_ACCOUNT) {
            assert (provisionState.deviceInfo != null);
            this.myListener.printMessage("Overriding GServices");
            this.myListener.logMessage("Overriding GServices", null);
            if (buildType != null && buildType.compareTo("release-keys") != 0) {
                this.overrideGServices(device, provisionState.deviceInfo, provisionState);
                this.myListener.logMessage("GServices overrides complete", null);
            } else {
                this.checkInGooglePlay(device);
                this.myListener.logMessage("Device is release-keys", null);
            }
            provisionState.lastSucceeded = ProvisionState.Step.GSERVICES;
        }
        this.myListener.setProgress(0.4);
        if (!this.myListener.isCancelled() && provisionState.lastSucceeded == ProvisionState.Step.GSERVICES) {
            assert (provisionState.arch != null);
            this.myListener.printMessage("Installing apks");
            this.myListener.logMessage("Installing apks", null);
            this.installApks(device, provisionState.arch, apiLevel, provisionState);
            this.myListener.logMessage("Apks installed successfully", null);
            provisionState.lastSucceeded = ProvisionState.Step.INSTALL;
        }
        this.myListener.setProgress(0.95);
        if (!this.myListener.isCancelled() && provisionState.lastSucceeded == ProvisionState.Step.INSTALL) {
            this.myListener.logMessage("Setting flags", null);
            if (buildType != null && buildType.compareTo("release-keys") != 0) {
                this.setFlags(device);
            }
            provisionState.lastSucceeded = ProvisionState.Step.FINISHED;
        }
        if (this.myListener.isCancelled()) {
            throw new ProvisionException(ProvisionException.ErrorType.CANCELLED);
        }
        this.myListener.printMessage("Provision completed");
        this.myListener.logMessage("Provision completed", null);
        this.myListener.setProgress(1.0);
    }

    public void clearCache() {
        this.myProvisionCache.clear();
    }

    private Metadata.Arch getPreferredDeviceArchitecture(IDevice device) throws ProvisionException {
        List architectures = device.getAbis();
        for (String arch : architectures) {
            if (!this.myMetadata.isSupportedArch(arch)) continue;
            return Metadata.Arch.create(arch);
        }
        throw new ProvisionException(ProvisionException.ErrorType.ARCH_NOT_SUPPORTED, "Detected architectures are: " + architectures);
    }

    private Metadata.Device getDeviceInfo(IDevice device) throws ProvisionException {
        String manufacturer = device.getProperty("ro.product.manufacturer");
        String androidDevice = device.getProperty("ro.product.device");
        int apiLevel = device.getVersion().getApiLevel();
        String product = device.getProperty("ro.product.name");
        String hardware = device.getProperty("ro.hardware");
        Metadata.Device deviceInfo = new Metadata.Device(manufacturer, androidDevice, Collections.singleton(apiLevel), product, hardware);
        return deviceInfo;
    }

    private void checkLoggedInGoogleAccount(IDevice device) throws ProvisionException {
        String output = this.executeShellCommand(device, "dumpsys account", false);
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)output);
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("Account {") || !line.contains("type=com.google")) continue;
            return;
        }
        throw new ProvisionException(ProvisionException.ErrorType.NO_GOOGLE_ACCOUNT);
    }

    private void installApks(IDevice device, Metadata.Arch arch, int apiLevel, ProvisionState provisionState) throws ProvisionException {
        ProvisionApksInstaller apksInstaller = new ProvisionApksInstaller(this.myMetadata.getApks(arch, apiLevel));
        apksInstaller.installAll(device, provisionState, this.myListener);
    }

    private void checkInGooglePlay(IDevice device) throws ProvisionException {
        this.executeShellCommand(device, "am broadcast -a android.server.checkin.CHECKIN", false);
        this.executeShellCommand(device, "am broadcast -a com.google.android.finsky.action.CONTENT_FILTERS_CHANGED", false);
    }

    private void overrideGServices(IDevice device, Metadata.Device deviceInfo, ProvisionState provisionState) throws ProvisionException {
        int currentGService = 0;
        for (Metadata.GServicesOverride gServicesOverride : this.myMetadata.getGServicesOverrides(deviceInfo)) {
            if (currentGService > provisionState.lastGService) {
                this.executeShellCommand(device, "CLASSPATH=/system/framework/am.jar su root app_process /system/bin com.android.commands.am.Am broadcast -a com.google.gservices.intent.action.GSERVICES_OVERRIDE -e " + gServicesOverride.getKey() + " " + gServicesOverride.getValue(), true);
                provisionState.lastGService = currentGService;
            }
            ++currentGService;
        }
        this.executeShellCommand(device, "am broadcast -a com.google.android.finsky.action.CONTENT_FILTERS_CHANGED", false);
        this.executeShellCommand(device, "am force-stop com.google.android.gms", false);
    }

    private void setFlags(IDevice device) throws ProvisionException {
        this.executeShellCommand(device, "pm grant com.google.android.instantapps.devman android.permission.READ_EXTERNAL_STORAGE", false);
        this.executeShellCommand(device, "CLASSPATH=/system/framework/am.jar su root app_process /system/bin com.android.commands.am.Am broadcast -a com.google.android.gms.phenotype.UPDATE", true);
        this.executeShellCommand(device, "CLASSPATH=/system/framework/pm.jar su root app_process /system/bin com.android.commands.pm.Pm enable com.google.android.instantapps.supervisor/.UrlHandler", true);
        this.executeShellCommand(device, "am broadcast -a com.google.android.finsky.action.CONTENT_FILTERS_CHANGED", false);
    }

    private String executeShellCommand(IDevice device, String command, boolean rootRequired) throws ProvisionException {
        return ProvisionRunner.executeShellCommand(device, command, rootRequired, this.shellTimeout);
    }

    static String executeShellCommand(IDevice device, String command, boolean rootRequired, long timeout) throws ProvisionException {
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        try {
            if (rootRequired) {
                device.root();
            }
            device.executeShellCommand(command, (IShellOutputReceiver)receiver);
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new ProvisionException(ProvisionException.ErrorType.SHELL_TIMEOUT, "Failed executing command \"" + command + "\".");
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException | InterruptedException e) {
            throw new ProvisionException(e instanceof InterruptedException ? ProvisionException.ErrorType.UNKNOWN : ProvisionException.ErrorType.ADB_FAILURE, "Failed executing command \"" + command + "\".", e);
        }
        return receiver.getOutput();
    }

    @VisibleForTesting
    Metadata getMetadata() {
        return this.myMetadata;
    }

    @VisibleForTesting
    Map<IDevice, ProvisionState> getCache() {
        return this.myProvisionCache;
    }

    @VisibleForTesting
    ProvisionListener getListener() {
        return this.myListener;
    }

    static class ProvisionState {
        Step lastSucceeded = Step.NONE;
        Metadata.Arch arch = null;
        Metadata.Device deviceInfo = null;
        int lastInstalled = -1;
        int lastGService = -1;

        ProvisionState() {
        }

        public String toString() {
            return "{lastSucceeded: " + this.lastSucceeded + ", arch: " + this.arch + ", deviceInfo: " + this.deviceInfo + ", lastInstalled: " + this.lastInstalled + ", lastGService: " + this.lastGService + "}";
        }

        static enum Step {
            NONE,
            CHECK_POSTO,
            CHECK_ARCH,
            CHECK_DEVICE,
            CHECK_ACCOUNT,
            GSERVICES,
            INSTALL,
            FINISHED;

        }
    }
}

