/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.sdk;

import com.android.instantapp.sdk.InstantAppSdkException;
import com.android.instantapp.sdk.Metadata;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import wireless.android.instantapps.sdk.ManifestOuterClass;

class ManifestProtoParser {
    private final File myManifestProtoFile;
    private final File myApksDirectory;

    ManifestProtoParser(File instantAppSdk) throws InstantAppSdkException {
        this.myManifestProtoFile = new File(instantAppSdk, "manifest.pb");
        if (!FileInterceptorsDeclaration.intercept_exists((File)this.myManifestProtoFile, (String)"com.android.instantapp.sdk.ManifestProtoParser") || !FileInterceptorsDeclaration.intercept_isFile((File)this.myManifestProtoFile, (String)"com.android.instantapp.sdk.ManifestProtoParser")) {
            throw new InstantAppSdkException("Manifest file " + this.myManifestProtoFile.getAbsolutePath() + " does not exist.");
        }
        this.myApksDirectory = new File(new File(instantAppSdk, "tools"), "apks");
        if (!FileInterceptorsDeclaration.intercept_exists((File)this.myApksDirectory, (String)"com.android.instantapp.sdk.ManifestProtoParser") || !FileInterceptorsDeclaration.intercept_isDirectory((File)this.myApksDirectory, (String)"com.android.instantapp.sdk.ManifestProtoParser")) {
            throw new InstantAppSdkException("Apks folder " + this.myApksDirectory.getAbsolutePath() + " does not exist.");
        }
    }

    public Metadata getMetadata() throws InstantAppSdkException {
        ManifestOuterClass.Manifest manifest;
        try {
            File file = this.myManifestProtoFile;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file, (String)"com.android.instantapp.sdk.ManifestProtoParser");
            FileInputStream inputStream = fileInputStream;
            manifest = ManifestOuterClass.Manifest.parseFrom(inputStream);
        }
        catch (IOException e) {
            throw new InstantAppSdkException("Manifest file is corrupted.", e);
        }
        return this.convertManifest(manifest);
    }

    private Metadata convertManifest(ManifestOuterClass.Manifest manifest) {
        return new Metadata(manifest.getVersionCode(), manifest.getVersionName(), this.convertApks(manifest.getApksList()), ManifestProtoParser.convertDevices(manifest.getEnabledDevicesList()), ManifestProtoParser.convertGServicesOverrides(manifest.getGservicesOverridesList()), ManifestProtoParser.convertLibraryCompatibility(manifest.getLibraryCompatibility()));
    }

    private static List<Metadata.GServicesOverride> convertGServicesOverrides(List<ManifestOuterClass.GservicesOverride> gservicesOverrides) {
        return Lists.transform(gservicesOverrides, ManifestProtoParser::convertGServicesOverride);
    }

    private static Metadata.GServicesOverride convertGServicesOverride(ManifestOuterClass.GservicesOverride gservicesOverride) {
        return new Metadata.GServicesOverride(ManifestProtoParser.convertDevices(gservicesOverride.getDeviceList()), gservicesOverride.getKey(), gservicesOverride.getValue());
    }

    private static Set<Metadata.Device> convertDevices(List<ManifestOuterClass.Device> devices) {
        return devices.stream().map(ManifestProtoParser::convertDevice).collect(Collectors.toSet());
    }

    private static Metadata.Device convertDevice(ManifestOuterClass.Device device) {
        return new Metadata.Device(device.getManufacturer(), device.getAndroidDevice(), Sets.newHashSet(device.getSdkIntList()), device.getProduct(), device.getHardware());
    }

    private Map<Metadata.Arch, List<Metadata.ApkInfo>> convertApks(List<ManifestOuterClass.ApkVersionInfo> apkVersionInfoList) {
        EnumMap<Metadata.Arch, List<Metadata.ApkInfo>> apks = new EnumMap<Metadata.Arch, List<Metadata.ApkInfo>>(Metadata.Arch.class);
        for (ManifestOuterClass.ApkVersionInfo apkVersionInfo : apkVersionInfoList) {
            Metadata.Arch arch = ManifestProtoParser.convertArch(apkVersionInfo.getArch());
            if (!apks.containsKey((Object)arch)) {
                apks.put(arch, new LinkedList());
            }
            ((List)apks.get((Object)arch)).add(this.convertApkVersionInfo(apkVersionInfo));
        }
        return apks;
    }

    private Metadata.ApkInfo convertApkVersionInfo(ManifestOuterClass.ApkVersionInfo apkVersionInfo) {
        return new Metadata.ApkInfo(apkVersionInfo.getPackageName(), new File(this.myApksDirectory, apkVersionInfo.getPath()), ManifestProtoParser.convertArch(apkVersionInfo.getArch()), Sets.newLinkedHashSet(apkVersionInfo.getSdkIntList()), apkVersionInfo.getVersionCode());
    }

    private static Metadata.Arch convertArch(ManifestOuterClass.Arch arch) {
        switch (arch) {
            case ALL: {
                return Metadata.Arch.DEFAULT;
            }
            case UNRECOGNIZED: {
                return Metadata.Arch.UNKNOWN;
            }
        }
        return Metadata.Arch.valueOf(arch.name());
    }

    private static Metadata.LibraryCompatibility convertLibraryCompatibility(ManifestOuterClass.LibraryCompatibility libraryCompatibility) {
        return new Metadata.LibraryCompatibility(libraryCompatibility.getAiaCompatApiMinVersion());
    }
}

