/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.shrinker.obfuscation;

import com.android.build.shrinker.ResourceShrinkerModel;
import com.android.build.shrinker.obfuscation.ObfuscatedClasses;
import com.android.build.shrinker.obfuscation.ObfuscationMappingsRecorder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/shrinker/obfuscation/ProguardMappingsRecorder;", "Lcom/android/build/shrinker/obfuscation/ObfuscationMappingsRecorder;", "mappingsFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "extractClassMapping", "Lkotlin/Pair;", "", "line", "extractMethodMapping", "extractObfuscatedResourceClasses", "Lcom/android/build/shrinker/obfuscation/ObfuscatedClasses;", "extractObfuscatedResourceClasses$shrinker", "isClassMapping", "", "isMethodMapping", "recordObfuscationMappings", "", "model", "Lcom/android/build/shrinker/ResourceShrinkerModel;", "shrinker"})
@SourceDebugExtension(value={"SMAP\nProguardMappingsRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProguardMappingsRecorder.kt\ncom/android/build/shrinker/obfuscation/ProguardMappingsRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1855#2,2:75\n*S KotlinDebug\n*F\n+ 1 ProguardMappingsRecorder.kt\ncom/android/build/shrinker/obfuscation/ProguardMappingsRecorder\n*L\n46#1:75,2\n*E\n"})
public final class ProguardMappingsRecorder
implements ObfuscationMappingsRecorder {
    @NotNull
    private final Path mappingsFile;

    public ProguardMappingsRecorder(@NotNull Path mappingsFile) {
        Intrinsics.checkNotNullParameter((Object)mappingsFile, (String)"mappingsFile");
        this.mappingsFile = mappingsFile;
    }

    @Override
    public void recordObfuscationMappings(@NotNull ResourceShrinkerModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.setObfuscatedClasses(this.extractObfuscatedResourceClasses$shrinker());
    }

    @NotNull
    public final ObfuscatedClasses extractObfuscatedResourceClasses$shrinker() {
        ObfuscatedClasses.Builder builder = new ObfuscatedClasses.Builder();
        List<String> list = Files.readAllLines(this.mappingsFile, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(mappingsFile, StandardCharsets.UTF_8)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            if (this.isMethodMapping(line)) {
                builder.addMethodMapping(this.extractMethodMapping(line));
                continue;
            }
            if (!this.isClassMapping(line)) continue;
            builder.addClassMapping(this.extractClassMapping(line));
        }
        return builder.build();
    }

    private final boolean isClassMapping(String line) {
        return StringsKt.contains$default((CharSequence)line, (CharSequence)"->", (boolean)false, (int)2, null);
    }

    private final boolean isMethodMapping(String line) {
        return (StringsKt.startsWith$default((String)line, (String)" ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"\t", (boolean)false, (int)2, null)) && StringsKt.contains$default((CharSequence)line, (CharSequence)"->", (boolean)false, (int)2, null);
    }

    private final Pair<String, String> extractClassMapping(String line) {
        Object[] objectArray = new String[]{"->"};
        List mapping = StringsKt.split$default((CharSequence)line, (String[])objectArray, (boolean)false, (int)2, (int)2, null);
        objectArray = new char[3];
        objectArray[0] = (String)32;
        objectArray[1] = (String)9;
        objectArray[2] = (String)58;
        return new Pair((Object)((Object)StringsKt.trim((CharSequence)((String)mapping.get(0)))).toString(), (Object)StringsKt.trim((String)((String)mapping.get(1)), (char[])objectArray));
    }

    private final Pair<String, String> extractMethodMapping(String line) {
        String[] stringArray = new String[]{"->"};
        List mapping = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String originalMethod = StringsKt.substringAfter$default((String)StringsKt.substringBeforeLast$default((String)((Object)StringsKt.trim((CharSequence)((String)mapping.get(0)))).toString(), (char)'(', null, (int)2, null), (char)' ', null, (int)2, null);
        String obfuscatedMethod = ((Object)StringsKt.trim((CharSequence)((String)mapping.get(1)))).toString();
        return new Pair((Object)originalMethod, (Object)obfuscatedMethod);
    }
}

