/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByCharRt;
import com.intellij.diff.comparison.ByLineRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.util.IntPair;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class ChangeCorrector {
    private final int myLength1;
    private final int myLength2;
    @NotNull
    private final FairDiffIterable myChanges;
    @NotNull
    protected final CancellationChecker myIndicator;
    @NotNull
    protected final DiffIterableUtil.ChangeBuilder myBuilder;

    ChangeCorrector(int length1, int length2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
        if (changes == null) {
            ChangeCorrector.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            ChangeCorrector.$$$reportNull$$$0(1);
        }
        this.myLength1 = length1;
        this.myLength2 = length2;
        this.myChanges = changes;
        this.myIndicator = indicator;
        this.myBuilder = new DiffIterableUtil.ChangeBuilder(length1, length2);
    }

    @NotNull
    public FairDiffIterable build() {
        this.execute();
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(this.myBuilder.finish());
        if (fairDiffIterable == null) {
            ChangeCorrector.$$$reportNull$$$0(2);
        }
        return fairDiffIterable;
    }

    protected void execute() {
        int last1 = 0;
        int last2 = 0;
        for (Range ch : this.myChanges.iterateUnchanged()) {
            int count2 = ch.end1 - ch.start1;
            for (int i2 = 0; i2 < count2; ++i2) {
                IntPair range1 = this.getOriginalRange1(ch.start1 + i2);
                IntPair range2 = this.getOriginalRange2(ch.start2 + i2);
                int start1 = range1.first;
                int start2 = range2.first;
                int end1 = range1.second;
                int end2 = range2.second;
                this.matchGap(last1, start1, last2, start2);
                this.myBuilder.markEqual(start1, start2, end1, end2);
                last1 = end1;
                last2 = end2;
            }
        }
        this.matchGap(last1, this.myLength1, last2, this.myLength2);
    }

    protected abstract void matchGap(int var1, int var2, int var3, int var4);

    protected abstract IntPair getOriginalRange1(int var1);

    protected abstract IntPair getOriginalRange2(int var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ChangeCorrector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ChangeCorrector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class SmartLineChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final IntList myIndexes1;
        @NotNull
        private final IntList myIndexes2;
        @NotNull
        private final List<? extends ByLineRt.Line> myLines1;
        @NotNull
        private final List<? extends ByLineRt.Line> myLines2;

        public SmartLineChangeCorrector(@NotNull IntList indexes1, @NotNull IntList indexes2, @NotNull List<? extends ByLineRt.Line> lines1, @NotNull List<? extends ByLineRt.Line> lines2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            if (indexes1 == null) {
                SmartLineChangeCorrector.$$$reportNull$$$0(0);
            }
            if (indexes2 == null) {
                SmartLineChangeCorrector.$$$reportNull$$$0(1);
            }
            if (lines1 == null) {
                SmartLineChangeCorrector.$$$reportNull$$$0(2);
            }
            if (lines2 == null) {
                SmartLineChangeCorrector.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                SmartLineChangeCorrector.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                SmartLineChangeCorrector.$$$reportNull$$$0(5);
            }
            super(lines1.size(), lines2.size(), changes, indicator);
            this.myIndexes1 = indexes1;
            this.myIndexes2 = indexes2;
            this.myLines1 = lines1;
            this.myLines2 = lines2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            Range expand = TrimUtil.expand(this.myLines1, this.myLines2, start1, start2, end1, end2);
            List<? extends ByLineRt.Line> inner1 = this.myLines1.subList(expand.start1, expand.end1);
            List<? extends ByLineRt.Line> inner2 = this.myLines2.subList(expand.start2, expand.end2);
            FairDiffIterable innerChanges = DiffIterableUtil.diff(inner1, inner2, this.myIndicator);
            this.myBuilder.markEqual(start1, start2, expand.start1, expand.start2);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(expand.start1 + chunk.start1, expand.start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
            this.myBuilder.markEqual(expand.end1, expand.end2, end1, end2);
        }

        @Override
        protected IntPair getOriginalRange1(int index2) {
            int offset = this.myIndexes1.getInt(index2);
            return new IntPair(offset, offset + 1);
        }

        @Override
        protected IntPair getOriginalRange2(int index2) {
            int offset = this.myIndexes2.getInt(index2);
            return new IntPair(offset, offset + 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexes1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexes2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lines1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lines2";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DefaultCharChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final ByCharRt.CodePointsOffsets myCodePoints1;
        @NotNull
        private final ByCharRt.CodePointsOffsets myCodePoints2;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public DefaultCharChangeCorrector(@NotNull ByCharRt.CodePointsOffsets codePoints1, @NotNull ByCharRt.CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            if (codePoints1 == null) {
                DefaultCharChangeCorrector.$$$reportNull$$$0(0);
            }
            if (codePoints2 == null) {
                DefaultCharChangeCorrector.$$$reportNull$$$0(1);
            }
            if (text1 == null) {
                DefaultCharChangeCorrector.$$$reportNull$$$0(2);
            }
            if (text2 == null) {
                DefaultCharChangeCorrector.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                DefaultCharChangeCorrector.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                DefaultCharChangeCorrector.$$$reportNull$$$0(5);
            }
            super(text1.length(), text2.length(), changes, indicator);
            this.myCodePoints1 = codePoints1;
            this.myCodePoints2 = codePoints2;
            this.myText1 = text1;
            this.myText2 = text2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            CharSequence inner1 = this.myText1.subSequence(start1, end1);
            CharSequence inner2 = this.myText2.subSequence(start2, end2);
            FairDiffIterable innerChanges = ByCharRt.compare(inner1, inner2, this.myIndicator);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + chunk.start1, start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
        }

        @Override
        protected IntPair getOriginalRange1(int index2) {
            int startOffset = this.myCodePoints1.charOffset(index2);
            int endOffset = this.myCodePoints1.charOffsetAfter(index2);
            return new IntPair(startOffset, endOffset);
        }

        @Override
        protected IntPair getOriginalRange2(int index2) {
            int startOffset = this.myCodePoints2.charOffset(index2);
            int endOffset = this.myCodePoints2.charOffsetAfter(index2);
            return new IntPair(startOffset, endOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "codePoints1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "codePoints2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text2";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

