/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.ResolveScopeManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001b\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eH\u0007\u00a2\u0006\u0002\u0010\u001f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"DEFAULT_CLASSLOADER_CONFIGURATION", "Lcom/intellij/util/lang/UrlClassLoader$Builder;", "Lorg/jetbrains/annotations/NotNull;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog$annotations", "()V", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "configureUsingIdeaClassloader", "Ljava/lang/ClassLoader;", "classPath", "", "Ljava/nio/file/Path;", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "createModuleContentBasedScope", "Lcom/intellij/ide/plugins/cl/ResolveScopeManager;", "createModuleResolveScopeManager", "createPluginDependencyAndContentBasedScope", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "createScopeWithExtraPackage", "customPackage", "", "getContentPackagePrefixes", "getDependencyPackagePrefixes", "sortDependenciesInPlace", "", "dependencies", "", "([Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "intellij.platform.core.impl"})
public final class ClassLoaderConfiguratorKt {
    @NotNull
    private static final UrlClassLoader.Builder DEFAULT_CLASSLOADER_CONFIGURATION;

    private static final Logger getLog() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#com.intell\u2026e.plugins.PluginManager\")");
        return logger;
    }

    private static /* synthetic */ void getLog$annotations() {
    }

    private static final ResolveScopeManager createModuleResolveScopeManager() {
        return new ResolveScopeManager(){

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                return !StringsKt.startsWith$default((String)name2, (String)packagePrefix, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name2, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) ? "" : null;
            }
        };
    }

    private static final ResolveScopeManager createScopeWithExtraPackage(String customPackage) {
        return new ResolveScopeManager(customPackage){
            final /* synthetic */ String $customPackage;
            {
                this.$customPackage = $customPackage;
            }

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (!(force || StringsKt.startsWith$default((String)name2, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)this.$customPackage, (boolean)false, (int)2, null))) {
                    return "";
                }
                return null;
            }
        };
    }

    private static final ResolveScopeManager createPluginDependencyAndContentBasedScope(IdeaPluginDescriptorImpl descriptor2, PluginSet pluginSet) {
        List<String> contentPackagePrefixes = ClassLoaderConfiguratorKt.getContentPackagePrefixes(descriptor2);
        List<String> dependencyPackagePrefixes = ClassLoaderConfiguratorKt.getDependencyPackagePrefixes(descriptor2, pluginSet);
        if (contentPackagePrefixes.isEmpty() && dependencyPackagePrefixes.isEmpty()) {
            return null;
        }
        String string2 = descriptor2.getPluginId().getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.pluginId.idString");
        String pluginId = string2;
        return new ResolveScopeManager(contentPackagePrefixes, pluginId, dependencyPackagePrefixes){
            final /* synthetic */ List<String> $contentPackagePrefixes;
            final /* synthetic */ String $pluginId;
            final /* synthetic */ List<String> $dependencyPackagePrefixes;
            {
                this.$contentPackagePrefixes = $contentPackagePrefixes;
                this.$pluginId = $pluginId;
                this.$dependencyPackagePrefixes = $dependencyPackagePrefixes;
            }

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (force) {
                    return null;
                }
                for (String prefix : this.$contentPackagePrefixes) {
                    if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "Class " + name2 + " must not be requested from main classloader of " + this.$pluginId + " plugin";
                }
                for (String prefix : this.$dependencyPackagePrefixes) {
                    if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "";
                }
                return null;
            }
        };
    }

    private static final List<String> getContentPackagePrefixes(IdeaPluginDescriptorImpl descriptor2) {
        List<PluginContentDescriptor.ModuleItem> modules = descriptor2.content.modules;
        if (modules.isEmpty()) {
            List<String> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList()");
            return list;
        }
        int n = 0;
        int n2 = modules.size();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            IdeaPluginDescriptorImpl module = modules.get(n3).requireDescriptor();
            String string2 = module.packagePrefix;
            if (string2 == null) {
                throw new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            stringArray[n3] = string2 + '.';
        }
        String[] result2 = stringArray;
        List<String> list = Arrays.asList(Arrays.copyOf(result2, result2.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(*result)");
        return list;
    }

    private static final List<String> getDependencyPackagePrefixes(IdeaPluginDescriptorImpl descriptor2, PluginSet pluginSet) {
        List<ModuleDependenciesDescriptor.ModuleReference> dependencies = descriptor2.dependencies.modules;
        if (dependencies.isEmpty()) {
            List<String> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList()");
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(dependencies.size());
        for (ModuleDependenciesDescriptor.ModuleReference item : dependencies) {
            String packagePrefix;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = pluginSet.findEnabledModule(item.name);
            if (ideaPluginDescriptorImpl == null || (packagePrefix = ideaPluginDescriptorImpl.packagePrefix) == null || Intrinsics.areEqual((Object)item.name, (Object)"intellij.platform.commercial.verifier")) continue;
            result2.add(packagePrefix + '.');
        }
        return result2;
    }

    private static final ResolveScopeManager createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor2) {
        ArrayList<String> packagePrefixes = new ArrayList<String>(descriptor2.content.modules.size());
        for (PluginContentDescriptor.ModuleItem item : descriptor2.content.modules) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = item.requireDescriptor().packagePrefix;
            Intrinsics.checkNotNull((Object)string2);
            packagePrefixes.add(stringBuilder.append(string2).append('.').toString());
        }
        return new ResolveScopeManager(packagePrefixes){
            final /* synthetic */ ArrayList<String> $packagePrefixes;
            {
                this.$packagePrefixes = $packagePrefixes;
            }

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (StringsKt.startsWith$default((String)name2, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null)) {
                    return null;
                }
                for (String prefix : this.$packagePrefixes) {
                    Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
                    if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return null;
                }
                return "";
            }
        };
    }

    private static final ClassLoader configureUsingIdeaClassloader(List<? extends Path> classPath, IdeaPluginDescriptorImpl descriptor2) {
        ClassLoaderConfiguratorKt.getLog().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
        ClassLoader loader = ClassLoaderConfigurator.class.getClassLoader();
        try {
            MethodHandle addFiles = MethodHandles.lookup().findVirtual(loader.getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class));
            addFiles.invoke(loader, classPath);
            Intrinsics.checkNotNullExpressionValue((Object)loader, (String)"loader");
            return loader;
        }
        catch (Throwable e) {
            throw new IllegalStateException("An unexpected core classloader: " + loader, e);
        }
    }

    @VisibleForTesting
    public static final void sortDependenciesInPlace(@NotNull IdeaPluginDescriptorImpl[] dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (dependencies.length <= 1) {
            return;
        }
        Arrays.sort(dependencies, ClassLoaderConfiguratorKt::sortDependenciesInPlace$lambda$0);
    }

    private static final int sortDependenciesInPlace$getWeight(IdeaPluginDescriptorImpl module) {
        return module.moduleName == null ? 1 : 0;
    }

    private static final int sortDependenciesInPlace$lambda$0(IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
        Intrinsics.checkNotNullExpressionValue((Object)o1, (String)"o1");
        int n = ClassLoaderConfiguratorKt.sortDependenciesInPlace$getWeight(o1);
        Intrinsics.checkNotNullExpressionValue((Object)o2, (String)"o2");
        return n - ClassLoaderConfiguratorKt.sortDependenciesInPlace$getWeight(o2);
    }

    public static final /* synthetic */ Logger access$getLog() {
        return ClassLoaderConfiguratorKt.getLog();
    }

    public static final /* synthetic */ UrlClassLoader.Builder access$getDEFAULT_CLASSLOADER_CONFIGURATION$p() {
        return DEFAULT_CLASSLOADER_CONFIGURATION;
    }

    public static final /* synthetic */ ClassLoader access$configureUsingIdeaClassloader(List classPath, IdeaPluginDescriptorImpl descriptor2) {
        return ClassLoaderConfiguratorKt.configureUsingIdeaClassloader(classPath, descriptor2);
    }

    public static final /* synthetic */ ResolveScopeManager access$createModuleResolveScopeManager() {
        return ClassLoaderConfiguratorKt.createModuleResolveScopeManager();
    }

    public static final /* synthetic */ ResolveScopeManager access$createPluginDependencyAndContentBasedScope(IdeaPluginDescriptorImpl descriptor2, PluginSet pluginSet) {
        return ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(descriptor2, pluginSet);
    }

    public static final /* synthetic */ ResolveScopeManager access$createScopeWithExtraPackage(String customPackage) {
        return ClassLoaderConfiguratorKt.createScopeWithExtraPackage(customPackage);
    }

    public static final /* synthetic */ ResolveScopeManager access$createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor2) {
        return ClassLoaderConfiguratorKt.createModuleContentBasedScope(descriptor2);
    }

    static {
        UrlClassLoader.Builder builder = UrlClassLoader.build().useCache();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"build().useCache()");
        DEFAULT_CLASSLOADER_CONFIGURATION = builder;
    }
}

