/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.ModuleGraph;
import com.intellij.ide.plugins.ModuleGraphBase;
import com.intellij.ide.plugins.ModuleGraphKt;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.PluginSetBuilder;
import com.intellij.ide.plugins.PluginSetBuilderKt;
import com.intellij.ide.plugins.SortedModuleGraph;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.Java11Shim;
import com.intellij.util.graph.DFSTBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010\u001f\u001a\u00020\u00192\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\"0!J\u0018\u0010#\u001a\u00020\u00002\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010%J\u0016\u0010&\u001a\u00020'2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0006\u0010)\u001a\u00020'J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+H\u0002J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-H\u0002\u00a2\u0006\u0002\u0010.JM\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001a\u001a\u00020\u00042\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0004022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020004H\u0000\u00a2\u0006\u0002\b5R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00066"}, d2={"Lcom/intellij/ide/plugins/PluginSetBuilder;", "", "unsortedPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "(Ljava/util/Collection;)V", "", "(Ljava/util/Set;)V", "_moduleGraph", "Lcom/intellij/ide/plugins/ModuleGraphBase;", "builder", "Lcom/intellij/util/graph/DFSTBuilder;", "kotlin.jvm.PlatformType", "enabledModuleV2Ids", "Ljava/util/HashMap;", "", "enabledPluginIds", "Lcom/intellij/openapi/extensions/PluginId;", "moduleGraph", "Lcom/intellij/ide/plugins/SortedModuleGraph;", "getModuleGraph", "()Lcom/intellij/ide/plugins/SortedModuleGraph;", "getUnsortedPlugins", "()Ljava/util/Set;", "checkModules", "", "descriptor", "isDebugLogEnabled", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "checkPluginCycles", "errors", "", "Ljava/util/function/Supplier;", "computeEnabledModuleMap", "disabler", "Ljava/util/function/Predicate;", "createPluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "incompletePlugins", "createPluginSetWithEnabledModulesMap", "getEnabledModules", "", "getSortedPlugins", "", "()[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "initEnableState", "Lcom/intellij/ide/plugins/PluginLoadingError;", "idMap", "", "disabledPlugins", "", "initEnableState$intellij_platform_core_impl", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginSetBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginSetBuilder.kt\ncom/intellij/ide/plugins/PluginSetBuilder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,299:1\n1295#2:300\n1295#2,2:301\n1296#2:303\n179#2,2:308\n179#2,2:310\n37#3,2:304\n4307#4,2:306\n*S KotlinDebug\n*F\n+ 1 PluginSetBuilder.kt\ncom/intellij/ide/plugins/PluginSetBuilder\n*L\n55#1:300\n61#1:301,2\n55#1:303\n211#1:308,2\n219#1:310,2\n80#1:304,2\n153#1:306,2\n*E\n"})
public final class PluginSetBuilder {
    @NotNull
    private final Set<IdeaPluginDescriptorImpl> unsortedPlugins;
    @NotNull
    private final ModuleGraphBase _moduleGraph;
    @NotNull
    private final DFSTBuilder<IdeaPluginDescriptorImpl> builder;
    @NotNull
    private final SortedModuleGraph moduleGraph;
    @NotNull
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> enabledPluginIds;
    @NotNull
    private final HashMap<String, IdeaPluginDescriptorImpl> enabledModuleV2Ids;

    public PluginSetBuilder(@NotNull Set<IdeaPluginDescriptorImpl> unsortedPlugins) {
        Intrinsics.checkNotNullParameter(unsortedPlugins, (String)"unsortedPlugins");
        this.unsortedPlugins = unsortedPlugins;
        this._moduleGraph = ModuleGraphKt.createModuleGraph((Collection<IdeaPluginDescriptorImpl>)this.unsortedPlugins);
        this.builder = this._moduleGraph.builder();
        this.moduleGraph = this._moduleGraph.sorted$intellij_platform_core_impl(this.builder);
        this.enabledPluginIds = new HashMap(this.unsortedPlugins.size());
        this.enabledModuleV2Ids = new HashMap(this.unsortedPlugins.size() * 2);
    }

    @NotNull
    public final Set<IdeaPluginDescriptorImpl> getUnsortedPlugins() {
        return this.unsortedPlugins;
    }

    @NotNull
    public final SortedModuleGraph getModuleGraph() {
        return this.moduleGraph;
    }

    public PluginSetBuilder(@NotNull Collection<IdeaPluginDescriptorImpl> unsortedPlugins) {
        Intrinsics.checkNotNullParameter(unsortedPlugins, (String)"unsortedPlugins");
        this((Set<IdeaPluginDescriptorImpl>)new LinkedHashSet<IdeaPluginDescriptorImpl>(unsortedPlugins));
    }

    /*
     * WARNING - void declaration
     */
    public final void checkPluginCycles(@NotNull List<Supplier<String>> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        if (this.builder.isAcyclic()) {
            return;
        }
        for (Collection<IdeaPluginDescriptorImpl> component : this.builder.getComponents()) {
            void $this$forEach$iv;
            if (component.size() < 2) continue;
            for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : component) {
                ideaPluginDescriptorImpl.setEnabled(false);
            }
            Intrinsics.checkNotNullExpressionValue(component, (String)"component");
            String pluginsString2 = CollectionsKt.joinToString$default((Iterable)component, (CharSequence)", ", null, null, (int)0, null, (Function1)checkPluginCycles.pluginsString.1.INSTANCE, (int)30, null);
            Object[] objectArray = new Object[]{pluginsString2};
            errors.add(PluginSetBuilderKt.access$message("plugin.loading.error.plugins.cannot.be.loaded.because.they.form.a.dependency.cycle", objectArray));
            StringBuilder stringBuilder = new StringBuilder();
            Function1 pluginToString2 = checkPluginCycles.pluginToString.1.INSTANCE;
            stringBuilder.append("Detected plugin dependencies cycle details (only related dependencies are included):\n");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)component), (Function1)((Function1)new Function1<IdeaPluginDescriptorImpl, Pair<? extends IdeaPluginDescriptorImpl, ? extends String>>((Function1<? super IdeaPluginDescriptorImpl, String>)pluginToString2){
                final /* synthetic */ Function1<IdeaPluginDescriptorImpl, String> $pluginToString;
                {
                    this.$pluginToString = $pluginToString;
                    super(1);
                }

                @NotNull
                public final Pair<IdeaPluginDescriptorImpl, String> invoke(IdeaPluginDescriptorImpl it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return new Pair((Object)it, this.$pluginToString.invoke((Object)it));
                }
            }));
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> PluginSetBuilder.checkPluginCycles$lambda$0(checkPluginCycles.2.INSTANCE, arg_0), StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing({ it.second },\u2026g.CASE_INSENSITIVE_ORDER)");
            Sequence sequence2 = SequencesKt.sortedWith((Sequence)sequence, comparator);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                stringBuilder.append("  ").append((String)it.getSecond()).append(" depends on:\n");
                Object object = it.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                Sequence sequence3 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.moduleGraph.getDependencies((IdeaPluginDescriptorImpl)object)), (Function1)((Function1)new Function1<IdeaPluginDescriptorImpl, Boolean>(component){
                    final /* synthetic */ Collection<IdeaPluginDescriptorImpl> $component;
                    {
                        this.$component = $component;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull IdeaPluginDescriptorImpl o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        return this.$component.contains(o);
                    }
                })), (Function1)pluginToString2);
                Comparator comparator2 = String.CASE_INSENSITIVE_ORDER;
                Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"CASE_INSENSITIVE_ORDER");
                Sequence sequence4 = SequencesKt.sortedWith((Sequence)sequence3, (Comparator)comparator2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String dep = (String)element$iv2;
                    boolean bl2 = false;
                    stringBuilder.append("    ").append(dep).append("\n");
                }
            }
            PluginManagerCore.getLogger().info(stringBuilder.toString());
        }
    }

    private final IdeaPluginDescriptorImpl[] getSortedPlugins() {
        Object2IntOpenHashMap<PluginId> pluginToNumber = new Object2IntOpenHashMap<PluginId>(this.unsortedPlugins.size());
        pluginToNumber.put(PluginManagerCore.CORE_ID, 0);
        int number = 0;
        for (IdeaPluginDescriptorImpl module : this.moduleGraph.getNodes()) {
            if (module.descriptorPath == null && !module.content.modules.isEmpty()) continue;
            pluginToNumber.putIfAbsent(module.getPluginId(), number++);
        }
        Collection $this$toTypedArray$iv = this.unsortedPlugins;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] sorted = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        Arrays.sort(sorted, (arg_0, arg_1) -> PluginSetBuilder.getSortedPlugins$lambda$3(pluginToNumber, arg_0, arg_1));
        return sorted;
    }

    private final List<IdeaPluginDescriptorImpl> getEnabledModules() {
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>(this.moduleGraph.getNodes().size());
        for (IdeaPluginDescriptorImpl module : this.moduleGraph.getNodes()) {
            if (!(module.moduleName == null ? module.isEnabled() : this.enabledModuleV2Ids.containsKey(module.moduleName))) continue;
            result2.add(module);
        }
        return result2;
    }

    @NotNull
    public final PluginSetBuilder computeEnabledModuleMap(@Nullable Predicate<IdeaPluginDescriptorImpl> disabler) {
        ArrayList<String> logMessages = new ArrayList<String>();
        block0: for (IdeaPluginDescriptorImpl module : this.moduleGraph.getNodes()) {
            if (module.moduleName == null ? !Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID) && (!module.isEnabled() || disabler != null && disabler.test(module)) : !this.enabledPluginIds.containsKey(module.getPluginId())) continue;
            for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module.dependencies.modules) {
                if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
                String string2 = module.moduleName;
                logMessages.add("Module " + (string2 != null ? (Comparable)((Object)string2) : (Comparable)module.getPluginId()) + " is not enabled because dependency " + moduleReference.name + " is not available");
                continue block0;
            }
            for (ModuleDependenciesDescriptor.PluginReference pluginReference : module.dependencies.plugins) {
                if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
                String string3 = module.moduleName;
                logMessages.add("Module " + (string3 != null ? (Comparable)((Object)string3) : (Comparable)module.getPluginId()) + " is not enabled because dependency " + pluginReference.id + " is not available");
                continue block0;
            }
            if (module.moduleName == null) {
                this.enabledPluginIds.put(module.getPluginId(), module);
                for (PluginId pluginId : module.modules) {
                    this.enabledPluginIds.put(pluginId, module);
                }
                if (module.packagePrefix == null) continue;
                this.enabledModuleV2Ids.put(module.getPluginId().getIdString(), module);
                continue;
            }
            this.enabledModuleV2Ids.put(module.moduleName, module);
        }
        if (!logMessages.isEmpty()) {
            PluginManagerCore.getLogger().info(CollectionsKt.joinToString$default((Iterable)logMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        return this;
    }

    public static /* synthetic */ PluginSetBuilder computeEnabledModuleMap$default(PluginSetBuilder pluginSetBuilder, Predicate predicate, int n, Object object) {
        if ((n & 1) != 0) {
            predicate = null;
        }
        return pluginSetBuilder.computeEnabledModuleMap(predicate);
    }

    @NotNull
    public final PluginSet createPluginSetWithEnabledModulesMap() {
        return PluginSetBuilder.createPluginSet$default(PluginSetBuilder.computeEnabledModuleMap$default(this, null, 1, null), null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PluginSet createPluginSet(@NotNull Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(incompletePlugins, (String)"incompletePlugins");
        Object[] sortedPlugins = this.getSortedPlugins();
        LinkedHashSet allPlugins = new LinkedHashSet(sortedPlugins.length + incompletePlugins.size());
        CollectionsKt.addAll((Collection)allPlugins, (Object[])sortedPlugins);
        CollectionsKt.addAll((Collection)allPlugins, (Iterable)incompletePlugins);
        Object[] objectArray = sortedPlugins;
        Collection destination$iv = new ArrayList(sortedPlugins.length);
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv;
            void it = element$iv = $this$filterTo$iv[j];
            boolean bl = false;
            if (!it.isEnabled()) continue;
            destination$iv.add(element$iv);
        }
        ArrayList enabledPlugins = (ArrayList)destination$iv;
        Java11Shim java11Shim = Java11Shim.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)java11Shim, (String)"INSTANCE");
        Java11Shim java11Shim2 = java11Shim;
        ModuleGraph moduleGraph = this.moduleGraph;
        Set<IdeaPluginDescriptorImpl> set = java11Shim2.copyOf(allPlugins);
        Intrinsics.checkNotNullExpressionValue(set, (String)"java11Shim.copyOf(allPlugins)");
        List<IdeaPluginDescriptorImpl> list = java11Shim2.copyOfCollection(enabledPlugins);
        Intrinsics.checkNotNullExpressionValue(list, (String)"java11Shim.copyOfCollection(enabledPlugins)");
        Map<String, IdeaPluginDescriptorImpl> map2 = java11Shim2.copyOf((Map)this.enabledModuleV2Ids);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"java11Shim.copyOf(enabledModuleV2Ids)");
        Map<PluginId, IdeaPluginDescriptorImpl> map3 = java11Shim2.copyOf((Map)this.enabledPluginIds);
        Intrinsics.checkNotNullExpressionValue(map3, (String)"java11Shim.copyOf(enabledPluginIds)");
        List<IdeaPluginDescriptorImpl> list2 = java11Shim2.copyOfCollection((Collection)this.getEnabledModules());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"java11Shim.copyOfCollection(getEnabledModules())");
        return new PluginSet(moduleGraph, set, list, map2, map3, list2);
    }

    public static /* synthetic */ PluginSet createPluginSet$default(PluginSetBuilder pluginSetBuilder, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList()");
            collection = list;
        }
        return pluginSetBuilder.createPluginSet(collection);
    }

    public final void checkModules(@NotNull IdeaPluginDescriptorImpl descriptor2, boolean isDebugLogEnabled, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        block0: for (PluginContentDescriptor.ModuleItem item : descriptor2.content.modules) {
            for (ModuleDependenciesDescriptor.ModuleReference moduleReference : item.requireDescriptor().dependencies.modules) {
                if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
                if (!isDebugLogEnabled) continue block0;
                log.info("Module " + item.name + " is not enabled because dependency " + moduleReference.name + " is not available");
                continue block0;
            }
            for (ModuleDependenciesDescriptor.PluginReference pluginReference : item.requireDescriptor().dependencies.plugins) {
                if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
                if (!isDebugLogEnabled) continue block0;
                log.info("Module " + item.name + " is not enabled because dependency " + pluginReference.id + " is not available");
                continue block0;
            }
            this.enabledModuleV2Ids.put(item.name, descriptor2);
        }
    }

    @Nullable
    public final PluginLoadingError initEnableState$intellij_platform_core_impl(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<PluginId> disabledPlugins, @NotNull Map<PluginId, PluginLoadingError> errors) {
        PluginLoadingError pluginLoadingError;
        Object v7;
        Object object;
        boolean isNotifyUser;
        block9: {
            boolean bl;
            Object it;
            boolean $i$f$firstOrNull;
            block10: {
                Object object2;
                block12: {
                    Object dependencyPluginId;
                    block11: {
                        Object v3;
                        block8: {
                            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                            Intrinsics.checkNotNullParameter(idMap, (String)"idMap");
                            Intrinsics.checkNotNullParameter(disabledPlugins, (String)"disabledPlugins");
                            Intrinsics.checkNotNullParameter(errors, (String)"errors");
                            isNotifyUser = !descriptor2.isImplementationDetail();
                            for (PluginId pluginId : descriptor2.incompatibilities) {
                                if (!this.enabledPluginIds.containsKey(pluginId) || disabledPlugins.contains(pluginId)) continue;
                                String string2 = pluginId.getIdString();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"incompatibleId.idString");
                                String presentableName = string2;
                                Object[] objectArray = new Object[]{descriptor2.getName(), presentableName};
                                Supplier supplier = PluginSetBuilderKt.access$message("plugin.loading.error.long.ide.contains.conflicting.module", objectArray);
                                objectArray = new Object[]{presentableName};
                                return new PluginLoadingError(descriptor2, supplier, PluginSetBuilderKt.access$message("plugin.loading.error.short.ide.contains.conflicting.module", objectArray), isNotifyUser, null, 16, null);
                            }
                            Sequence sequence = PluginSetBuilderKt.access$getAllPluginDependencies(descriptor2);
                            $i$f$firstOrNull = false;
                            for (Object element$iv : sequence) {
                                it = (PluginId)element$iv;
                                bl = false;
                                boolean bl2 = !((Map)this.enabledPluginIds).containsKey(it);
                                if (!bl2) continue;
                                v3 = element$iv;
                                break block8;
                            }
                            v3 = null;
                        }
                        object = v3;
                        if (object == null) break block10;
                        dependencyPluginId = object;
                        boolean bl3 = false;
                        object2 = idMap.get(dependencyPluginId);
                        if (object2 == null) break block11;
                        IdeaPluginDescriptorImpl it2 = object2;
                        boolean bl32 = false;
                        PluginLoadingError pluginLoadingError2 = PluginSetBuilderKt.access$createTransitivelyDisabledError(descriptor2, it2, isNotifyUser);
                        object2 = pluginLoadingError2;
                        if (pluginLoadingError2 != null) break block12;
                    }
                    object2 = PluginSetBuilderKt.access$createCannotLoadError(descriptor2, (PluginId)dependencyPluginId, errors, isNotifyUser);
                }
                return object2;
            }
            Sequence sequence = PluginSetBuilderKt.access$getModuleDependencies(descriptor2);
            $i$f$firstOrNull = false;
            for (Object element$iv : sequence) {
                it = (String)element$iv;
                bl = false;
                boolean bl4 = !((Map)this.enabledModuleV2Ids).containsKey(it);
                if (!bl4) continue;
                v7 = element$iv;
                break block9;
            }
            v7 = null;
        }
        object = v7;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Object[] objectArray = new Object[]{descriptor2.getName(), it};
            Supplier supplier = PluginSetBuilderKt.access$message("plugin.loading.error.long.depends.on.not.installed.plugin", objectArray);
            objectArray = new Object[]{it};
            PluginLoadingError pluginLoadingError3 = new PluginLoadingError(descriptor2, supplier, PluginSetBuilderKt.access$message("plugin.loading.error.short.depends.on.not.installed.plugin", objectArray), isNotifyUser, null, 16, null);
            pluginLoadingError = pluginLoadingError3;
        } else {
            pluginLoadingError = null;
        }
        return pluginLoadingError;
    }

    private static final String checkPluginCycles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final int getSortedPlugins$lambda$3(Object2IntOpenHashMap $pluginToNumber, IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
        Intrinsics.checkNotNullParameter((Object)$pluginToNumber, (String)"$pluginToNumber");
        return $pluginToNumber.getInt(o1.getPluginId()) - $pluginToNumber.getInt(o2.getPluginId());
    }
}

